/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import maslab.orc.OrcAsyncConnection;
import maslab.orc.OrcCommandConnection;
import maslab.orc.OrcCommandService;
import maslab.orc.OrcPacket;
import maslab.orc.OrcUpdateListener;
import maslab.util.Logger;

public class Orc {
    protected Socket sock;
    protected InputStream ins;
    protected OutputStream outs;
    protected Logger log = new Logger(this);
    protected static final byte MASTER = 0;
    protected static final byte SLAVE = 64;
    protected static final byte PAD = -128;
    protected BlockingQueue<OrcCommandConnection> commandConnections;
    protected OrcCommandService commandService;
    protected OrcAsyncConnection asyncConnection;
    static final int NUM_CMD_HANDLERS = 3;
    public static final int BUTTON_STICK = 1;
    public static final int BUTTON_MENU = 2;
    public static final int BUTTON_STOP = 4;
    public static final int BUTTON_UP = 8;
    public static final int BUTTON_DOWN = 16;
    public static final int BUTTON_LEFT = 32;
    public static final int BUTTON_RIGHT = 64;
    String host;
    int cmdport;
    int asyncport;
    ArrayList<OrcUpdateListener> updateListeners = new ArrayList();
    int padOldUpDown = -1;
    int padOldLeftRight = -1;
    OrcPacketHolder masterHolder = new OrcPacketHolder();
    OrcPacketHolder slaveHolder = new OrcPacketHolder();
    OrcPacketHolder padHolder = new OrcPacketHolder();
    NotifyThread notifyThread = new NotifyThread();

    public Orc() {
        this("localhost", 7320, 7321);
    }

    public Orc(String host) {
        this(host, 7320, 7321);
    }

    public Orc(String host, int cmdport, int asyncport) {
        this.host = host;
        this.cmdport = cmdport;
        this.asyncport = asyncport;
        this.commandService = new OrcCommandService(this, 3);
        this.commandConnections = new LinkedBlockingQueue<OrcCommandConnection>();
        this.asyncConnection = new OrcAsyncConnection(this, host, asyncport);
        this.padHolder.maximumLatency = 1000L;
        this.notifyThread.start();
    }

    protected OrcPacket doTransaction(OrcPacket request) {
        OrcPacket response;
        int naks = 0;
        while ((response = this.commandService.doTransaction(request)) == null || response.buf.length < 4 || response.buf[3] != 0) {
            if (++naks < 10 || naks % 100 != 0) continue;
            this.log.warn("Repeated failures " + naks + " code=" + response.buf[3]);
            this.log.warn(" SENT: " + request.toString());
            this.log.warn(" RECV: " + response.toString());
        }
        return response;
    }

    protected MotorDirection codeToMotorDirection(int code) {
        switch (code) {
            case 0: {
                return MotorDirection.DISABLED;
            }
            case 1: {
                return MotorDirection.FORW;
            }
            case 2: {
                return MotorDirection.BACK;
            }
        }
        this.log.error("Bogus motor direction received");
        return MotorDirection.DISABLED;
    }

    public void setCacheLifetime(int ms) {
        this.masterHolder.maximumLatency = ms;
        this.slaveHolder.maximumLatency = ms;
        this.padHolder.maximumLatency = ms;
    }

    public MotorDirection motorGoalDirectionRead(int port) {
        assert (port >= 0 && port <= 3);
        int v = this.read8(this.slaveHolder, 25 + port / 2);
        v = (port & 1) == 0 ? (v &= 0xF) : v >> 4 & 0xF;
        return this.codeToMotorDirection(v & 3);
    }

    public MotorDirection motorActualDirectionRead(int port) {
        assert (port >= 0 && port <= 3);
        int v = this.read8(this.slaveHolder, 25 + port / 2);
        v = (port & 1) == 0 ? (v &= 0xF) : v >> 4 & 0xF;
        return this.codeToMotorDirection(v >> 2 & 3);
    }

    public int motorActualRead(int port) {
        assert (port >= 0 && port <= 3);
        return this.read8(this.slaveHolder, 14 + port * 3) * this.motorActualDirectionRead(port).getSign();
    }

    public int motorGoalRead(int port) {
        assert (port >= 0 && port <= 3);
        return this.read8(this.slaveHolder, 13 + port * 3) * this.motorGoalDirectionRead(port).getSign();
    }

    protected double voltageToCurrent(double senseVoltage) {
        return senseVoltage / 0.18;
    }

    public double motorCurrentRead(int port) {
        assert (port >= 0 && port <= 3);
        return this.voltageToCurrent(this.analogRead(20 + port));
    }

    public double servoCurrentRead(int port) {
        assert (port < 2);
        return this.voltageToCurrent(this.analogRead(24 + port));
    }

    protected int analogPortToRealPort(int port) {
        assert (port >= 0 && port < 26);
        int realport = 0;
        if (port < 16) {
            assert (port >= 8 || port == 0 || port == 3);
            if (port >= 8) {
                realport = port - 8;
            } else if (port == 0) {
                realport = 8;
            } else if (port == 3) {
                realport = 9;
            }
            return realport;
        }
        assert (port == 16 || port == 19 || port >= 20);
        realport = port == 16 ? 6 : (port == 19 ? 7 : port - 20);
        return realport + 256;
    }

    public double analogRead(int port) {
        int realport = this.analogPortToRealPort(port);
        if (realport < 256) {
            double v = this.read16(this.masterHolder, 16 + realport * 2);
            return v * 5.0 / 65535.0;
        }
        double v = this.read16(this.slaveHolder, 27 + (realport -= 256) * 2);
        return v * 5.0 / 65535.0;
    }

    public void analogLPFWrite(int port, int val) {
        int realport = this.analogPortToRealPort(port);
        if (port < 256) {
            this.doTransaction(new OrcPacket((byte)0, Character.valueOf('F'), realport, val));
        } else {
            this.doTransaction(new OrcPacket((byte)64, Character.valueOf('F'), realport -= 256, val));
        }
    }

    public int analogLPFRead(int port) {
        int realport = this.analogPortToRealPort(port);
        if (port < 256) {
            int v = this.read8(this.masterHolder, 36 + realport / 2);
            if ((realport & 1) == 0) {
                return v & 0xF;
            }
            return v >> 4 & 0xF;
        }
        int v = this.read8(this.slaveHolder, 43 + (realport -= 256) / 2);
        if ((realport & 1) == 0) {
            return v & 0xF;
        }
        return v >> 4 & 0xF;
    }

    public int dacRead(int port) {
        assert (port == 12);
        return this.read8(this.masterHolder, 57);
    }

    public void dacWrite(int port, int v) {
        assert (port == 12);
        this.doTransaction(new OrcPacket((byte)0, Character.valueOf('V'), v));
    }

    public boolean digitalRead(int port) {
        assert (port >= 0 && port <= 19);
        if (port < 16) {
            return (this.read16(this.masterHolder, 6) & 1 << port) > 0;
        }
        return (this.read8(this.slaveHolder, 6) & 1 << port - 16) > 0;
    }

    public void digitalWrite(int port, boolean v) {
        assert (port >= 0 && port <= 20);
        if (port < 16) {
            this.doTransaction(new OrcPacket((byte)0, Character.valueOf('D'), port, v ? 1 : 0));
        } else {
            this.doTransaction(new OrcPacket((byte)64, Character.valueOf('D'), port - 16, v ? 1 : 0));
        }
    }

    public int servoRead(int port) {
        assert (port >= 0 && port <= 3);
        return this.read16(this.masterHolder, 8 + port * 2);
    }

    public void servoWrite(int port, int v) {
        assert (port >= 0 && port <= 3);
        assert (v >= 0 && v <= 65535);
        this.doTransaction(new OrcPacket((byte)0, Character.valueOf('S'), port, v >> 8, v & 0xFF));
    }

    public void ultrasoundPing(int port) {
        assert (port == 4 || port == 6);
        this.doTransaction(new OrcPacket((byte)0, Character.valueOf('R'), port));
    }

    public double ultrasoundRange(int port) {
        assert (port == 5 || port == 7);
        int i = this.read16(this.masterHolder, 49 + port - 5);
        if (i == 65535) {
            return 0.0;
        }
        double seconds = (double)i / 1000000.0;
        double range = 33.146 * seconds / 2.0;
        return range;
    }

    public int ultrasoundPingCount(int port) {
        assert (port == 4 || port == 6);
        int i = this.read8(this.masterHolder, 53);
        if (port == 4) {
            return i & 0xF;
        }
        return i >> 4 & 0xF;
    }

    public void pinModeWrite(int port, PinMode m) {
        assert (port >= 0 && port <= 19);
        if (port < 16) {
            this.doTransaction(new OrcPacket((byte)0, Character.valueOf('C'), port, m.getCode()));
        } else {
            this.doTransaction(new OrcPacket((byte)64, Character.valueOf('C'), port - 16, m.getCode()));
        }
        this.log.output("Set port " + port + " to mode " + (Object)((Object)m));
    }

    public PinMode pinModeRead(int port) {
        int v;
        assert (port >= 0 && port <= 19);
        if (port < 16) {
            v = this.read8(this.masterHolder, 41 + port / 2);
            v = port % 2 == 0 ? (v &= 0xF) : v >> 4 & 0xF;
        } else {
            v = this.read8(this.slaveHolder, 4 + (port - 16) / 2);
            v = port % 2 == 0 ? (v &= 0xF) : v >> 4 & 0xF;
        }
        for (PinMode m : PinMode.values()) {
            if (m.getCode() != v) continue;
            return m;
        }
        this.log.error("Unknown mode type " + v + "!");
        return null;
    }

    public void pwmWrite(int port, int source, int period, int dutycycle) {
        this.doTransaction(new OrcPacket((byte)0, Character.valueOf('K'), 4, period, dutycycle));
    }

    public int pwmSourceRead(int port) {
        return this.read8(this.masterHolder, 54);
    }

    public int pwmPeriodRead(int port) {
        return this.read8(this.masterHolder, 55);
    }

    public int pwmDutyCycleRead(int port) {
        return this.read8(this.masterHolder, 56);
    }

    public int quadphaseErrorsRead(int port) {
        assert (port >= 16 && port <= 19);
        int i = port == 16 || port == 17 ? this.read8(this.slaveHolder, 9) : this.read8(this.slaveHolder, 12);
        return i;
    }

    public int quadphaseRead(int port) {
        assert (port >= 16 && port <= 19);
        int offset = port == 16 || port == 17 ? 7 : 10;
        return this.read16(this.slaveHolder, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadphaseStamped quadphaseReadTS(int port) {
        assert (port >= 16 && port <= 19);
        int offset = port == 16 || port == 17 ? 7 : 10;
        QuadphaseStamped tsd = new QuadphaseStamped();
        OrcPacketHolder orcPacketHolder = this.slaveHolder;
        synchronized (orcPacketHolder) {
            tsd.timestamp = ((this.slaveHolder.packet.buf[48] & 0xFF) << 8) + (this.slaveHolder.packet.buf[49] & 0xFF);
            tsd.qp = ((this.slaveHolder.packet.buf[offset] & 0xFF) << 8) + (this.slaveHolder.packet.buf[offset + 1] & 0xFF);
        }
        return tsd;
    }

    public void allStop() {
        this.doTransaction(new OrcPacket((byte)0, Character.valueOf('X')));
    }

    public void motorWrite(int port, int pwm, MotorDirection dir) {
        assert (port >= 0 && port <= 3);
        assert (pwm >= 0 && pwm <= 255);
        this.doTransaction(new OrcPacket((byte)64, Character.valueOf('M'), port, dir.getCode(), pwm));
    }

    public void motorWrite(int port, int pwm) {
        assert (port >= 0 && port <= 3);
        assert (pwm >= -255 && pwm <= 255);
        if (pwm >= 0) {
            this.motorWrite(port, pwm, MotorDirection.FORW);
        } else {
            this.motorWrite(port, -pwm, MotorDirection.BACK);
        }
    }

    public void motorSlewWrite(int port, int slew) {
        assert (port >= 0 && port <= 3);
        assert (slew >= 1 && slew <= 255);
        this.doTransaction(new OrcPacket((byte)64, Character.valueOf('W'), port, slew));
    }

    public int motorSlewRead(int port) {
        assert (port >= 0 && port <= 3);
        return this.read8(this.slaveHolder, 15 + port * 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int padButtonsGet() {
        int v = 0;
        OrcPacketHolder orcPacketHolder = this.padHolder;
        synchronized (orcPacketHolder) {
            while (v == 0 && (v = this.padButtonsPoll()) <= 0) {
                try {
                    this.padHolder.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this.padButtonsPoll() != 0) {
                try {
                    this.padHolder.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return v;
    }

    public int padButtonsPoll() {
        int newUpDown = this.read8(this.padHolder, 7);
        int newLeftRight = this.read8(this.padHolder, 8);
        int v = this.read8(this.padHolder, 6);
        if (this.padOldUpDown != -1) {
            if ((newUpDown & 0xF0) != (this.padOldUpDown & 0xF0)) {
                v |= 8;
            }
            if ((newUpDown & 0xF) != (this.padOldUpDown & 0xF)) {
                v |= 0x10;
            }
            if ((newLeftRight & 0xF0) != (this.padOldLeftRight & 0xF0)) {
                v |= 0x20;
            }
            if ((newLeftRight & 0xF) != (this.padOldLeftRight & 0xF)) {
                v |= 0x40;
            }
        }
        this.padOldUpDown = newUpDown;
        this.padOldLeftRight = newLeftRight;
        return v;
    }

    public int joyX() {
        return this.read8(this.padHolder, 4);
    }

    public int joyY() {
        return this.read8(this.padHolder, 5);
    }

    public void lcdClear() {
        this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('C')));
    }

    public void lcdConsoleGoto(int x, int y) {
        this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('G'), x, y));
    }

    public void lcdConsoleWrite(String s) {
        int thislen;
        int len = s.length();
        int maxlen = 32;
        for (int pos = 0; pos < len; pos += thislen) {
            thislen = maxlen;
            if (thislen + pos > len) {
                thislen = len - pos;
            }
            byte[] data = s.substring(pos, pos + thislen).getBytes();
            this.doTransaction(new OrcPacket(data, data.length, new Object[]{(byte)-128, Character.valueOf('W')}));
        }
    }

    public void lcdFill(int even, int odd) {
        this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('F'), even, odd));
    }

    public void lcdDrawLine(int x0, int y0, int x1, int y1) {
        this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('L'), x0, y0, x1, y1));
    }

    public void lcdConsoleHome() {
        this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('H')));
    }

    public void lcdConsoleSettings(int top, int height, int left, int width) {
        this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('S'), top, height, left, width));
    }

    public void lcdDrawMode(DrawMode dm) {
        this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('M'), dm.getCode()));
    }

    public void lcdDrawText(LcdFont font, int x, int y, String s) {
        byte[] data = s.getBytes();
        int len = data.length;
        if (len > 32) {
            len = 32;
        }
        this.doTransaction(new OrcPacket(data, len, new Object[]{(byte)-128, Character.valueOf('T'), x, y, font.getCode()}));
    }

    public void lcdRead(int x, int y, int length, byte[] buf, int offset) {
        OrcPacket resp = this.doTransaction(new OrcPacket((byte)-128, Character.valueOf('r'), x, y, length));
        for (int i = 0; i < length; ++i) {
            buf[offset + i] = resp.buf[4 + i];
        }
    }

    public void lcdWrite(int x, int y, byte[] buf, int blocksize) {
        OrcPacket resp = this.doTransaction(new OrcPacket(buf, blocksize, new Object[]{(byte)-128, Character.valueOf('R'), x, y}));
    }

    public BufferedImage lcdRead() {
        BufferedImage bi = new BufferedImage(128, 64, 10);
        int xstride = 32;
        int ystride = 8;
        byte[] buf = new byte[xstride];
        for (int y = 0; y < 64; y += ystride) {
            for (int x = 0; x < 128; x += xstride) {
                this.lcdRead(x, y, xstride, buf, 0);
                for (int xi = 0; xi < xstride; ++xi) {
                    int b = buf[xi];
                    for (int yi = 0; yi < 8; ++yi) {
                        bi.setRGB(x + xi, y + yi, (b & 1) > 0 ? 0 : -1);
                        b >>= 1;
                    }
                }
            }
        }
        return bi;
    }

    public void lcdWrite(int xi, int yi, BufferedImage i) {
        assert (0 <= xi && xi <= 127);
        assert (0 <= yi && yi <= 63);
        int w = i.getWidth();
        int h = i.getHeight();
        int maxblocksize = 32;
        byte[] data = new byte[maxblocksize];
        for (int y0 = 0; y0 < h; y0 += 8) {
            if (yi + y0 > 56) continue;
            for (int x0 = 0; x0 < w; x0 += maxblocksize) {
                if (xi + x0 > 128 - maxblocksize) continue;
                int thisblocksize = maxblocksize;
                if (x0 + thisblocksize >= w) {
                    thisblocksize = w - x0;
                }
                for (int xt = 0; xt < thisblocksize; ++xt) {
                    int acc = 0;
                    for (int yt = 7; yt >= 0; --yt) {
                        int p = 0;
                        if (x0 + xt < w && y0 + yt < h) {
                            p = i.getRGB(x0 + xt, y0 + yt);
                        }
                        p = (p & 0xFF00) != 0 ? 0 : 1;
                        acc = acc << 1 | p;
                    }
                    data[xt] = (byte)acc;
                }
                this.lcdWrite(xi + x0, yi + y0, data, thisblocksize);
            }
        }
    }

    public int clockRead() {
        return this.clockReadMaster();
    }

    public int clockReadSlave() {
        return this.read16(this.slaveHolder, 48);
    }

    public int clockReadMaster() {
        return this.read16(this.masterHolder, 4);
    }

    public void stepperEnable(int port, boolean enable) {
        assert (port >= 0 && port <= 1);
        this.doTransaction(new OrcPacket((byte)64, Character.valueOf('T'), port, enable ? 1 : 0));
    }

    public void stepperWrite(int port, double radpersec) {
        int v = (int)(radpersec * 65535.0 / (Math.PI * 2) / 64.0);
        assert (port >= 0 && port <= 1);
        this.doTransaction(new OrcPacket((byte)64, Character.valueOf('R'), port, v >> 8 & 0xFF, v & 0xFF));
    }

    public int stepperPosition(int port) {
        return this.read16(this.slaveHolder, 54 + port * 2);
    }

    public long gyroReadRaw() {
        return this.read32(this.masterHolder, 58);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GyroStamped gyroReadRawStamped() {
        GyroStamped gs = new GyroStamped();
        OrcPacketHolder orcPacketHolder = this.masterHolder;
        synchronized (orcPacketHolder) {
            gs.timestamp = ((this.masterHolder.packet.buf[4] & 0xFF) << 8) + (this.masterHolder.packet.buf[5] & 0xFF);
            int realport = this.analogPortToRealPort(14);
            gs.temp = ((this.masterHolder.packet.buf[16 + realport * 2] & 0xFF) << 8) + (this.masterHolder.packet.buf[16 + realport * 2 + 1] & 0xFF);
            gs.temp = gs.temp * 5.0 / 65535.0;
            gs.gyro = ((this.masterHolder.packet.buf[58] & 0xFF) << 24) + ((this.masterHolder.packet.buf[59] & 0xFF) << 16) + ((this.masterHolder.packet.buf[60] & 0xFF) << 8) + (this.masterHolder.packet.buf[61] & 0xFF);
        }
        return gs;
    }

    public boolean i2cRead(int addr, byte[] buf, int len) {
        OrcPacket resp = this.doTransaction(new OrcPacket((byte)0, Character.valueOf('i'), addr, len));
        if (resp.buf[3] != 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            buf[i] = resp.buf[4 + i];
        }
        return true;
    }

    public boolean i2cWrite(int addr, byte[] buf, int len) {
        OrcPacket req = new OrcPacket(buf, len, new Object[]{(byte)0, Character.valueOf('I'), addr});
        OrcPacket resp = this.doTransaction(req);
        return resp.buf[3] == 0;
    }

    public boolean i2cWriteRead(int addr, byte[] writebuf, int writelen, byte[] readbuf, int readlen) {
        OrcPacket req = new OrcPacket(writebuf, writelen, new Object[]{(byte)0, Character.valueOf('J'), addr, readlen});
        OrcPacket resp = this.doTransaction(req);
        if (resp.buf[3] != 0) {
            return false;
        }
        for (int i = 0; i < readlen; ++i) {
            readbuf[i] = resp.buf[4 + i];
        }
        return true;
    }

    public static int udiff16(long a, long b) {
        if (a >= b) {
            return (int)(a - b);
        }
        return (int)(65535L - b + a);
    }

    public static int diff16(long a, long b) {
        long SIZE = 65536L;
        long MAX = SIZE - 1L;
        long d = (a &= MAX) - (b &= MAX);
        if (d < -SIZE / 2L) {
            return (int)(SIZE + d);
        }
        if (d > SIZE / 2L) {
            return -((int)(SIZE - d));
        }
        return (int)d;
    }

    public static long diff32(long a, long b) {
        long SIZE = 0x100000000L;
        long MAX = SIZE - 1L;
        long d = (a &= MAX) - (b &= MAX);
        if (d < -SIZE / 2L) {
            return SIZE + d;
        }
        if (d > SIZE / 2L) {
            return -(SIZE - d);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uptodate(OrcPacketHolder h) {
        OrcPacketHolder orcPacketHolder = h;
        synchronized (orcPacketHolder) {
            long time = System.currentTimeMillis();
            while (time - h.time > h.maximumLatency || h.packet == null || h.packet.buf == null) {
                try {
                    h.wait();
                }
                catch (InterruptedException ex) {}
            }
        }
    }

    protected int read8(OrcPacketHolder ph, int offset) {
        this.uptodate(ph);
        return ph.packet.buf[offset] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read16(OrcPacketHolder ph, int offset) {
        OrcPacketHolder orcPacketHolder = ph;
        synchronized (orcPacketHolder) {
            this.uptodate(ph);
            OrcPacket p = ph.packet;
            return ((p.buf[offset] & 0xFF) << 8) + (p.buf[offset + 1] & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read32(OrcPacketHolder ph, int offset) {
        OrcPacketHolder orcPacketHolder = ph;
        synchronized (orcPacketHolder) {
            this.uptodate(ph);
            OrcPacket p = ph.packet;
            return ((p.buf[offset] & 0xFF) << 24) + ((p.buf[offset + 1] & 0xFF) << 16) + ((p.buf[offset + 2] & 0xFF) << 8) + (p.buf[offset + 3] & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateListener(OrcUpdateListener ul) {
        ArrayList<OrcUpdateListener> arrayList = this.updateListeners;
        synchronized (arrayList) {
            if (!this.updateListeners.contains(ul)) {
                this.updateListeners.add(ul);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateListener(OrcUpdateListener ul) {
        ArrayList<OrcUpdateListener> arrayList = this.updateListeners;
        synchronized (arrayList) {
            if (this.updateListeners.contains(ul)) {
                this.updateListeners.remove(ul);
            }
        }
    }

    protected void notifyUpdateListeners() {
        this.notifyThread.update();
    }

    class NotifyThread
    extends Thread {
        public NotifyThread() {
            this.setDaemon(true);
        }

        public synchronized void update() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = this;
                synchronized (object) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                object = Orc.this.updateListeners;
                synchronized (object) {
                    for (OrcUpdateListener ul : Orc.this.updateListeners) {
                        ul.orcUpdated(Orc.this);
                    }
                }
            }
        }
    }

    public class GyroStamped {
        public long gyro;
        public double temp;
        public long timestamp;
    }

    public class QuadphaseStamped {
        public int qp;
        public long timestamp;
    }

    static class OrcPacketHolder {
        long time = -1L;
        OrcPacket packet = null;
        long maximumLatency = 50L;

        OrcPacketHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MotorDirection {
        FORW(1),
        BACK(2),
        DISABLED(0);

        private int code;

        private MotorDirection(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public int getSign() {
            if (this == FORW) {
                return 1;
            }
            if (this == BACK) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PinMode {
        DIGITAL_IN("Dig In", 0),
        DIGITAL_IN_PULLUP("Dig In (Pull Up)", 1),
        DIGITAL_IN_PULLDOWN("Dig In (Pull Dn)", 2),
        DIGITAL_OUT("Dig Out", 3),
        DIGITAL_OUT_SLOW("Dig Out (Slow)", 4),
        SERVO("Servo", 5),
        PWM("PWM", 10),
        SONAR_PING("Sonar Ping", 6),
        SONAR_ECHO("Sonar Echo", 7),
        ANALOG_IN("Analog In", 8),
        ANALOG_OUT("Analog Out", 9),
        QUADPHASE("Quad Phase", 11),
        QUADPHASEFAST("Quad Phase Fast", 14),
        MONOPHASE("Mono Phase", 12);

        private int val;
        private String s;

        private PinMode(String s, int val) {
            this.val = val;
            this.s = s;
        }

        public int getCode() {
            return this.val;
        }

        public String toString() {
            return this.s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LcdFont {
        TINY(65),
        TINY_INV(97),
        SMALL(66),
        SMALL_INV(98),
        MEDIUM(67),
        MEDIUM_INV(99),
        LARGE(68),
        LARGE_INV(100);

        int val;

        private LcdFont(int val) {
            this.val = val;
        }

        public int getCode() {
            return this.val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DrawMode {
        ERASE(0),
        DRAW(1),
        XOR(2);

        int val;

        private DrawMode(int val) {
            this.val = val;
        }

        public int getCode() {
            return this.val;
        }
    }
}

