/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import maslab.orc.Orc;
import maslab.util.Logger;

public class MotorMD22 {
    Orc orc;
    int addr;
    Logger log = new Logger(this);
    int acceleration;

    public MotorMD22(Orc orc) {
        this(orc, 88);
    }

    public MotorMD22(Orc orc, int addr) {
        this.orc = orc;
        this.addr = addr;
        this.setMode();
    }

    public int readRevision() {
        byte[] req = new byte[]{7};
        byte[] resp = new byte[1];
        boolean res = this.orc.i2cWriteRead(this.addr, req, req.length, resp, resp.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return 0;
        }
        return resp[0] & 0xFF;
    }

    protected void setMode() {
        byte[] req = new byte[]{0, 0};
        boolean res = this.orc.i2cWrite(this.addr, req, req.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return;
        }
    }

    public void motorWrite(int motor, int speed) {
        int v = (speed + 256) / 2;
        byte[] req = new byte[]{(byte)(1 + motor), (byte)v};
        boolean res = this.orc.i2cWrite(this.addr, req, req.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return;
        }
    }

    public void motorSlewRate(int port, int slew) {
        double timePerPWM = 0.01562 / (double)slew;
        int md22slew = (int)(timePerPWM / 6.4E-5);
        if (md22slew < 1) {
            md22slew = 0;
        }
        if (md22slew > 255) {
            md22slew = 255;
        }
        this.motorSlewRate(md22slew);
    }

    protected void motorSlewRate(int slew) {
        byte[] req = new byte[]{3, (byte)slew};
        boolean res = this.orc.i2cWrite(this.addr, req, req.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return;
        }
    }

    public static void main(String[] args) {
        Orc o = new Orc();
        MotorMD22 md22 = new MotorMD22(o);
        int rev = md22.readRevision();
        System.out.println("Got revision: " + rev);
        md22.motorSlewRate(20);
        md22.motorWrite(0, 255);
        MotorMD22.safeSleep(1000);
        md22.motorWrite(0, -255);
        MotorMD22.safeSleep(1000);
        md22.motorWrite(0, 255);
        MotorMD22.safeSleep(1000);
        md22.motorWrite(0, 128);
        MotorMD22.safeSleep(1000);
        md22.motorWrite(0, 0);
        MotorMD22.safeSleep(1000);
        md22.motorWrite(0, -128);
        MotorMD22.safeSleep(1000);
        md22.motorWrite(0, -255);
        MotorMD22.safeSleep(1000);
        md22.motorWrite(0, 0);
        md22.motorWrite(1, 0);
    }

    public static void safeSleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

