/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import maslab.orc.Orc;

public class Motor {
    Orc orc;
    int motorport;
    int quadphaseport;
    boolean motorflip;
    boolean quadflip;
    int lastencoder = 0;
    int encoderCounts = 0;
    long absoluteCounts = 0L;

    public Motor(Orc orc, int motorport, boolean motorflip) {
        this.orc = orc;
        this.motorport = motorport;
        this.motorflip = motorflip;
        this.quadphaseport = -1;
        this.quadflip = false;
    }

    public Motor(Orc orc, int motorport, boolean motorflip, int quadphaseport, boolean quadflip) {
        this(orc, motorport, motorflip, quadphaseport, quadflip, Orc.PinMode.QUADPHASE);
    }

    public Motor(Orc orc, int motorport, boolean motorflip, int quadphaseport, boolean quadflip, Orc.PinMode m) {
        this.orc = orc;
        this.motorport = motorport;
        this.motorflip = motorflip;
        this.quadphaseport = quadphaseport;
        this.quadflip = quadflip;
        orc.pinModeWrite(quadphaseport, m);
        if (m != Orc.PinMode.MONOPHASE) {
            orc.pinModeWrite(quadphaseport + 1, m);
        }
        UpdateThread ut = new UpdateThread();
        ut.start();
    }

    public void set(int pwm) {
        if (this.motorflip) {
            pwm = -pwm;
        }
        if (pwm > 255) {
            pwm = 255;
        }
        if (pwm < -255) {
            pwm = -255;
        }
        this.orc.motorWrite(this.motorport, pwm);
    }

    public int get() {
        int pwm = this.orc.motorActualRead(this.motorport);
        if (this.motorflip) {
            pwm = -pwm;
        }
        return pwm;
    }

    public int getGoal() {
        int pwm = this.orc.motorGoalRead(this.motorport);
        if (this.motorflip) {
            pwm = -pwm;
        }
        return pwm;
    }

    public double current() {
        return this.orc.motorCurrentRead(this.motorport);
    }

    public synchronized int encoder() {
        if (this.quadphaseport == -1) {
            return 0;
        }
        this.updateEncoder();
        int value = this.encoderCounts;
        this.encoderCounts = 0;
        return value;
    }

    public synchronized long encoderAbsolute() {
        this.updateEncoder();
        return this.absoluteCounts;
    }

    synchronized void updateEncoder() {
        int thisencoder = this.orc.quadphaseRead(this.quadphaseport);
        int delta = Orc.diff16(thisencoder, this.lastencoder);
        this.lastencoder = thisencoder;
        if (this.quadflip) {
            delta = -delta;
        }
        this.encoderCounts += delta;
        this.absoluteCounts += (long)delta;
    }

    public static void main(String[] args) {
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            System.out.println("Couldn't connect to orc.");
            return;
        }
        System.out.println("Assuming there's a motor on port 0...");
        BufferedReader ins = new BufferedReader(new InputStreamReader(System.in));
        Motor mot = new Motor(orc, 0, false, 16, false);
        while (true) {
            String line = "";
            try {
                System.out.print("Set pwm to: ");
                line = ins.readLine();
                int pwm = Integer.parseInt(line);
                mot.set(pwm);
            }
            catch (Exception ex) {
                System.out.println("Huh?");
            }
            System.out.println("PWM:     " + mot.get());
            System.out.println("Current: " + mot.current());
            System.out.println("Encoder: " + mot.encoder());
        }
    }

    class UpdateThread
    extends Thread {
        public UpdateThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(250L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

