/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import maslab.orc.Orc;
import maslab.orc.RangeSensor;

public class IRRangeSensor
implements RangeSensor {
    Orc orc;
    int port;
    double Xd;
    double Xm;
    double Xb;
    double arcAngle = 0.08;
    double voltageVariance = 0.005;

    public void setParameters(double Xd, double Xm, double Xb) {
        this.Xd = Xd;
        this.Xm = Xm;
        this.Xb = Xb;
    }

    public void setParameters(double Xd, double Xm, double Xb, double arcAngle, double voltageVariance) {
        this.Xd = Xd;
        this.Xm = Xm;
        this.Xb = Xb;
        this.arcAngle = arcAngle;
        this.voltageVariance = voltageVariance;
    }

    public static IRRangeSensor make2Y0A02(Orc orc, int port) {
        IRRangeSensor s = new IRRangeSensor(orc, port);
        s.Xd = -0.0618;
        s.Xm = 0.7389;
        s.Xb = -0.1141;
        s.arcAngle = 0.08;
        s.voltageVariance = 0.005;
        return s;
    }

    public static IRRangeSensor makeGP2D12(Orc orc, int port) {
        IRRangeSensor s = new IRRangeSensor(orc, port);
        s.Xd = 0.0828;
        s.Xm = 0.1384;
        s.Xb = 0.2448;
        s.arcAngle = 0.08;
        s.voltageVariance = 0.005;
        return s;
    }

    public IRRangeSensor(Orc orc, int port) {
        this.orc = orc;
        this.port = port;
        orc.pinModeWrite(port, Orc.PinMode.ANALOG_IN);
    }

    public double getRange() {
        double v = this.orc.analogRead(this.port);
        double range = this.Xm / (v - this.Xb) + this.Xd;
        if (range < 0.0 || range > 100.0) {
            return 100.0;
        }
        return range;
    }

    public double getRangeUncertainty() {
        double v = this.orc.analogRead(this.port);
        double dddV = Math.abs(-this.Xm / (v - this.Xb) / (v - this.Xb));
        return this.voltageVariance / (dddV * dddV);
    }

    public double getArcAngle() {
        return this.arcAngle;
    }
}

