/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import java.util.ArrayList;
import java.util.Arrays;
import maslab.orc.Orc;
import maslab.util.Logger;
import maslab.util.MathUtil;

public class Gyro {
    Orc orc;
    int port;
    GyroThread gyroThread;
    protected double gyroTheta = 0.0;
    public double gyroCorrectionPerTick = 625.0;
    public double mvPerDegreePerSecond = 5.0;
    protected long gyroLastTime = 0L;
    protected long gyroLastValue = 0L;
    Logger log = new Logger(this);
    public double thermalcoefficient = -0.0833333;
    public boolean enableThermalCompensation = true;
    public boolean enableBuiltinCompensation = true;
    public double Cthermcoeff = -0.08194;
    public double Coffset = 2.548688;
    public double Cthermref = 2.5;
    public double lastnull = 0.0;

    public Gyro(Orc orc) {
        this(orc, 15);
    }

    public Gyro(Orc orc, int port) {
        this.orc = orc;
        this.port = port;
        this.gyroThread = new GyroThread();
        this.gyroThread.start();
        orc.pinModeWrite(port, Orc.PinMode.ANALOG_IN);
        this.calibrate(50);
        this.gyroTheta = 0.0;
    }

    public void setRateConstant(double mvPerDegreePerSecond) {
        this.mvPerDegreePerSecond = mvPerDegreePerSecond;
    }

    public synchronized double calibrate(int ms) {
        long starttime = this.orc.clockRead();
        long startvalue = this.orc.gyroReadRaw();
        long endtime = starttime;
        int tempTrials = 0;
        double tempAccumulator = 0.0;
        while (Orc.udiff16(endtime, starttime) <= 4 * ms) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            tempAccumulator += this.orc.analogRead(14);
            ++tempTrials;
            endtime = this.orc.clockRead();
        }
        long endvalue = this.orc.gyroReadRaw();
        double deltavalue = Orc.diff32(endvalue, startvalue);
        double deltatime = Orc.udiff16(endtime, starttime);
        if (this.enableThermalCompensation) {
            double predictnull;
            double nowTemp = tempAccumulator / (double)tempTrials;
            this.lastnull = predictnull = (nowTemp - this.Cthermref) * this.Cthermcoeff + this.Coffset;
            double tempdelta = (predictnull - 2.5) * 65535.0 / 5.0 * deltatime;
            deltavalue -= tempdelta;
        }
        this.gyroCorrectionPerTick = deltavalue / deltatime;
        this.log.output("dtime: " + deltatime);
        this.log.output("dval:  " + deltavalue);
        this.log.output("Gyro Correction: " + this.gyroCorrectionPerTick);
        this.log.output("(Nominal voltage: " + (this.gyroCorrectionPerTick * 5.0 / 65535.0 + 2.5));
        this.gyroTheta = 0.0;
        this.gyroLastTime = endtime;
        this.gyroLastValue = endvalue;
        return this.gyroCorrectionPerTick;
    }

    public synchronized double calibrateMedian(int ms) {
        long endvalue;
        long starttime = this.orc.clockRead();
        long startvalue = this.orc.gyroReadRaw();
        long endtime = starttime;
        boolean tempTrials = false;
        double tempAccumulator = 0.0;
        ArrayList<Double> dsa = new ArrayList<Double>();
        while (Orc.udiff16(endtime, starttime) <= 4 * ms) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            double v = this.orc.analogRead(15);
            v = 13107.0 * v - 32768.0;
            endtime = this.orc.clockRead();
            dsa.add(new Double(v));
        }
        double[] ds = new double[dsa.size()];
        for (int i = 0; i < dsa.size(); ++i) {
            ds[i] = (Double)dsa.get(i);
        }
        Arrays.sort(ds);
        int median = ds.length / 2;
        this.gyroCorrectionPerTick = ds[median];
        this.gyroTheta = 0.0;
        this.gyroLastTime = endtime;
        this.gyroLastValue = endvalue = this.orc.gyroReadRaw();
        return this.gyroCorrectionPerTick;
    }

    public double getRadians() {
        this.update();
        return this.gyroTheta;
    }

    public void reset() {
        this.gyroTheta = 0.0;
    }

    protected synchronized void update() {
        long thistime = this.orc.clockRead();
        long thisvalue = this.orc.gyroReadRaw();
        int timedelta = Orc.udiff16(thistime, this.gyroLastTime);
        double nowTemp = this.orc.analogRead(14);
        double delta = Orc.diff32(thisvalue, this.gyroLastValue);
        double thisnull = 0.0;
        if (this.enableThermalCompensation) {
            double predictnull;
            thisnull = predictnull = (nowTemp - this.Cthermref) * this.Cthermcoeff + this.Coffset;
            double tempdelta = (predictnull - 2.5) * 65535.0 / 5.0 * (double)timedelta;
            delta -= tempdelta;
        }
        if (this.enableBuiltinCompensation) {
            delta -= this.gyroCorrectionPerTick * (double)timedelta;
            thisnull += this.gyroCorrectionPerTick * 5.0 / 65535.0;
        }
        this.lastnull = thisnull;
        double angledelta = -delta * 5.0 / 4000.0 / this.mvPerDegreePerSecond * 1000.0 / 65535.0 / 180.0 * Math.PI;
        this.gyroTheta += angledelta;
        double degdelta = angledelta * 180.0 / Math.PI;
        this.gyroTheta = MathUtil.mod2pi(this.gyroTheta);
        this.gyroLastValue = thisvalue;
        this.gyroLastTime = thistime;
    }

    class GyroThread
    extends Thread {
        public GyroThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Gyro.this.update();
            }
        }
    }
}

