/*
 * Decompiled with CFR 0.152.
 */
package maslab.orc;

import maslab.orc.Orc;
import maslab.util.Logger;

public class CompassCMPS03 {
    Orc orc;
    int addr;
    Logger log = new Logger(this);

    public CompassCMPS03(Orc orc, int addr) {
        this.orc = orc;
        this.addr = addr;
    }

    public CompassCMPS03(Orc orc) {
        this(orc, 96);
    }

    public int readRevision() {
        byte[] req = new byte[]{0};
        byte[] resp = new byte[1];
        boolean res = this.orc.i2cWriteRead(this.addr, req, req.length, resp, resp.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return 0;
        }
        return resp[0] & 0xFF;
    }

    public void calibrate() {
        byte[] req = new byte[]{15, -1};
        boolean res = this.orc.i2cWrite(this.addr, req, req.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return;
        }
    }

    public double readDegrees() {
        byte[] req = new byte[]{2};
        byte[] resp = new byte[2];
        boolean res = this.orc.i2cWriteRead(this.addr, req, req.length, resp, resp.length);
        if (!res) {
            this.log.error("I2C transaction failed");
            return 0.0;
        }
        int v = (resp[0] & 0xFF) * 256 + (resp[1] & 0xFF);
        return (double)v / 10.0;
    }

    public static void main(String[] args) {
        Orc orc;
        try {
            orc = new Orc();
        }
        catch (Exception ex) {
            return;
        }
        CompassCMPS03 compass = new CompassCMPS03(orc);
        int revision = compass.readRevision();
        System.out.println("rev = " + revision);
        while (true) {
            double v = compass.readDegrees();
            System.out.println("" + v);
        }
    }
}

