/*
 * Decompiled with CFR 0.152.
 */
package maslab.laser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;
import maslab.data.Clock;
import maslab.laser.LaserDataSource;
import maslab.laser.LaserScanData;
import maslab.util.Logger;

public class Sick
extends LaserDataSource {
    Socket sock;
    ReaderThread reader;
    Logger log = new Logger(this);
    Clock clock;

    public Sick(Clock clock, String channelname) {
        super(channelname);
        this.clock = clock;
        this.reader = new ReaderThread("localhost", 7322);
        this.reader.setDaemon(true);
        this.reader.start();
    }

    public static void main(String[] args) {
        Clock clock = new Clock();
        try {
            Sick s = new Sick(clock, "LASER");
        }
        catch (Exception ex) {
            System.out.println("couldn't create sick " + ex);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    class ReaderThread
    extends Thread {
        Socket sock;
        String host;
        int port;

        ReaderThread(String host, int port) {
            this.host = host;
            this.port = port;
            this.sock = null;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.sock = new Socket(this.host, this.port);
                        this.runReal();
                    }
                }
                catch (IOException ex) {
                    Sick.this.log.warn("Reconnecting");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }

        public void runReal() throws IOException {
            BufferedReader ins = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            while (true) {
                int i;
                String s = ins.readLine();
                double timeStamp = Sick.this.clock.getTime();
                if (s == null) {
                    System.out.println("lost connection to sickd.");
                    return;
                }
                StringTokenizer st = new StringTokenizer(s);
                if (!st.hasMoreTokens()) continue;
                String slength = st.nextToken();
                int length = Integer.parseInt(slength, 16);
                double[] ranges = new double[length];
                for (i = 0; i < length && st.hasMoreTokens(); ++i) {
                    ranges[i] = (double)Integer.parseInt(st.nextToken(), 16) / 1000.0;
                }
                if (i != length) {
                    System.out.println("not enough data");
                    continue;
                }
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < ranges.length; ++j) {
                    sb.append(String.format("%.3f", ranges[j]));
                    if (j == ranges.length - 1) continue;
                    sb.append(" ");
                }
                sb.append("\n");
                Sick.this.notifyLogWriters(timeStamp, sb.toString());
                LaserScanData scan = Sick.this.stringToEvent(timeStamp, sb.toString());
                Sick.this.notifyDataListeners(scan);
            }
        }
    }
}

