/*
 * Decompiled with CFR 0.152.
 */
package maslab.laser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import maslab.data.Clock;
import maslab.data.DataEvent;
import maslab.data.DataListener;
import maslab.data.DataSource;
import maslab.geom.GPoint2D;
import maslab.laser.LaserScanData;
import maslab.laser.Sick;

public class LaserView
extends JFrame
implements DataListener {
    static final long serialVersionUID = 1001L;
    LaserCanvas canvas;
    JPanel controls;
    JSlider scaleSlider;
    JLabel scaleLabel;
    double scale = 4.0;
    JLabel hertzLabel;
    int hertzCount = Integer.MAX_VALUE;
    long hertzLastMillis = 0L;

    public LaserView(DataSource s) {
        this.canvas = new LaserCanvas();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.canvas, "Center");
        this.controls = new JPanel();
        this.getContentPane().add((Component)this.controls, "South");
        this.scaleSlider = new JSlider(1, 32, 4);
        this.scaleSlider.setPaintLabels(true);
        this.scaleSlider.addChangeListener(new ScaleSliderChangeListener());
        this.controls.add(this.scaleSlider);
        this.scaleLabel = new JLabel("Scale: 4m");
        this.controls.add(this.scaleLabel);
        this.hertzLabel = new JLabel("0 Hz");
        this.controls.add(this.hertzLabel);
        this.setSize(400, 300);
        this.setVisible(true);
        s.addDataListener(this);
    }

    public void processDataEvent(DataSource ds, DataEvent de) {
        if (!(de instanceof LaserScanData)) {
            return;
        }
        LaserScanData scan = (LaserScanData)de;
        this.canvas.setData(scan);
        this.canvas.repaint();
        ++this.hertzCount;
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.hertzLastMillis;
        if (this.hertzCount > 60 || elapsedTime > 2000L) {
            double fps = 1000.0 * (double)this.hertzCount / (double)elapsedTime;
            fps = (double)((int)(10.0 * fps)) / 10.0;
            this.hertzLabel.setText("" + fps + " Hz");
            this.hertzCount = 0;
            this.hertzLastMillis = currentTime;
        }
    }

    public static void main(String[] args) {
        int medianfilter = 3;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--filter=")) {
                medianfilter = Integer.parseInt(args[i].substring(9));
            }
            if (!args[i].equals("--help") && !args[i].equals("-h")) continue;
            LaserView.doHelp();
            return;
        }
        Clock clock = new Clock();
        try {
            Sick s = new Sick(clock, "LASER");
            LaserView lv = new LaserView(s);
        }
        catch (Exception ex) {
            System.out.println("Couldn't open laserview, " + ex);
        }
    }

    protected static void doHelp() {
        System.out.println(" --help          Show this");
        System.out.println(" --filter=n      Use a temporal low pass filter of order n (1,3,5)");
    }

    public class LaserCanvas
    extends JPanel {
        LaserScanData scan;
        double fieldOfView = Math.PI;
        static final long serialVersionUID = 1001L;

        public synchronized void paint(Graphics g) {
            int i;
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(Color.black);
            g.fillRect(0, 0, width, height);
            if (this.scan == null) {
                return;
            }
            g.drawOval(10, 10, 20, 20);
            double theta = 1.5707963267948966;
            int cx = width / 2;
            int cy = height - 10;
            double maxradius = Math.min(width / 2, height);
            double radiusscale = maxradius / LaserView.this.scale;
            int lastx = 0;
            int lasty = 0;
            boolean firsttime = true;
            g.setFont(new Font("Helvetica", 0, 10));
            int maxscale = (int)(Math.sqrt(Math.pow(width / 2, 2.0) + Math.pow(height, 2.0)) / radiusscale);
            for (i = 0; i <= maxscale; ++i) {
                int radius = (int)(radiusscale * (double)i);
                if (i % 5 == 0) {
                    g.setColor(Color.blue);
                } else {
                    g.setColor(Color.darkGray);
                }
                g.drawOval(cx - radius, cy - radius, 2 * radius, 2 * radius);
                g.setColor(Color.blue);
                g.drawString("" + i, cx + radius, cy);
                g.drawString("" + i, cx - radius, cy);
            }
            g.setColor(Color.yellow);
            for (i = 0; i < this.scan.points.size(); ++i) {
                GPoint2D p = this.scan.points.get(i);
                double rot = 1.5707963267948966;
                p = p.transform(0.0, 0.0, rot);
                int x = cx + (int)(radiusscale * p.getX());
                int y = cy - (int)(radiusscale * p.getY());
                if (firsttime) {
                    firsttime = false;
                } else {
                    g.drawLine(x, y, lastx, lasty);
                }
                lastx = x;
                lasty = y;
            }
        }

        public void setData(LaserScanData scan) {
            this.scan = scan;
            this.invalidate();
        }
    }

    class ScaleSliderChangeListener
    implements ChangeListener {
        ScaleSliderChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            LaserView.this.scale = LaserView.this.scaleSlider.getValue();
            LaserView.this.scaleLabel.setText("Scale: " + (int)LaserView.this.scale + "m");
        }
    }
}

