/*
 * Decompiled with CFR 0.152.
 */
package maslab.laser;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import maslab.data.DataEvent;
import maslab.geom.GPoint2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaserScanData
extends DataEvent
implements Serializable {
    public static final long serialVersionUID = 1001L;
    public ArrayList<GPoint2D> points;

    public LaserScanData() {
    }

    public LaserScanData(double timeStamp) {
        super(timeStamp);
    }

    public LaserScanData(double timeStamp, ArrayList<GPoint2D> points) {
        super(timeStamp);
        this.points = points;
    }

    public ArrayList<GPoint2D> getPoints() {
        return this.points;
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.points = new ArrayList();
        int cnt = in.readInt();
        this.timeStamp = in.readDouble();
        for (int i = 0; i < cnt; ++i) {
            GPoint2D p = new GPoint2D();
            p.readExternal(in);
            this.points.add(p);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.points.size());
        out.writeDouble(this.timeStamp);
        for (GPoint2D p : this.points) {
            p.writeExternal(out);
        }
    }
}

