/*
 * Decompiled with CFR 0.152.
 */
package maslab.laser;

import java.util.ArrayList;
import maslab.data.DataSource;
import maslab.data.SimpleProperties;
import maslab.geom.GPoint2D;
import maslab.laser.LaserScanData;
import maslab.util.Logger;

public class LaserDataSource
extends DataSource {
    protected double theta0 = 1.5707963267948966;
    protected double theta1 = -1.5707963267948966;
    protected int nsamples = 181;
    protected double maxRange = 25.0;
    protected double verticalMisalignment = 0.0;
    protected double scale = 1.0;
    protected double xoff;
    protected double yoff;
    Logger log = new Logger(this);
    boolean[] omit;

    public LaserDataSource(String channelName) {
        super(channelName);
    }

    public LaserScanData stringToEvent(double timestamp, String data) {
        String[] toks = LaserDataSource.fsplit(data, this.nsamples);
        if (toks.length != this.nsamples) {
            this.log.error("Incorrect number of samples (got " + toks.length + ", expected " + this.nsamples + ")");
            return null;
        }
        ArrayList<GPoint2D> points = new ArrayList<GPoint2D>(this.nsamples);
        try {
            double theta = this.theta0;
            double dtheta = (this.theta1 - this.theta0) / (double)(this.nsamples - 1);
            int i = 0;
            while (i < this.nsamples) {
                double range = LaserDataSource.parseDouble(toks[i]) * this.scale;
                if (!((range *= Math.cos(this.verticalMisalignment)) > this.maxRange) && !this.omit[i]) {
                    double x = Math.cos(theta) * range + this.xoff;
                    double y = Math.sin(theta) * range + this.yoff;
                    GPoint2D p = new GPoint2D(x, y);
                    points.add(p);
                }
                ++i;
                theta += dtheta;
            }
        }
        catch (Exception ex) {
            this.log.error("Invalid data", ex);
            return null;
        }
        return new LaserScanData(timestamp, points);
    }

    public String getParameters() {
        return String.format("theta0=%f theta1=%f dtheta=%f nsamples=%i maxRange=%f verticalMisalignment=%f scale=%f xoff=%f yoff=%f", this.theta0, this.theta1, this.nsamples, this.maxRange, this.verticalMisalignment, this.scale, this.xoff, this.yoff);
    }

    public void setParameters(String s) {
        block7: {
            SimpleProperties sp = this.parseProperties(s);
            try {
                this.theta0 = sp.requireDouble("theta0");
                this.theta1 = sp.requireDouble("theta1");
                this.nsamples = sp.requireInt("nsamples");
                this.maxRange = sp.requireDouble("maxRange");
                this.xoff = sp.getDouble("xoff", 0.0);
                this.yoff = sp.getDouble("yoff", 0.0);
                this.verticalMisalignment = sp.getDouble("verticalMisalignment", 0.0);
                this.scale = sp.getDouble("scale", 1.0);
                String vin = sp.getString("omit", "");
                String[] vs = vin.split(",");
                this.omit = new boolean[this.nsamples];
                if (vin.length() <= 0) break block7;
                try {
                    for (String v : vs) {
                        if (v.indexOf("-") >= 0) {
                            String[] tf = v.split("-");
                            int start = Integer.parseInt(tf[0]);
                            int from = Integer.parseInt(tf[1]);
                            for (int i = start; i <= from; ++i) {
                                this.omit[i] = true;
                            }
                            continue;
                        }
                        int i = Integer.parseInt(v);
                        this.omit[i] = true;
                    }
                }
                catch (Exception ex) {
                    this.log.error("Invalid number format in chn file: " + vin, ex);
                }
            }
            catch (RuntimeException ex) {
                this.log.error("Missing required data field.", ex);
            }
        }
    }
}

