/*
 * Decompiled with CFR 0.152.
 */
package maslab.examples;

import java.io.IOException;
import maslab.orc.Gyro;
import maslab.orc.IRRangeSensor;
import maslab.orc.Motor;
import maslab.orc.Orc;
import maslab.orc.Servo;
import maslab.telemetry.JugLoggerPublisher;
import maslab.util.Logger;
import maslab.util.StringUtil;

public class SimpleRobot {
    Orc orc = new Orc();
    Motor leftMotor = new Motor(this.orc, 0, true);
    Motor rightMotor = new Motor(this.orc, 1, false);
    Gyro gyro = new Gyro(this.orc);
    IRRangeSensor forwardIR = IRRangeSensor.makeGP2D12(this.orc, 8);
    Servo servo = Servo.makeHitecHS300(this.orc, 0);
    Logger log = new Logger(this);
    JugLoggerPublisher logPublisher = new JugLoggerPublisher("LogMessage");
    static final long RUNTIME = 25L;

    public static void main(String[] args) {
        SimpleRobot robot;
        try {
            robot = new SimpleRobot();
        }
        catch (Exception ex) {
            System.out.println("Couldn't start: " + ex);
            return;
        }
        robot.run();
    }

    public SimpleRobot() throws IOException {
        this.logPublisher.setLevel("SimpleRobot", 4);
    }

    public void run() {
        long starttime = System.currentTimeMillis();
        this.orc.lcdConsoleHome();
        this.orc.lcdConsoleWrite("Calibrating gyro...");
        this.gyro.calibrate(1000);
        this.orc.lcdConsoleWrite("done.\n");
        this.orc.lcdConsoleWrite("Starting...\n");
        double lastReportedTime = 0.0;
        boolean driving = false;
        while (true) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            double time = (double)(System.currentTimeMillis() - starttime) / 1000.0;
            if (time > 25.0) break;
            if (time > lastReportedTime + 1.0) {
                double timeRemaining = 25.0 - time;
                this.orc.lcdDrawText(Orc.LcdFont.TINY_INV, 112, 8, StringUtil.padLeft("" + (int)timeRemaining, 4, ' '));
                lastReportedTime += 1.0;
            }
            double range = this.forwardIR.getRange();
            if (driving) {
                this.log.output("range = " + String.format("%.2f", range) + ". driving");
            } else {
                this.log.output("range = " + StringUtil.formatDouble(range, 2) + ". stopped");
            }
            if (range > 0.35) {
                driving = true;
                this.leftMotor.set(200);
                this.rightMotor.set(200);
                this.servo.seek(0.0);
                continue;
            }
            if (!driving) continue;
            this.orc.lcdConsoleWrite("Look out!\n");
            driving = false;
            this.leftMotor.set(0);
            this.rightMotor.set(0);
            this.servo.seek(5.0);
        }
        this.orc.lcdConsoleWrite("Stopping! Press a key...\n");
        this.leftMotor.set(0);
        this.rightMotor.set(0);
        this.orc.padButtonsGet();
    }
}

