/*
 * Decompiled with CFR 0.152.
 */
package maslab.examples;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import maslab.camera.Camera;
import maslab.orc.Orc;
import maslab.util.ImageUtil;
import maslab.util.Logger;

public class PadCam {
    public static void main(String[] args) {
        Camera cam;
        Logger log = new Logger("PadCam");
        Orc orc = new Orc();
        try {
            cam = new Camera();
        }
        catch (IOException ex) {
            log.error("Couldn't open camera", ex);
            return;
        }
        cam.setCaptureSettings(160, 120, 30);
        orc.lcdClear();
        while (orc.padButtonsPoll() == 0) {
            double width = 128.0;
            BufferedImage bi = cam.capture(null);
            double aspect = (double)bi.getWidth() / (double)bi.getHeight();
            double height = width / aspect;
            if (height > 56.0) {
                height = 56.0;
                width = aspect * height;
            }
            bi = PadCam.scaleImage(bi, (int)width, (int)height);
            BufferedImage dith = ImageUtil.ditherImage(bi);
            orc.lcdWrite(0, 8, dith);
        }
        log.output("Quitting");
    }

    public static BufferedImage scaleImage(BufferedImage in, int width, int height) {
        BufferedImage out = new BufferedImage(width, height, in.getType());
        Graphics2D g = out.createGraphics();
        g.drawImage(in, 0, 0, width, height, null);
        return out;
    }
}

