/*
 * Decompiled with CFR 0.152.
 */
package maslab.camera;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import maslab.util.ImageUtil;
import maslab.util.Logger;
import maslab.util.StringUtil;
import maslab.util.ZipExtractor;

public class Camera {
    Logger log = new Logger(this);
    public static final int WB_INDOOR = 0;
    public static final int WB_OUTDOOR = 1;
    public static final int WB_FLOURESCENT = 2;
    public static final int WB_MANUAL = 3;
    public static final int WB_AUTO = 4;
    protected int ref = -1;

    protected static native int camera_open(String var0);

    protected static native void camera_close(int var0);

    protected static native void camera_capture(int var0, int[] var1);

    protected static native void camera_set_capture_settings(int var0, int var1, int var2, int var3);

    protected static native int camera_get_width(int var0);

    protected static native int camera_get_height(int var0);

    protected static native int camera_get_fps(int var0);

    protected static native void camera_set_white_balance(int var0, int var1, int var2, int var3);

    protected static native int camera_get_white_balance(int var0, int var1);

    protected static native void camera_set_led(int var0, int var1, int var2);

    protected static native int camera_get_led_on(int var0);

    protected static native int camera_get_led_off(int var0);

    protected static native void camera_set_quality(int var0, int var1);

    protected static native int camera_get_quality(int var0);

    protected static native void camera_set_contour(int var0, int var1);

    protected static native int camera_get_contour(int var0);

    protected static native void camera_set_backlight(int var0, int var1);

    protected static native int camera_get_backlight(int var0);

    protected static native void camera_set_flicker(int var0, int var1);

    protected static native int camera_get_flicker(int var0);

    protected static native void camera_set_noisereduction(int var0, int var1);

    protected static native int camera_get_noisereduction(int var0);

    protected static native void camera_set_gain(int var0, int var1);

    protected static native int camera_get_gain(int var0);

    protected static native void camera_set_shutter(int var0, int var1);

    protected static native void rgb_to_hsv(int[] var0, int var1, int var2);

    protected static native void rgb_to_rgv(int[] var0, int var1, int var2);

    protected static native void channel_select(int[] var0, int var1, int var2, int var3);

    protected static native void camera_set_user(int var0);

    protected static native void camera_get_user(int var0);

    protected static native void camera_get_factory(int var0);

    public Camera() throws IOException {
        if (this.ref < 0) {
            this.ref = Camera.camera_open("/dev/video");
        }
        if (this.ref < 0) {
            this.ref = Camera.camera_open("/dev/video0");
        }
        if (this.ref < 0) {
            this.ref = Camera.camera_open("/dev/video1");
        }
        if (this.ref < 0) {
            throw new IOException("Unable to connect to camera.");
        }
    }

    public Camera(String devname) throws IOException {
        this.ref = Camera.camera_open(devname);
        if (this.ref < 0) {
            throw new IOException("Unable to connect to camera " + devname);
        }
    }

    public synchronized void close() {
        Camera.camera_close(this.ref);
        this.ref = -1;
    }

    public synchronized BufferedImage createImage() {
        int width = Camera.camera_get_width(this.ref);
        int height = Camera.camera_get_height(this.ref);
        BufferedImage bi = new BufferedImage(width, height, 1);
        return bi;
    }

    public BufferedImage capture() {
        return this.capture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage capture(BufferedImage image) {
        Thread.yield();
        Camera camera = this;
        synchronized (camera) {
            if (image == null) {
                image = this.createImage();
            }
            if (image.getWidth(null) != this.getWidth() || image.getHeight(null) != this.getHeight()) {
                this.log.output("Resizing input buffer (slow)");
                image = this.createImage();
            }
            DataBufferInt dbuf = (DataBufferInt)image.getRaster().getDataBuffer();
            int[] buf = dbuf.getData();
            Camera.camera_capture(this.ref, buf);
        }
        return image;
    }

    public synchronized void setCaptureSettings(int width, int height, int fps) {
        Camera.camera_set_capture_settings(this.ref, width, height, fps);
    }

    public synchronized int getWidth() {
        return Camera.camera_get_width(this.ref);
    }

    public synchronized int getHeight() {
        return Camera.camera_get_height(this.ref);
    }

    public synchronized int getFps() {
        return Camera.camera_get_fps(this.ref);
    }

    public synchronized void setWhiteBalanceMode(int mode) {
        Camera.camera_set_white_balance(this.ref, mode, 0, 0);
    }

    public synchronized int getWhiteBalanceMode() {
        return Camera.camera_get_white_balance(this.ref, 0);
    }

    public synchronized int getWhiteBalanceRed() {
        return Camera.camera_get_white_balance(this.ref, 1);
    }

    public synchronized int getWhiteBalanceBlue() {
        return Camera.camera_get_white_balance(this.ref, 2);
    }

    public synchronized void setWhiteBalanceManual(int red, int blue) {
        Camera.camera_set_white_balance(this.ref, 3, red, blue);
    }

    public synchronized void setLed(int onTime, int offTime) {
        Camera.camera_set_led(this.ref, onTime, offTime);
    }

    public synchronized int getLedOn() {
        return Camera.camera_get_led_on(this.ref);
    }

    public synchronized int getLedOff() {
        return Camera.camera_get_led_off(this.ref);
    }

    public synchronized void getFactory() {
        Camera.camera_get_factory(this.ref);
    }

    public synchronized void getUser() {
        Camera.camera_get_user(this.ref);
    }

    public synchronized void setUser() {
        Camera.camera_set_user(this.ref);
    }

    public synchronized void setQuality(int value) {
        Camera.camera_set_quality(this.ref, value);
    }

    public synchronized int getQuality() {
        return Camera.camera_get_quality(this.ref);
    }

    public synchronized void setContour(int value) {
        Camera.camera_set_contour(this.ref, value);
    }

    public synchronized int getContour() {
        return Camera.camera_get_quality(this.ref);
    }

    public synchronized void setBacklightCompensation(boolean value) {
        Camera.camera_set_backlight(this.ref, value ? 1 : 0);
    }

    public synchronized boolean getBacklightCompensation() {
        return Camera.camera_get_backlight(this.ref) != 0;
    }

    public synchronized void setFlicker(boolean value) {
        Camera.camera_set_flicker(this.ref, value ? 1 : 0);
    }

    public synchronized boolean getFlicker() {
        return Camera.camera_get_flicker(this.ref) != 0;
    }

    public synchronized void setNoiseReduction(int value) {
        Camera.camera_set_noisereduction(this.ref, value);
    }

    public synchronized int getNoiseReduction() {
        return Camera.camera_get_noisereduction(this.ref);
    }

    public synchronized void setGain(int value) {
        Camera.camera_set_gain(this.ref, value);
    }

    public synchronized int getGain() {
        return Camera.camera_get_gain(this.ref);
    }

    public synchronized void setShutter(int value) {
        Camera.camera_set_shutter(this.ref, value);
    }

    public static BufferedImage rgbToHsv(BufferedImage image) {
        image = ImageUtil.convertImage(image, 1);
        DataBufferInt dbuf = (DataBufferInt)image.getRaster().getDataBuffer();
        int[] buf = dbuf.getData();
        Camera.rgb_to_hsv(buf, image.getWidth(null), image.getHeight(null));
        return image;
    }

    public static BufferedImage rgbToRgv(BufferedImage image) {
        image = ImageUtil.convertImage(image, 1);
        DataBufferInt dbuf = (DataBufferInt)image.getRaster().getDataBuffer();
        int[] buf = dbuf.getData();
        Camera.rgb_to_rgv(buf, image.getWidth(null), image.getHeight(null));
        return image;
    }

    public static BufferedImage channelSelect(BufferedImage image, int channel) {
        image = ImageUtil.convertImage(image, 1);
        DataBufferInt dbuf = (DataBufferInt)image.getRaster().getDataBuffer();
        int[] buf = dbuf.getData();
        Camera.channel_select(buf, image.getWidth(null), image.getHeight(null), channel);
        return image;
    }

    static {
        String loadedPath = "";
        String[] candidatepaths = new String[]{"/opt/maslab/lib/libcamera.so", "maslab/camera/native/libcamera.so", "src/maslab/camera/native/libcamera.so", "/tmp/libcamera.so"};
        boolean loaded = false;
        if (!loaded) {
            String cp = System.getProperty("java.class.path");
            String[] items = StringUtil.split(cp, ":");
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].endsWith("maslab.jar") || !new File(items[i]).exists()) continue;
                try {
                    ZipExtractor ze = new ZipExtractor(items[i]);
                    ze.saveResource("libcamera/libcamera.so", "/tmp/libcamera.so");
                    System.load("/tmp/libcamera.so");
                    loaded = true;
                    loadedPath = "/tmp/libcamera.so";
                    break;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if (!loaded) {
            for (int i = 0; i < candidatepaths.length; ++i) {
                File f = new File(candidatepaths[i]);
                if (!f.exists()) continue;
                String p = f.getAbsolutePath();
                System.load(p);
                loadedPath = p;
                loaded = true;
                break;
            }
        }
        if (!loaded) {
            throw new RuntimeException("Unable to load native camera library");
        }
        System.out.println("Using camera library: " + loadedPath);
    }
}

