/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;

public class DigitalOutput {
    Orc orc;
    int port;
    boolean invert;

    public DigitalOutput(Orc orc, int n) {
        this(orc, n, false);
    }

    public DigitalOutput(Orc orc, int n, boolean bl) {
        this.orc = orc;
        this.port = n;
        this.invert = bl;
        if (n < 8) {
            orc.doCommand(24576, new byte[]{(byte)n, 0, 0});
        } else {
            orc.doCommand(28672, new byte[]{(byte)(n - 8), 2, 0, 0, 0, 0});
        }
    }

    public void setValue(boolean bl) {
        if (this.port < 8) {
            this.orc.doCommand(24577, new byte[]{(byte)this.port, (byte)(bl ^ this.invert ? 1 : 0)});
        } else {
            this.orc.doCommand(28672, new byte[]{(byte)(this.port - 8), 2, 0, 0, 0, (byte)(bl ^ this.invert ? 1 : 0)});
        }
    }

    public static void main(String[] stringArray) {
        Orc orc = Orc.makeOrc();
        DigitalOutput digitalOutput = new DigitalOutput(orc, 0);
        while (true) {
            try {
                while (true) {
                    digitalOutput.setValue(true);
                    System.out.println("true");
                    Thread.sleep(1000L);
                    digitalOutput.setValue(false);
                    System.out.println("false");
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

