/*
 * Decompiled with CFR 0.152.
 */
package orc;

import orc.Orc;
import orc.OrcStatus;

public class AnalogInput {
    Orc orc;
    int port;

    public AnalogInput(Orc orc, int n) {
        assert (n >= 0 && n <= 7);
        this.orc = orc;
        this.port = n;
    }

    public double getVoltage() {
        OrcStatus orcStatus = this.orc.getStatus();
        return (double)orcStatus.analogInputFiltered[this.port] / 65535.0 * 5.0;
    }

    public double getVoltageUnfiltered() {
        OrcStatus orcStatus = this.orc.getStatus();
        return (double)orcStatus.analogInput[this.port] / 65535.0 * 5.0;
    }

    public void setLPF(double d) {
        assert (d >= 0.0 && d <= 1.0);
        int n = (int)(d * 65536.0);
        this.orc.doCommand(12288, new byte[]{(byte)this.port, (byte)(n >> 8 & 0xFF), (byte)(n >> 0 & 0xFF)});
    }
}

