/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.CameraDevice;
import com.googlecode.javacv.GNImageAligner;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.ProCamTransformer;
import com.googlecode.javacv.ProjectorDevice;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

public class ReflectanceInitializer {
    private static ThreadLocal<opencv_core.CvMat> mat3x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<opencv_core.CvMat> mat3x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private GNImageAligner.Settings alignerSettings;
    private int smoothingSize;
    private double reflectanceMin;
    private CameraDevice cameraDevice;
    private ProjectorDevice projectorDevice;
    private opencv_core.IplImage[] projectorImages;

    public ReflectanceInitializer(CameraDevice cameraDevice, ProjectorDevice projectorDevice, int channels, GNImageAligner.Settings alignerSettings) {
        this(cameraDevice, projectorDevice, channels, alignerSettings, 51, 0.01);
    }

    public ReflectanceInitializer(CameraDevice cameraDevice, ProjectorDevice projectorDevice, int channels, GNImageAligner.Settings alignerSettings, int smoothingSize, double reflectanceMin) {
        this.alignerSettings = alignerSettings;
        this.smoothingSize = smoothingSize;
        this.reflectanceMin = reflectanceMin;
        this.cameraDevice = cameraDevice;
        this.projectorDevice = projectorDevice;
        this.projectorImages = new opencv_core.IplImage[3];
        for (int i = 0; i < this.projectorImages.length; ++i) {
            this.projectorImages[i] = opencv_core.IplImage.create(projectorDevice.imageWidth, projectorDevice.imageHeight, 32, channels);
        }
        opencv_core.cvSetZero(this.projectorImages[0]);
        opencv_core.cvSet(this.projectorImages[1], opencv_core.CvScalar.ONE);
        opencv_core.CvMat H = mat3x3.get();
        projectorDevice.getRectifyingHomography(cameraDevice, H);
        JavaCV.fractalTriangleWave(this.projectorImages[2], H);
    }

    public opencv_core.IplImage[] getProjectorImages() {
        return this.projectorImages;
    }

    public opencv_core.IplImage initializeReflectance(opencv_core.IplImage[] cameraImages, double[] roiPts, double[] ambientLight) {
        int w = cameraImages[0].width();
        int h = cameraImages[0].height();
        int channels = cameraImages[0].nChannels();
        opencv_core.IplImage roiMask = opencv_core.IplImage.create(w, h, 8, 1);
        opencv_core.cvSetZero(roiMask);
        opencv_core.cvFillConvexPoly(roiMask, new opencv_core.CvPoint(16, roiPts), 4, opencv_core.CvScalar.WHITE, 8, 16);
        opencv_core.IplImage float1 = cameraImages[0];
        opencv_core.IplImage float2 = cameraImages[1];
        opencv_core.IplImage reflectance = float2.clone();
        opencv_imgproc.cvSmooth(float1, float1, 2, this.smoothingSize, 0, 0.0, 0.0);
        opencv_imgproc.cvSmooth(float2, float2, 2, this.smoothingSize, 0, 0.0, 0.0);
        opencv_core.cvSub(float2, float1, float2, null);
        opencv_core.CvMat p = mat3x1.get();
        opencv_core.CvMat invp = mat3x3.get();
        p.put(1.0, 1.0, 1.0);
        opencv_core.cvMatMul(this.projectorDevice.colorMixingMatrix, p, p);
        invp.put(1.0 / p.get(0), 0.0, 0.0, 0.0, 1.0 / p.get(1), 0.0, 0.0, 0.0, 1.0 / p.get(2));
        opencv_core.cvTransform(float2, float2, invp, null);
        FloatBuffer fb1 = float1.getFloatBuffer();
        FloatBuffer fb2 = float2.getFloatBuffer();
        ByteBuffer rmb = roiMask.getByteBuffer();
        assert (fb1.capacity() == fb2.capacity() / 3);
        assert (fb1.capacity() == rmb.capacity() / 3);
        int[] nPixels = new int[channels];
        int i = 0;
        for (int j = 0; j < fb1.capacity(); j += channels) {
            for (int z = 0; z < channels; ++z) {
                float ra = fb1.get(j + z);
                float r = fb2.get(j + z);
                float a = ra / r;
                fb1.put(j + z, a);
                if (rmb.get(i) == 0 || !((double)r > this.reflectanceMin)) continue;
                int n = z;
                nPixels[n] = nPixels[n] + 1;
                int n2 = z;
                ambientLight[n2] = ambientLight[n2] + (double)a;
            }
            ++i;
        }
        for (int z = 0; z < channels; ++z) {
            ambientLight[z] = nPixels[z] == 0 ? 0.0 : ambientLight[z] / (double)nPixels[z];
        }
        opencv_core.cvAddS(float1, opencv_core.cvScalar(p.get(0), p.get(1), p.get(2), 0.0), float1, null);
        opencv_core.cvDiv(reflectance, float1, reflectance, 1.0);
        opencv_core.cvNot(roiMask, roiMask);
        opencv_imgproc.cvErode(roiMask, roiMask, null, 15);
        opencv_core.cvSet(reflectance, opencv_core.CvScalar.ZERO, roiMask);
        return reflectance;
    }

    public opencv_core.CvMat initializePlaneParameters(opencv_core.IplImage[] cameraImages, opencv_core.IplImage reflectance, double[] roiPts, double[] ambientLight) {
        int iterations;
        ProCamTransformer transformer = new ProCamTransformer(roiPts, this.cameraDevice, this.projectorDevice, null);
        transformer.setProjectorImage(this.projectorImages[2], this.alignerSettings.pyramidLevels);
        ProCamTransformer.Parameters parameters = transformer.createParameters();
        parameters.set(11, 1.0);
        for (int i = 0; i < ambientLight.length; ++i) {
            parameters.set(12 + i, ambientLight[i]);
        }
        GNImageAligner aligner = new GNImageAligner(transformer, parameters, reflectance, roiPts, cameraImages[2], this.alignerSettings);
        double[] delta = new double[parameters.size() + 1];
        boolean converged = false;
        long iterationsStartTime = System.currentTimeMillis();
        for (iterations = 0; !converged && iterations < 100; ++iterations) {
            converged = aligner.iterate(delta);
        }
        parameters = (ProCamTransformer.Parameters)aligner.getParameters();
        Logger.getLogger(ReflectanceInitializer.class.getName()).info("iteratingTime = " + (System.currentTimeMillis() - iterationsStartTime) + "  iterations = " + iterations + "  objectiveRMSE = " + (float)aligner.getRMSE());
        return parameters.getSrcN();
    }
}

