/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacv.ImageTransformer;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.ProjectiveDevice;
import com.googlecode.javacv.cpp.cvkernels;
import com.googlecode.javacv.cpp.opencv_calib3d;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.DoubleBuffer;

public class ProjectiveTransformer
implements ImageTransformer {
    private static ThreadLocal<opencv_core.CvMat> H3x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> pts4x1 = opencv_core.CvMat.createThreadLocal(4, 1, 6, 2);
    private opencv_core.CvMat K1 = null;
    private opencv_core.CvMat K2 = null;
    private opencv_core.CvMat invK1 = null;
    private opencv_core.CvMat invK2 = null;
    private opencv_core.CvMat R = null;
    private opencv_core.CvMat t = null;
    private opencv_core.CvMat n = null;
    private double[] referencePoints1 = null;
    private double[] referencePoints2 = null;
    private opencv_core.CvScalar fillColor = opencv_core.cvScalar(0.0, 0.0, 0.0, 1.0);

    public ProjectiveTransformer(opencv_core.CvMat K1, opencv_core.CvMat K2, opencv_core.CvMat R, opencv_core.CvMat t, opencv_core.CvMat n, double[] referencePoints1, double[] referencePoints2) {
        this.K1 = K1 == null ? null : K1.clone();
        this.K2 = K2 == null ? null : K2.clone();
        this.invK1 = K1 == null ? null : K1.clone();
        opencv_core.CvMat cvMat = this.invK2 = K2 == null ? null : K2.clone();
        if (K1 != null) {
            opencv_core.cvInvert(K1, this.invK1);
        }
        if (K2 != null) {
            opencv_core.cvInvert(K2, this.invK2);
        }
        this.R = R == null ? null : R.clone();
        this.t = t == null ? null : t.clone();
        this.n = n == null ? null : n.clone();
        this.referencePoints1 = referencePoints1 == null ? null : (double[])referencePoints1.clone();
        this.referencePoints2 = referencePoints2 == null ? null : (double[])referencePoints2.clone();
    }

    public ProjectiveTransformer(ProjectiveDevice d1, ProjectiveDevice d2, opencv_core.CvMat n, double[] referencePoints1, double[] referencePoints2) {
        this(d1.cameraMatrix, d2.cameraMatrix, d2.R, d2.T, n, referencePoints1, referencePoints2);
    }

    public ProjectiveTransformer() {
        this(null, null, null, null, null, new double[0], null);
    }

    public ProjectiveTransformer(double[] referencePoints) {
        this(null, null, null, null, null, referencePoints, null);
    }

    public opencv_core.CvScalar getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(opencv_core.CvScalar fillColor) {
        this.fillColor = fillColor;
    }

    public double[] getReferencePoints1() {
        return this.referencePoints1;
    }

    public double[] getReferencePoints2() {
        return this.referencePoints2;
    }

    public opencv_core.CvMat getK1() {
        return this.K1;
    }

    public opencv_core.CvMat getK2() {
        return this.K2;
    }

    public opencv_core.CvMat getInvK1() {
        return this.invK1;
    }

    public opencv_core.CvMat getInvK2() {
        return this.invK2;
    }

    public opencv_core.CvMat getR() {
        return this.R;
    }

    public opencv_core.CvMat getT() {
        return this.t;
    }

    public opencv_core.CvMat getN() {
        return this.n;
    }

    protected void prepareHomography(opencv_core.CvMat H, int pyramidLevel, Parameters p, boolean inverse) {
        if (this.K2 != null && this.invK1 != null && this.R != null && this.t != null && p.fakeIdentity) {
            opencv_core.cvSetIdentity(H);
            return;
        }
        if (inverse) {
            H.put(p.getH());
        } else {
            opencv_core.cvInvert(p.getH(), H);
        }
        if (pyramidLevel > 0) {
            int scale = 1 << pyramidLevel;
            H.put(2, H.get(2) / (double)scale);
            H.put(5, H.get(5) / (double)scale);
            H.put(6, H.get(6) * (double)scale);
            H.put(7, H.get(7) * (double)scale);
        }
    }

    public void transform(opencv_core.IplImage srcImage, opencv_core.IplImage dstImage, opencv_core.CvRect roi, int pyramidLevel, ImageTransformer.Parameters parameters, boolean inverse) {
        Parameters p = (Parameters)parameters;
        if (this.K2 != null && this.invK1 != null && this.R != null && this.t != null && p.fakeIdentity) {
            if (srcImage != dstImage) {
                opencv_core.cvCopy(srcImage, dstImage);
            }
            return;
        }
        opencv_core.CvMat H = H3x3.get();
        this.prepareHomography(H, pyramidLevel, p, true);
        if (roi != null && (roi.x() != 0 || roi.y() != 0)) {
            int x = roi.x();
            int y = roi.y();
            if (inverse) {
                H.put(2, H.get(0) * (double)x + H.get(1) * (double)y + H.get(2));
                H.put(5, H.get(3) * (double)x + H.get(4) * (double)y + H.get(5));
                H.put(8, H.get(6) * (double)x + H.get(7) * (double)y + H.get(8));
            } else {
                H.put(0, H.get(0) - (double)x * H.get(6));
                H.put(1, H.get(1) - (double)x * H.get(7));
                H.put(2, H.get(2) - (double)x * H.get(8));
                H.put(3, H.get(3) - (double)y * H.get(6));
                H.put(4, H.get(4) - (double)y * H.get(7));
                H.put(5, H.get(5) - (double)y * H.get(8));
            }
        }
        dstImage.origin(srcImage.origin());
        if (roi == null) {
            opencv_core.cvResetImageROI(dstImage);
        } else {
            opencv_core.cvSetImageROI(dstImage, roi);
        }
        opencv_imgproc.cvWarpPerspective(srcImage, dstImage, H, 9 | (inverse ? 16 : 0), this.getFillColor());
    }

    public void transform(opencv_core.CvMat srcPts, opencv_core.CvMat dstPts, ImageTransformer.Parameters parameters, boolean inverse) {
        opencv_core.CvMat H;
        Parameters p = (Parameters)parameters;
        if (inverse) {
            H = H3x3.get();
            opencv_core.cvInvert(p.getH(), H);
        } else {
            H = p.getH();
        }
        opencv_core.cvPerspectiveTransform(srcPts, dstPts, H);
    }

    public void transform(ImageTransformer.Data[] data, opencv_core.CvRect roi, ImageTransformer.Parameters[] parameters, boolean[] inverses) {
        assert (data.length == parameters.length);
        boolean allOK = true;
        for (int i = 0; i < data.length; ++i) {
            ImageTransformer.Data d = data[i];
            if (d.srcImg == null) continue;
            if ((d.transImg != null || d.dstImg != null) && d.subImg == null && d.srcDotImg == null && d.dstDstDot == null) {
                this.transform(d.srcImg, d.transImg == null ? d.dstImg : d.transImg, roi, d.pyramidLevel, parameters[i], inverses == null ? false : inverses[i]);
                continue;
            }
            allOK = false;
        }
        if (!allOK) {
            int i;
            class Cache {
                final int length;
                final cvkernels.KernelData kernelData;
                final opencv_core.CvMat[] H;
                final DoublePointer[] dstDstDot;
                final DoubleBuffer[] dstDstDotBuf;

                Cache(int length) {
                    this.length = length;
                    this.kernelData = new cvkernels.KernelData(length);
                    this.H = new opencv_core.CvMat[length];
                    this.dstDstDot = new DoublePointer[length];
                    this.dstDstDotBuf = new DoubleBuffer[length];
                }
            }
            Cache c;
            Cache cache = c = data[0].cache instanceof Cache ? (Cache)data[0].cache : null;
            if (c == null || c.length != data.length) {
                c = new Cache(data.length);
                data[0].cache = c;
            }
            for (i = 0; i < data.length; ++i) {
                c.kernelData.position(i);
                c.kernelData.srcImg(data[i].srcImg);
                c.kernelData.srcImg2(null);
                c.kernelData.subImg(data[i].subImg);
                c.kernelData.srcDotImg(data[i].srcDotImg);
                c.kernelData.mask(data[i].mask);
                c.kernelData.zeroThreshold(data[i].zeroThreshold);
                c.kernelData.outlierThreshold(data[i].outlierThreshold);
                if (c.H[i] == null) {
                    c.H[i] = opencv_core.CvMat.create(3, 3);
                }
                if (data[i].dstDstDot != null && c.dstDstDot[i] == null) {
                    c.dstDstDot[i] = new DoublePointer(data[i].dstDstDot.length);
                    c.dstDstDotBuf[i] = c.dstDstDot[i].asBuffer();
                }
                this.prepareHomography(c.H[i], data[i].pyramidLevel, (Parameters)parameters[i], inverses == null ? false : inverses[i]);
                c.kernelData.H1(c.H[i]);
                c.kernelData.H2(null);
                c.kernelData.X(null);
                c.kernelData.transImg(data[i].transImg);
                c.kernelData.dstImg(data[i].dstImg);
                c.kernelData.dstDstDot(c.dstDstDot[i]);
            }
            cvkernels.multiWarpColorTransform(c.kernelData.position(0), data.length, roi, this.getFillColor());
            for (i = 0; i < data.length; ++i) {
                c.kernelData.position(i);
                data[i].dstCount = c.kernelData.dstCount();
                data[i].dstCountZero = c.kernelData.dstCountZero();
                data[i].dstCountOutlier = c.kernelData.dstCountOutlier();
                data[i].srcDstDot = c.kernelData.srcDstDot();
                if (data[i].dstDstDot == null) continue;
                c.dstDstDotBuf[i].position(0);
                c.dstDstDotBuf[i].get(data[i].dstDstDot);
            }
        }
    }

    public Parameters createParameters() {
        return new Parameters();
    }

    public class Parameters
    implements ImageTransformer.Parameters {
        protected double[] projectiveParameters = null;
        private opencv_core.CvMat H = opencv_core.CvMat.create(3, 3);
        private opencv_core.CvMat n2 = null;
        private opencv_core.CvMat R2 = null;
        private opencv_core.CvMat t2 = null;
        private double constraintError = 0.0;
        private boolean updateNeeded = true;
        protected boolean fakeIdentity = false;

        protected Parameters() {
            this.reset(false);
        }

        public boolean isUpdateNeeded() {
            return this.updateNeeded;
        }

        public void setUpdateNeeded(boolean updateNeeded) {
            this.updateNeeded = updateNeeded;
        }

        public int size() {
            return this.projectiveParameters.length;
        }

        public double[] get() {
            double[] p = new double[this.size()];
            for (int i = 0; i < p.length; ++i) {
                p[i] = this.get(i);
            }
            return p;
        }

        public double get(int i) {
            return this.projectiveParameters[i];
        }

        public void set(double ... p) {
            for (int i = 0; i < p.length; ++i) {
                this.set(i, p[i]);
            }
        }

        public void set(int i, double p) {
            if (this.projectiveParameters[i] != p) {
                this.projectiveParameters[i] = p;
                this.setUpdateNeeded(true);
            }
        }

        public void set(ImageTransformer.Parameters p) {
            this.set(p.get());
            this.fakeIdentity = ((Parameters)p).fakeIdentity;
        }

        public void reset(boolean asIdentity) {
            this.setUpdateNeeded(true);
            if (ProjectiveTransformer.this.referencePoints1 != null && (ProjectiveTransformer.this.referencePoints1.length == 0 || ProjectiveTransformer.this.referencePoints1.length == 8)) {
                this.projectiveParameters = ProjectiveTransformer.this.referencePoints1.length == 0 ? new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0} : (double[])ProjectiveTransformer.this.referencePoints1.clone();
            } else if (ProjectiveTransformer.this.K2 != null && ProjectiveTransformer.this.invK1 != null) {
                this.projectiveParameters = ProjectiveTransformer.this.R != null && ProjectiveTransformer.this.t != null ? new double[]{ProjectiveTransformer.this.referencePoints1[0], ProjectiveTransformer.this.referencePoints1[2], ProjectiveTransformer.this.referencePoints1[4]} : (ProjectiveTransformer.this.n != null ? new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0} : new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
            }
        }

        public double getConstraintError() {
            this.update();
            return this.constraintError;
        }

        public void compose(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            Parameters pp1 = (Parameters)p1;
            Parameters pp2 = (Parameters)p2;
            if (ProjectiveTransformer.this.K2 != null && ProjectiveTransformer.this.invK1 != null && ProjectiveTransformer.this.R != null && ProjectiveTransformer.this.t != null && pp1.fakeIdentity) {
                return;
            }
            this.compose(pp1.getH(), inverse1, pp2.getH(), inverse2);
        }

        public void compose(opencv_core.CvMat H1, boolean inverse1, opencv_core.CvMat H2, boolean inverse2) {
            if (this.projectiveParameters.length == 8 && ProjectiveTransformer.this.referencePoints1 != null) {
                if (inverse1 && inverse2) {
                    opencv_core.cvMatMul(H2, H1, this.H);
                    opencv_core.cvInvert(this.H, this.H);
                } else if (inverse1) {
                    opencv_core.cvInvert(H1, this.H);
                    opencv_core.cvMatMul(this.H, H2, this.H);
                } else if (inverse2) {
                    opencv_core.cvInvert(H2, this.H);
                    opencv_core.cvMatMul(H1, this.H, this.H);
                } else {
                    opencv_core.cvMatMul(H1, H2, this.H);
                }
                if (ProjectiveTransformer.this.referencePoints1.length == 0) {
                    for (int i = 0; i < 8; ++i) {
                        this.projectiveParameters[i] = this.H.get(i) / this.H.get(8);
                    }
                } else {
                    opencv_core.CvMat pts = (opencv_core.CvMat)pts4x1.get();
                    pts.put(ProjectiveTransformer.this.referencePoints1);
                    opencv_core.cvPerspectiveTransform(pts, pts, this.H);
                    pts.get(this.projectiveParameters);
                }
            } else {
                throw new UnsupportedOperationException("Compose operation not supported.");
            }
            this.setUpdateNeeded(true);
        }

        public opencv_core.CvMat getH() {
            this.update();
            return this.H;
        }

        public opencv_core.CvMat getN() {
            this.update();
            return this.n2;
        }

        public opencv_core.CvMat getR() {
            this.update();
            return this.R2;
        }

        public opencv_core.CvMat getT() {
            this.update();
            return this.t2;
        }

        protected void update() {
            if (!this.isUpdateNeeded()) {
                return;
            }
            if (ProjectiveTransformer.this.referencePoints1 != null && (ProjectiveTransformer.this.referencePoints1.length == 0 || ProjectiveTransformer.this.referencePoints1.length == 8)) {
                if (ProjectiveTransformer.this.referencePoints1.length == 0) {
                    this.H.put(0, this.projectiveParameters, 0, 8);
                    this.H.put(8, 1.0);
                } else {
                    JavaCV.getPerspectiveTransform(ProjectiveTransformer.this.referencePoints1, this.projectiveParameters, this.H);
                }
            } else if (ProjectiveTransformer.this.K2 != null && ProjectiveTransformer.this.invK1 != null) {
                if (ProjectiveTransformer.this.R != null && ProjectiveTransformer.this.t != null) {
                    double[] src = ProjectiveTransformer.this.referencePoints2;
                    double[] dst = new double[]{this.projectiveParameters[0], ProjectiveTransformer.this.referencePoints1[1], this.projectiveParameters[1], ProjectiveTransformer.this.referencePoints1[3], this.projectiveParameters[2], ProjectiveTransformer.this.referencePoints1[5]};
                    if (this.R2 == null) {
                        this.R2 = opencv_core.CvMat.create(3, 3);
                    }
                    if (this.t2 == null) {
                        this.t2 = opencv_core.CvMat.create(3, 1);
                    }
                    opencv_core.cvTranspose(ProjectiveTransformer.this.R, this.R2);
                    opencv_core.cvGEMM(this.R2, ProjectiveTransformer.this.t, -1.0, null, 0.0, this.t2, 0);
                    JavaCV.getPerspectiveTransform(src, dst, ProjectiveTransformer.this.invK2, ProjectiveTransformer.this.K1, this.R2, this.t2, this.H);
                } else {
                    if (ProjectiveTransformer.this.n != null) {
                        this.n2 = ProjectiveTransformer.this.n;
                    } else {
                        if (this.n2 == null) {
                            this.n2 = opencv_core.CvMat.create(3, 1);
                        }
                        this.n2.put(0, this.projectiveParameters, 8, 3);
                    }
                    if (this.R2 == null) {
                        this.R2 = opencv_core.CvMat.create(3, 3);
                    }
                    if (this.t2 == null) {
                        this.t2 = opencv_core.CvMat.create(3, 1);
                    }
                    this.t2.put(0, this.projectiveParameters, 0, 3);
                    opencv_calib3d.cvRodrigues2(this.t2, this.R2, null);
                    this.t2.put(0, this.projectiveParameters, 3, 3);
                    opencv_core.cvGEMM(this.t2, this.n2, -1.0, this.R2, 1.0, this.H, 2);
                }
            }
            this.setUpdateNeeded(false);
        }

        public boolean preoptimize() {
            return false;
        }

        public double[] getSubspace() {
            return null;
        }

        public void setSubspace(double ... p) {
        }

        public Parameters clone() {
            Parameters p = new Parameters();
            p.set(this);
            return p;
        }

        public String toString() {
            String s = "[";
            double[] p = this.get();
            for (int i = 0; i < p.length; ++i) {
                s = s + (float)p[i];
                if (i >= p.length - 1) continue;
                s = s + ", ";
            }
            s = s + "]";
            return s;
        }
    }
}

