/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacv.ImageTransformer;
import com.googlecode.javacv.ProjectiveTransformer;
import com.googlecode.javacv.cpp.cvkernels;
import com.googlecode.javacv.cpp.opencv_core;
import java.nio.DoubleBuffer;
import java.util.Arrays;

public class ProjectiveGainBiasTransformer
extends ProjectiveTransformer {
    private static ThreadLocal<opencv_core.CvMat> X24x4 = opencv_core.CvMat.createThreadLocal(4, 4);
    private static ThreadLocal<opencv_core.CvMat> temp3x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    private opencv_core.CvMat X = null;
    private int numGains = 0;
    private int numBiases = 0;

    public ProjectiveGainBiasTransformer(opencv_core.CvMat K1, opencv_core.CvMat K2, opencv_core.CvMat R, opencv_core.CvMat t, opencv_core.CvMat n, double[] referencePoints1, double[] referencePoints2, opencv_core.CvMat X, int numGains, int numBiases) {
        super(K1, K2, R, t, n, referencePoints1, referencePoints2);
        this.X = X == null ? null : X.clone();
        this.numGains = numGains;
        this.numBiases = numBiases;
    }

    public opencv_core.CvMat getX() {
        return this.X;
    }

    public int getNumGains() {
        return this.numGains;
    }

    public int getNumBiases() {
        return this.numBiases;
    }

    public void transformGainBias(opencv_core.IplImage srcImage, opencv_core.IplImage dstImage, opencv_core.CvRect roi, int pyramidLevel, ImageTransformer.Parameters parameters, boolean inverse) {
        Parameters p = (Parameters)parameters;
        if (Arrays.equals(p.getGainBiasParameters(), p.getIdentityGainBiasParameters()) && (this.X == null || p.fakeIdentity) || this.X == null && this.numGains == 0 && this.numBiases == 0) {
            if (srcImage != dstImage) {
                opencv_core.cvCopy(srcImage, dstImage);
            }
            return;
        }
        opencv_core.CvMat X2 = X24x4.get();
        this.prepareTransform(X2, pyramidLevel, p, inverse);
        X2.rows(3);
        if (roi == null) {
            opencv_core.cvResetImageROI(dstImage);
        } else {
            opencv_core.cvSetImageROI(dstImage, roi);
        }
        X2.put(0, 3, X2.get(0, 3) * dstImage.highValue());
        X2.put(1, 3, X2.get(1, 3) * dstImage.highValue());
        X2.put(2, 3, X2.get(2, 3) * dstImage.highValue());
        opencv_core.cvTransform(srcImage, dstImage, X2, null);
        X2.rows(4);
    }

    protected void prepareTransform(opencv_core.CvMat X2, int pyramidLevel, Parameters p, boolean inverse) {
        opencv_core.CvMat A = p.getA();
        opencv_core.CvMat b = p.getB();
        opencv_core.cvSetIdentity(X2);
        X2.rows(3);
        X2.cols(3);
        if (p.fakeIdentity && !inverse) {
            X2.put(A);
        } else if (A != null && this.X != null) {
            opencv_core.cvMatMul(this.X, A, X2);
        } else if (this.X == null) {
            X2.put(A);
        } else if (A == null) {
            X2.put(this.X);
        }
        X2.rows(4);
        X2.cols(4);
        if (b != null) {
            X2.put(0, 3, b.get(0));
            X2.put(1, 3, b.get(1));
            X2.put(2, 3, b.get(2));
        }
        if (inverse) {
            opencv_core.cvInvert(X2, X2, 1);
        }
    }

    public void transform(ImageTransformer.Data[] data, opencv_core.CvRect roi, ImageTransformer.Parameters[] parameters, boolean[] inverses) {
        assert (data.length == parameters.length);
        boolean allOK = true;
        for (int i = 0; i < data.length; ++i) {
            ImageTransformer.Data d = data[i];
            if (d.srcImg == null) continue;
            if ((d.transImg != null || d.dstImg != null) && d.subImg == null && d.srcDotImg == null && d.dstDstDot == null) {
                opencv_core.IplImage dstImage = d.transImg == null ? d.dstImg : d.transImg;
                boolean inverse = inverses == null ? false : inverses[i];
                this.transform(d.srcImg, dstImage, roi, d.pyramidLevel, parameters[i], inverse);
                this.transformGainBias(dstImage, dstImage, roi, d.pyramidLevel, parameters[i], inverse);
                continue;
            }
            allOK = false;
        }
        if (!allOK) {
            int i;
            class Cache {
                final int length;
                final cvkernels.KernelData kernelData;
                final opencv_core.CvMat[] H;
                final opencv_core.CvMat[] X;
                final DoublePointer[] dstDstDot;
                final DoubleBuffer[] dstDstDotBuf;

                Cache(int length) {
                    this.length = length;
                    this.kernelData = new cvkernels.KernelData(length);
                    this.H = new opencv_core.CvMat[length];
                    this.X = new opencv_core.CvMat[length];
                    this.dstDstDot = new DoublePointer[length];
                    this.dstDstDotBuf = new DoubleBuffer[length];
                }
            }
            Cache c;
            Cache cache = c = data[0].cache instanceof Cache ? (Cache)data[0].cache : null;
            if (c == null || c.length != data.length) {
                c = new Cache(data.length);
                data[0].cache = c;
            }
            for (i = 0; i < data.length; ++i) {
                c.kernelData.position(i);
                c.kernelData.srcImg(data[i].srcImg);
                c.kernelData.srcImg2(null);
                c.kernelData.subImg(data[i].subImg);
                c.kernelData.srcDotImg(data[i].srcDotImg);
                c.kernelData.mask(data[i].mask);
                c.kernelData.zeroThreshold(data[i].zeroThreshold);
                c.kernelData.outlierThreshold(data[i].outlierThreshold);
                if (c.H[i] == null) {
                    c.H[i] = opencv_core.CvMat.create(3, 3);
                }
                if (c.X[i] == null) {
                    c.X[i] = opencv_core.CvMat.create(4, 4);
                }
                if (data[i].dstDstDot != null && c.dstDstDot[i] == null) {
                    c.dstDstDot[i] = new DoublePointer(data[i].dstDstDot.length);
                    c.dstDstDotBuf[i] = c.dstDstDot[i].asBuffer();
                }
                boolean inverse = inverses == null ? false : inverses[i];
                this.prepareHomography(c.H[i], data[i].pyramidLevel, (Parameters)parameters[i], inverse);
                this.prepareTransform(c.X[i], data[i].pyramidLevel, (Parameters)parameters[i], inverse);
                c.kernelData.H1(c.H[i]);
                c.kernelData.H2(null);
                c.kernelData.X(c.X[i]);
                c.kernelData.transImg(data[i].transImg);
                c.kernelData.dstImg(data[i].dstImg);
                c.kernelData.dstDstDot(c.dstDstDot[i]);
            }
            cvkernels.multiWarpColorTransform(c.kernelData.position(0), data.length, roi, this.getFillColor());
            for (i = 0; i < data.length; ++i) {
                c.kernelData.position(i);
                data[i].dstCount = c.kernelData.dstCount();
                data[i].dstCountZero = c.kernelData.dstCountZero();
                data[i].dstCountOutlier = c.kernelData.dstCountOutlier();
                data[i].srcDstDot = c.kernelData.srcDstDot();
                if (data[i].dstDstDot == null) continue;
                c.dstDstDotBuf[i].position(0);
                c.dstDstDotBuf[i].get(data[i].dstDstDot);
            }
        }
    }

    public Parameters createParameters() {
        return new Parameters();
    }

    public class Parameters
    extends ProjectiveTransformer.Parameters {
        protected double[] gainBiasParameters;
        protected double[] identityGainBiasParameters;
        private opencv_core.CvMat A;
        private opencv_core.CvMat b;

        protected Parameters() {
            super(ProjectiveGainBiasTransformer.this);
            this.gainBiasParameters = null;
            this.identityGainBiasParameters = null;
            this.A = null;
            this.b = null;
            this.identityGainBiasParameters = new double[ProjectiveGainBiasTransformer.this.numGains + ProjectiveGainBiasTransformer.this.numBiases];
            if (ProjectiveGainBiasTransformer.this.numGains > 0) {
                this.A = opencv_core.CvMat.create(3, 3);
                opencv_core.cvSetIdentity(this.A);
            }
            if (ProjectiveGainBiasTransformer.this.numBiases > 0) {
                this.b = opencv_core.CvMat.create(3, 1);
                opencv_core.cvSetZero(this.b);
            }
            switch (ProjectiveGainBiasTransformer.this.numGains) {
                case 0: {
                    assert (this.A == null);
                    break;
                }
                case 1: {
                    this.identityGainBiasParameters[0] = (this.A.get(0) + this.A.get(4) + this.A.get(8)) / 3.0;
                    break;
                }
                case 3: {
                    this.identityGainBiasParameters[0] = this.A.get(0);
                    this.identityGainBiasParameters[1] = this.A.get(4);
                    this.identityGainBiasParameters[2] = this.A.get(8);
                    break;
                }
                case 9: {
                    this.A.get(0, this.identityGainBiasParameters, 0, 9);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (ProjectiveGainBiasTransformer.this.numBiases) {
                case 0: {
                    assert (this.b == null);
                    break;
                }
                case 1: {
                    this.identityGainBiasParameters[((ProjectiveGainBiasTransformer)ProjectiveGainBiasTransformer.this).numGains] = (this.b.get(0) + this.b.get(1) + this.b.get(2)) / 3.0;
                    break;
                }
                case 3: {
                    this.b.get(0, this.identityGainBiasParameters, ProjectiveGainBiasTransformer.this.numGains, 3);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.reset(false);
        }

        public double[] getGainBiasParameters() {
            return this.gainBiasParameters;
        }

        public double[] getIdentityGainBiasParameters() {
            return this.identityGainBiasParameters;
        }

        public int size() {
            return super.size() + ProjectiveGainBiasTransformer.this.numGains + ProjectiveGainBiasTransformer.this.numBiases;
        }

        public double get(int i) {
            int s = super.size();
            if (i < s) {
                return super.get(i);
            }
            return this.gainBiasParameters[i - s];
        }

        public void set(int i, double p) {
            int s = super.size();
            if (i < s) {
                super.set(i, p);
            } else if (this.gainBiasParameters[i - s] != p) {
                this.gainBiasParameters[i - s] = p;
                this.setUpdateNeeded(true);
            }
        }

        public void reset(boolean asIdentity) {
            super.reset(asIdentity);
            this.resetGainBias(asIdentity);
        }

        public void resetGainBias(boolean asIdentity) {
            if (!(this.identityGainBiasParameters == null || Arrays.equals(this.gainBiasParameters, this.identityGainBiasParameters) && this.fakeIdentity == asIdentity)) {
                this.fakeIdentity = asIdentity;
                this.gainBiasParameters = (double[])this.identityGainBiasParameters.clone();
                this.setUpdateNeeded(true);
            }
        }

        public void compose(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            super.compose(p1, inverse1, p2, inverse2);
            this.composeGainBias(p1, inverse1, p2, inverse2);
        }

        public void composeGainBias(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            assert (!inverse1 && !inverse2);
            Parameters pp1 = (Parameters)p1;
            Parameters pp2 = (Parameters)p2;
            opencv_core.CvMat A1 = pp1.getA();
            opencv_core.CvMat b1 = pp1.getB();
            opencv_core.CvMat A2 = pp2.getA();
            opencv_core.CvMat b2 = pp2.getB();
            if (this.b != null) {
                if (pp1.fakeIdentity && ProjectiveGainBiasTransformer.this.X != null) {
                    opencv_core.CvMat temp = (opencv_core.CvMat)temp3x1.get();
                    opencv_core.cvMatMul(ProjectiveGainBiasTransformer.this.X, b1, temp);
                    b1 = temp;
                }
                if (A2 == null && b2 == null) {
                    opencv_core.cvCopy(b1, this.b);
                } else if (b1 == null) {
                    opencv_core.cvCopy(b2, this.b);
                } else if (b2 == null) {
                    opencv_core.cvMatMul(A2, b1, this.b);
                } else {
                    opencv_core.cvGEMM(A2, b1, 1.0, b2, 1.0, this.b, 0);
                }
            }
            if (this.A != null) {
                if (A1 == null) {
                    opencv_core.cvCopy(A2, this.A);
                } else if (A2 == null) {
                    opencv_core.cvCopy(A1, this.A);
                } else {
                    opencv_core.cvMatMul(A2, A1, this.A);
                }
            }
            switch (ProjectiveGainBiasTransformer.this.numGains) {
                case 0: {
                    assert (this.A == null);
                    break;
                }
                case 1: {
                    this.gainBiasParameters[0] = (this.A.get(0) + this.A.get(4) + this.A.get(8)) / 3.0;
                    break;
                }
                case 3: {
                    this.gainBiasParameters[0] = this.A.get(0);
                    this.gainBiasParameters[1] = this.A.get(4);
                    this.gainBiasParameters[2] = this.A.get(8);
                    break;
                }
                case 9: {
                    this.A.get(0, this.gainBiasParameters, 0, 9);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (ProjectiveGainBiasTransformer.this.numBiases) {
                case 0: {
                    assert (this.b == null);
                    break;
                }
                case 1: {
                    this.gainBiasParameters[((ProjectiveGainBiasTransformer)ProjectiveGainBiasTransformer.this).numGains] = (this.b.get(0) + this.b.get(1) + this.b.get(2)) / 3.0;
                    break;
                }
                case 3: {
                    this.b.get(0, this.gainBiasParameters, ProjectiveGainBiasTransformer.this.numGains, 3);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public opencv_core.CvMat getA() {
            this.update();
            return this.A;
        }

        public opencv_core.CvMat getB() {
            this.update();
            return this.b;
        }

        protected void update() {
            if (!this.isUpdateNeeded()) {
                return;
            }
            switch (ProjectiveGainBiasTransformer.this.numGains) {
                case 0: {
                    assert (this.A == null);
                    break;
                }
                case 1: {
                    this.A.put(0, this.gainBiasParameters[0]);
                    this.A.put(4, this.gainBiasParameters[0]);
                    this.A.put(8, this.gainBiasParameters[0]);
                    break;
                }
                case 3: {
                    this.A.put(0, this.gainBiasParameters[0]);
                    this.A.put(4, this.gainBiasParameters[1]);
                    this.A.put(8, this.gainBiasParameters[2]);
                    break;
                }
                case 9: {
                    this.A.put(0, this.gainBiasParameters, 0, 9);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (ProjectiveGainBiasTransformer.this.numBiases) {
                case 0: {
                    assert (this.b == null);
                    break;
                }
                case 1: {
                    this.b.put(0, this.gainBiasParameters[ProjectiveGainBiasTransformer.this.numGains]);
                    this.b.put(1, this.gainBiasParameters[ProjectiveGainBiasTransformer.this.numGains]);
                    this.b.put(2, this.gainBiasParameters[ProjectiveGainBiasTransformer.this.numGains]);
                    break;
                }
                case 3: {
                    this.b.put(0, this.gainBiasParameters, ProjectiveGainBiasTransformer.this.numGains, 3);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            super.update();
            this.setUpdateNeeded(false);
        }

        public Parameters clone() {
            Parameters p = new Parameters();
            p.set(this);
            return p;
        }
    }
}

