/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacv.CameraDevice;
import com.googlecode.javacv.ImageTransformer;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.ProjectiveGainBiasTransformer;
import com.googlecode.javacv.ProjectorDevice;
import com.googlecode.javacv.cpp.cvkernels;
import com.googlecode.javacv.cpp.opencv_calib3d;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.DoubleBuffer;

public class ProCamTransformer
implements ImageTransformer {
    private CameraDevice camera = null;
    private ProjectorDevice projector = null;
    private ProjectiveGainBiasTransformer surfaceTransformer = null;
    private ProjectiveGainBiasTransformer projectorTransformer = null;
    private opencv_core.IplImage[] projectorImage = null;
    private opencv_core.IplImage[] surfaceImage = null;
    private opencv_core.CvScalar fillColor = opencv_core.cvScalar(0.0, 0.0, 0.0, 1.0);
    private opencv_core.CvRect roi = new opencv_core.CvRect();
    private opencv_core.CvMat frontoParallelH = null;
    private opencv_core.CvMat invFrontoParallelH = null;

    public ProCamTransformer(double[] referencePoints, CameraDevice camera, ProjectorDevice projector) {
        this(referencePoints, camera, projector, null);
    }

    public ProCamTransformer(double[] referencePoints, CameraDevice camera, ProjectorDevice projector, opencv_core.CvMat n) {
        this.camera = camera;
        this.projector = projector;
        this.surfaceTransformer = new ProjectiveGainBiasTransformer(camera.cameraMatrix, camera.cameraMatrix, null, null, n, referencePoints, null, null, 3, 0);
        this.projectorTransformer = new ProjectiveGainBiasTransformer(camera.cameraMatrix, projector.cameraMatrix, projector.R, projector.T, null, new double[]{0.0, 0.0, camera.imageWidth / 2, camera.imageHeight, camera.imageWidth, 0.0}, new double[]{0.0, 0.0, projector.imageWidth / 2, projector.imageHeight, projector.imageWidth, 0.0}, projector.colorMixingMatrix, 1, 3);
        if (n != null) {
            this.frontoParallelH = camera.getFrontoParallelH(referencePoints, n, opencv_core.CvMat.create(3, 3));
            this.invFrontoParallelH = this.frontoParallelH.clone();
            opencv_core.cvInvert(this.frontoParallelH, this.invFrontoParallelH);
        }
    }

    public opencv_core.CvScalar getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(opencv_core.CvScalar fillColor) {
        this.fillColor = fillColor;
    }

    public ProjectiveGainBiasTransformer getSurfaceTransformer() {
        return this.surfaceTransformer;
    }

    public ProjectiveGainBiasTransformer getProjectorTransformer() {
        return this.projectorTransformer;
    }

    public opencv_core.IplImage getProjectorImage(int pyramidLevel) {
        return this.projectorImage[pyramidLevel];
    }

    public void setProjectorImage(opencv_core.IplImage projectorImage0, int pyramidLevels) {
        this.setProjectorImage(projectorImage0, pyramidLevels, true);
    }

    public void setProjectorImage(opencv_core.IplImage projectorImage0, int pyramidLevels, boolean convertToFloat) {
        if (this.projectorImage == null || this.projectorImage.length != pyramidLevels) {
            this.projectorImage = new opencv_core.IplImage[pyramidLevels];
        }
        if (projectorImage0.depth() == 32 || !convertToFloat) {
            this.projectorImage[0] = projectorImage0;
        } else {
            opencv_core.IplROI ir;
            if (this.projectorImage[0] == null) {
                this.projectorImage[0] = opencv_core.IplImage.create(projectorImage0.width(), projectorImage0.height(), 32, projectorImage0.nChannels(), projectorImage0.origin());
            }
            if ((ir = projectorImage0.roi()) != null) {
                int align = 1 << this.projectorImage.length;
                this.roi.x(Math.max(0, (int)Math.floor((double)ir.xOffset() / (double)align) * align));
                this.roi.y(Math.max(0, (int)Math.floor((double)ir.yOffset() / (double)align) * align));
                this.roi.width(Math.min(projectorImage0.width(), (int)Math.ceil((double)ir.width() / (double)align) * align));
                this.roi.height(Math.min(projectorImage0.height(), (int)Math.ceil((double)ir.height() / (double)align) * align));
                opencv_core.cvSetImageROI(projectorImage0, this.roi);
                opencv_core.cvSetImageROI(this.projectorImage[0], this.roi);
            } else {
                opencv_core.cvResetImageROI(projectorImage0);
                opencv_core.cvResetImageROI(this.projectorImage[0]);
            }
            opencv_core.cvConvertScale(projectorImage0, this.projectorImage[0], 0.00392156862745098, 0.0);
        }
        for (int i = 1; i < pyramidLevels; ++i) {
            opencv_core.IplROI ir;
            int w = this.projectorImage[i - 1].width() / 2;
            int h = this.projectorImage[i - 1].height() / 2;
            int d = this.projectorImage[i - 1].depth();
            int c = this.projectorImage[i - 1].nChannels();
            int o = this.projectorImage[i - 1].origin();
            if (this.projectorImage[i] == null) {
                this.projectorImage[i] = opencv_core.IplImage.create(w, h, d, c, o);
            }
            if ((ir = this.projectorImage[i - 1].roi()) != null) {
                this.roi.x(ir.xOffset() / 2);
                this.roi.width(ir.width() / 2);
                this.roi.y(ir.yOffset() / 2);
                this.roi.height(ir.height() / 2);
                opencv_core.cvSetImageROI(this.projectorImage[i], this.roi);
            } else {
                opencv_core.cvResetImageROI(this.projectorImage[i]);
            }
            opencv_imgproc.cvPyrDown(this.projectorImage[i - 1], this.projectorImage[i], 7);
            opencv_core.cvResetImageROI(this.projectorImage[i - 1]);
        }
    }

    public opencv_core.IplImage getSurfaceImage(int pyramidLevel) {
        return this.surfaceImage[pyramidLevel];
    }

    public void setSurfaceImage(opencv_core.IplImage surfaceImage0, int pyramidLevels) {
        if (this.surfaceImage == null || this.surfaceImage.length != pyramidLevels) {
            this.surfaceImage = new opencv_core.IplImage[pyramidLevels];
        }
        this.surfaceImage[0] = surfaceImage0;
        opencv_core.cvResetImageROI(surfaceImage0);
        for (int i = 1; i < pyramidLevels; ++i) {
            int w = this.surfaceImage[i - 1].width() / 2;
            int h = this.surfaceImage[i - 1].height() / 2;
            int d = this.surfaceImage[i - 1].depth();
            int c = this.surfaceImage[i - 1].nChannels();
            int o = this.surfaceImage[i - 1].origin();
            if (this.surfaceImage[i] == null) {
                this.surfaceImage[i] = opencv_core.IplImage.create(w, h, d, c, o);
            } else {
                opencv_core.cvResetImageROI(this.surfaceImage[i]);
            }
            opencv_imgproc.cvPyrDown(this.surfaceImage[i - 1], this.surfaceImage[i], 7);
        }
    }

    protected void prepareHomographyTransform(opencv_core.CvMat H1, opencv_core.CvMat H2, opencv_core.CvMat X, int pyramidLevel, Parameters p) {
        ProjectiveGainBiasTransformer.Parameters cameraParameters = p.getSurfaceParameters();
        ProjectiveGainBiasTransformer.Parameters projectorParameters = p.getProjectorParameters();
        opencv_core.cvInvert(cameraParameters.getH(), H1);
        opencv_core.cvInvert(projectorParameters.getH(), H2);
        if (pyramidLevel > 0) {
            int scale = 1 << pyramidLevel;
            H1.put(2, H1.get(2) / (double)scale);
            H1.put(5, H1.get(5) / (double)scale);
            H1.put(6, H1.get(6) * (double)scale);
            H1.put(7, H1.get(7) * (double)scale);
            H2.put(2, H2.get(2) / (double)scale);
            H2.put(5, H2.get(5) / (double)scale);
            H2.put(6, H2.get(6) * (double)scale);
            H2.put(7, H2.get(7) * (double)scale);
        }
        double[] x = this.projector.colorMixingMatrix.get();
        double[] a = projectorParameters.getGainBiasParameters();
        double a2 = a[0];
        X.put(a2 * x[0], a2 * x[1], a2 * x[2], a[1], a2 * x[3], a2 * x[4], a2 * x[5], a[2], a2 * x[6], a2 * x[7], a2 * x[8], a[3], 0.0, 0.0, 0.0, 1.0);
    }

    public void transform(opencv_core.IplImage srcImage, opencv_core.IplImage dstImage, opencv_core.CvRect roi, int pyramidLevel, ImageTransformer.Parameters parameters, boolean inverse) {
        if (inverse) {
            throw new UnsupportedOperationException("Inverse transform not supported.");
        }
        Parameters p = (Parameters)parameters;
        ProjectiveGainBiasTransformer.Parameters cameraParameters = p.getSurfaceParameters();
        ProjectiveGainBiasTransformer.Parameters projectorParameters = p.getProjectorParameters();
        if (p.tempImage == null || p.tempImage.length <= pyramidLevel) {
            Parameters.access$002(p, new opencv_core.IplImage[pyramidLevel + 1]);
        }
        ((Parameters)p).tempImage[pyramidLevel] = opencv_core.IplImage.createIfNotCompatible(p.tempImage[pyramidLevel], dstImage);
        if (roi == null) {
            opencv_core.cvResetImageROI(p.tempImage[pyramidLevel]);
        } else {
            opencv_core.cvSetImageROI(p.tempImage[pyramidLevel], roi);
        }
        this.surfaceTransformer.transform(srcImage, p.tempImage[pyramidLevel], roi, pyramidLevel, cameraParameters, false);
        this.projectorTransformer.transform(this.projectorImage[pyramidLevel], dstImage, roi, pyramidLevel, projectorParameters, false);
        opencv_core.cvMul(dstImage, p.tempImage[pyramidLevel], dstImage, 1.0 / dstImage.highValue());
    }

    public void transform(opencv_core.CvMat srcPts, opencv_core.CvMat dstPts, ImageTransformer.Parameters parameters, boolean inverse) {
        this.surfaceTransformer.transform(srcPts, dstPts, ((Parameters)parameters).surfaceParameters, inverse);
    }

    public void transform(ImageTransformer.Data[] data, opencv_core.CvRect roi, ImageTransformer.Parameters[] parameters, boolean[] inverses) {
        assert (data.length == parameters.length);
        boolean allOK = true;
        for (int i = 0; i < data.length; ++i) {
            ImageTransformer.Data d = data[i];
            if (inverses != null && inverses[i]) {
                throw new UnsupportedOperationException("Inverse transform not supported.");
            }
            if (d.srcImg == null) continue;
            if ((d.transImg != null || d.dstImg != null) && d.subImg == null && d.srcDotImg == null && d.dstDstDot == null) {
                this.transform(d.srcImg, d.transImg == null ? d.dstImg : d.transImg, roi, d.pyramidLevel, parameters[i], inverses == null ? false : inverses[i]);
                continue;
            }
            allOK = false;
        }
        if (!allOK) {
            int i;
            class Cache {
                final int length;
                final cvkernels.KernelData kernelData;
                final opencv_core.CvMat[] H1;
                final opencv_core.CvMat[] H2;
                final opencv_core.CvMat[] X;
                final DoublePointer[] dstDstDot;
                final DoubleBuffer[] dstDstDotBuf;

                Cache(int length) {
                    this.length = length;
                    this.kernelData = new cvkernels.KernelData(length);
                    this.H1 = new opencv_core.CvMat[length];
                    this.H2 = new opencv_core.CvMat[length];
                    this.X = new opencv_core.CvMat[length];
                    this.dstDstDot = new DoublePointer[length];
                    this.dstDstDotBuf = new DoubleBuffer[length];
                }
            }
            Cache c;
            Cache cache = c = data[0].cache instanceof Cache ? (Cache)data[0].cache : null;
            if (c == null || c.length != data.length) {
                c = new Cache(data.length);
                data[0].cache = c;
            }
            for (i = 0; i < data.length; ++i) {
                c.kernelData.position(i);
                c.kernelData.srcImg(data[i].srcImg);
                c.kernelData.srcImg2(this.projectorImage[data[i].pyramidLevel]);
                c.kernelData.subImg(data[i].subImg);
                c.kernelData.srcDotImg(data[i].srcDotImg);
                c.kernelData.mask(data[i].mask);
                c.kernelData.zeroThreshold(data[i].zeroThreshold);
                c.kernelData.outlierThreshold(data[i].outlierThreshold);
                if (c.H1[i] == null) {
                    c.H1[i] = opencv_core.CvMat.create(3, 3);
                }
                if (c.H2[i] == null) {
                    c.H2[i] = opencv_core.CvMat.create(3, 3);
                }
                if (c.X[i] == null) {
                    c.X[i] = opencv_core.CvMat.create(4, 4);
                }
                if (data[i].dstDstDot != null && c.dstDstDot[i] == null) {
                    c.dstDstDot[i] = new DoublePointer(data[i].dstDstDot.length);
                    c.dstDstDotBuf[i] = c.dstDstDot[i].asBuffer();
                }
                this.prepareHomographyTransform(c.H1[i], c.H2[i], c.X[i], data[i].pyramidLevel, (Parameters)parameters[i]);
                c.kernelData.H1(c.H1[i]);
                c.kernelData.H2(c.H2[i]);
                c.kernelData.X(c.X[i]);
                c.kernelData.transImg(data[i].transImg);
                c.kernelData.dstImg(data[i].dstImg);
                c.kernelData.dstDstDot(c.dstDstDot[i]);
            }
            cvkernels.multiWarpColorTransform(c.kernelData.position(0), data.length, roi, this.getFillColor());
            for (i = 0; i < data.length; ++i) {
                c.kernelData.position(i);
                data[i].dstCount = c.kernelData.dstCount();
                data[i].dstCountZero = c.kernelData.dstCountZero();
                data[i].dstCountOutlier = c.kernelData.dstCountOutlier();
                data[i].srcDstDot = c.kernelData.srcDstDot();
                if (data[i].dstDstDot == null) continue;
                c.dstDstDotBuf[i].position(0);
                c.dstDstDotBuf[i].get(data[i].dstDstDot);
            }
        }
    }

    public Parameters createParameters() {
        return new Parameters();
    }

    public class Parameters
    implements ImageTransformer.Parameters {
        private ProjectiveGainBiasTransformer.Parameters surfaceParameters = null;
        private ProjectiveGainBiasTransformer.Parameters projectorParameters = null;
        private opencv_core.IplImage[] tempImage = null;
        private opencv_core.CvMat H = opencv_core.CvMat.create(3, 3);
        private opencv_core.CvMat R = opencv_core.CvMat.create(3, 3);
        private opencv_core.CvMat n = opencv_core.CvMat.create(3, 1);
        private opencv_core.CvMat t = opencv_core.CvMat.create(3, 1);

        protected Parameters() {
            this.reset(false);
        }

        protected Parameters(ProjectiveGainBiasTransformer.Parameters surfaceParameters, ProjectiveGainBiasTransformer.Parameters projectorParameters) {
            this.reset(surfaceParameters, projectorParameters);
        }

        public ProjectiveGainBiasTransformer.Parameters getSurfaceParameters() {
            return this.surfaceParameters;
        }

        public ProjectiveGainBiasTransformer.Parameters getProjectorParameters() {
            return this.projectorParameters;
        }

        private int getSizeForSurface() {
            return this.surfaceParameters.size() - ProCamTransformer.this.surfaceTransformer.getNumGains() - ProCamTransformer.this.surfaceTransformer.getNumBiases();
        }

        private int getSizeForProjector() {
            return this.projectorParameters.size();
        }

        public int size() {
            return this.getSizeForSurface() + this.getSizeForProjector();
        }

        public double[] get() {
            double[] p = new double[this.size()];
            for (int i = 0; i < p.length; ++i) {
                p[i] = this.get(i);
            }
            return p;
        }

        public double get(int i) {
            if (i < this.getSizeForSurface()) {
                return this.surfaceParameters.get(i);
            }
            return this.projectorParameters.get(i - this.getSizeForSurface());
        }

        public void set(double ... p) {
            for (int i = 0; i < p.length; ++i) {
                this.set(i, p[i]);
            }
        }

        public void set(int i, double p) {
            if (i < this.getSizeForSurface()) {
                this.surfaceParameters.set(i, p);
            } else {
                this.projectorParameters.set(i - this.getSizeForSurface(), p);
            }
        }

        public void set(ImageTransformer.Parameters p) {
            Parameters pcp = (Parameters)p;
            this.surfaceParameters.set(pcp.getSurfaceParameters());
            this.projectorParameters.set(pcp.getProjectorParameters());
            this.surfaceParameters.resetGainBias(false);
        }

        public void reset(boolean asIdentity) {
            this.reset(null, null);
        }

        public void reset(ProjectiveGainBiasTransformer.Parameters surfaceParameters, ProjectiveGainBiasTransformer.Parameters projectorParameters) {
            if (surfaceParameters == null) {
                surfaceParameters = ProCamTransformer.this.surfaceTransformer.createParameters();
            }
            if (projectorParameters == null) {
                projectorParameters = ProCamTransformer.this.projectorTransformer.createParameters();
            }
            this.surfaceParameters = surfaceParameters;
            this.projectorParameters = projectorParameters;
            this.setSubspace(this.getSubspace());
        }

        public double getConstraintError() {
            double error = this.surfaceParameters.getConstraintError();
            this.projectorParameters.update();
            return error;
        }

        public void compose(ImageTransformer.Parameters p1, boolean inverse1, ImageTransformer.Parameters p2, boolean inverse2) {
            throw new UnsupportedOperationException("Compose operation not supported.");
        }

        public boolean preoptimize() {
            double[] p = this.setSubspaceInternal(this.getSubspaceInternal());
            if (p != null) {
                this.set(8, p[8]);
                this.set(9, p[9]);
                this.set(10, p[10]);
                return true;
            }
            return false;
        }

        public void setSubspace(double ... p) {
            double[] dst = this.setSubspaceInternal(p);
            if (dst != null) {
                this.set(dst);
            }
        }

        public double[] getSubspace() {
            return this.getSubspaceInternal();
        }

        private double[] setSubspaceInternal(double ... p) {
            if (ProCamTransformer.this.invFrontoParallelH == null) {
                return null;
            }
            double[] dst = new double[11];
            this.t.put(p[0], p[1], p[2]);
            opencv_calib3d.cvRodrigues2(this.t, this.R, null);
            this.t.put(p[3], p[4], p[5]);
            this.H.put(this.R.get(0), this.R.get(1), this.t.get(0), this.R.get(3), this.R.get(4), this.t.get(1), this.R.get(6), this.R.get(7), this.t.get(2));
            opencv_core.cvMatMul(this.H, ProCamTransformer.this.invFrontoParallelH, this.H);
            opencv_core.cvMatMul(ProCamTransformer.this.surfaceTransformer.getK2(), this.H, this.H);
            opencv_core.cvMatMul(this.H, ProCamTransformer.this.surfaceTransformer.getInvK1(), this.H);
            opencv_core.cvGEMM(this.R, this.t, 1.0, null, 0.0, this.t, 1);
            double scale = 1.0 / this.t.get(2);
            this.n.put(0.0, 0.0, 1.0);
            opencv_core.cvGEMM(this.R, this.n, scale, null, 0.0, this.n, 0);
            double[] src = ProCamTransformer.this.projectorTransformer.getReferencePoints2();
            JavaCV.perspectiveTransform(src, dst, ProCamTransformer.this.projectorTransformer.getInvK1(), ProCamTransformer.this.projectorTransformer.getK2(), ProCamTransformer.this.projectorTransformer.getR(), ProCamTransformer.this.projectorTransformer.getT(), this.n, true);
            dst[8] = dst[0];
            dst[9] = dst[2];
            dst[10] = dst[4];
            JavaCV.perspectiveTransform(ProCamTransformer.this.surfaceTransformer.getReferencePoints1(), dst, this.H);
            return dst;
        }

        private double[] getSubspaceInternal() {
            if (ProCamTransformer.this.frontoParallelH == null) {
                return null;
            }
            opencv_core.cvMatMul(ProCamTransformer.this.surfaceTransformer.getK1(), ProCamTransformer.this.frontoParallelH, this.H);
            opencv_core.cvMatMul(this.surfaceParameters.getH(), this.H, this.H);
            opencv_core.cvMatMul(ProCamTransformer.this.surfaceTransformer.getInvK2(), this.H, this.H);
            JavaCV.HtoRt(this.H, this.R, this.t);
            opencv_calib3d.cvRodrigues2(this.R, this.n, null);
            double[] p = new double[]{this.n.get(0), this.n.get(1), this.n.get(2), this.t.get(0), this.t.get(1), this.t.get(2)};
            return p;
        }

        public opencv_core.CvMat getSrcN() {
            double[] src = ProCamTransformer.this.projectorTransformer.getReferencePoints2();
            double[] dst = (double[])ProCamTransformer.this.projectorTransformer.getReferencePoints1().clone();
            dst[0] = this.projectorParameters.get(0);
            dst[2] = this.projectorParameters.get(1);
            dst[4] = this.projectorParameters.get(2);
            opencv_core.cvTranspose(ProCamTransformer.this.projectorTransformer.getR(), this.R);
            opencv_core.cvGEMM(this.R, ProCamTransformer.this.projectorTransformer.getT(), -1.0, null, 0.0, this.t, 0);
            JavaCV.getPlaneParameters(src, dst, ProCamTransformer.this.projectorTransformer.getInvK2(), ProCamTransformer.this.projectorTransformer.getK1(), this.R, this.t, this.n);
            double d = 1.0 + opencv_core.cvDotProduct(this.n, ProCamTransformer.this.projectorTransformer.getT());
            opencv_core.cvGEMM(this.R, this.n, 1.0 / d, null, 0.0, this.n, 0);
            ProCamTransformer.this.camera.getFrontoParallelH(this.surfaceParameters.get(), this.n, this.R);
            opencv_core.cvInvert(this.surfaceParameters.getH(), this.H);
            opencv_core.cvMatMul(this.H, ProCamTransformer.this.surfaceTransformer.getK2(), this.H);
            opencv_core.cvMatMul(this.H, this.R, this.H);
            opencv_core.cvMatMul(ProCamTransformer.this.surfaceTransformer.getInvK1(), this.H, this.H);
            JavaCV.HtoRt(this.H, this.R, this.t);
            opencv_core.cvGEMM(this.R, this.t, 1.0, null, 0.0, this.t, 1);
            double scale = 1.0 / this.t.get(2);
            this.n.put(0.0, 0.0, 1.0);
            opencv_core.cvGEMM(this.R, this.n, scale, null, 0.0, this.n, 0);
            return this.n;
        }

        public Parameters clone() {
            Parameters p = new Parameters();
            p.surfaceParameters = this.surfaceParameters.clone();
            p.projectorParameters = this.projectorParameters.clone();
            return p;
        }

        public String toString() {
            return this.surfaceParameters.toString() + this.projectorParameters.toString();
        }

        static /* synthetic */ opencv_core.IplImage[] access$002(Parameters x0, opencv_core.IplImage[] x1) {
            x0.tempImage = x1;
            return x1;
        }
    }
}

