/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.freenect;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class OpenKinectFrameGrabber
extends FrameGrabber {
    private static Exception loadingException = null;
    private int deviceNumber = 0;
    private boolean depth = false;
    private BytePointer rawDepthImageData = new BytePointer((Pointer)null);
    private BytePointer rawVideoImageData = new BytePointer((Pointer)null);
    private opencv_core.IplImage rawDepthImage = null;
    private opencv_core.IplImage rawVideoImage = null;
    private opencv_core.IplImage returnImage = null;
    private int[] timestamp = new int[]{0};

    public static String[] getDeviceDescriptions() throws Exception {
        OpenKinectFrameGrabber.tryLoad();
        freenect.freenect_context ctx = new freenect.freenect_context(null);
        int err = freenect.freenect_init(ctx, null);
        if (err < 0) {
            throw new Exception("freenect_init() Error " + err + ": Failed to init context.");
        }
        int count = freenect.freenect_num_devices(ctx);
        if (count < 0) {
            throw new Exception("freenect_num_devices() Error " + err + ": Failed to get number of devices.");
        }
        String[] descriptions = new String[count];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = "Kinect #" + i;
        }
        err = freenect.freenect_shutdown(ctx);
        if (err < 0) {
            throw new Exception("freenect_shutdown() Error " + err + ": Failed to shutdown context.");
        }
        return descriptions;
    }

    public static void tryLoad() throws Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(freenect.class);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                loadingException = (Exception)t;
                throw loadingException;
            }
            loadingException = new Exception(t);
            throw loadingException;
        }
    }

    public OpenKinectFrameGrabber(int deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    public void release() throws Exception {
        this.stop();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public void start() throws Exception {
        this.depth = "depth".equalsIgnoreCase(this.format);
    }

    public void stop() throws Exception {
        freenect.freenect_sync_stop();
    }

    public void trigger() throws Exception {
        int fmt = this.bpp;
        for (int i = 0; i < this.triggerFlushSize; ++i) {
            int err;
            if (this.depth) {
                err = freenect.freenect_sync_get_depth((Pointer)this.rawDepthImageData, this.timestamp, this.deviceNumber, fmt);
                if (err == 0) continue;
                throw new Exception("freenect_sync_get_depth() Error " + err + ": Failed to get depth synchronously.");
            }
            err = freenect.freenect_sync_get_video((Pointer)this.rawVideoImageData, this.timestamp, this.deviceNumber, fmt);
            if (err == 0) continue;
            throw new Exception("freenect_sync_get_video() Error " + err + ": Failed to get video synchronously.");
        }
    }

    public opencv_core.IplImage grabDepth() throws Exception {
        int fmt = this.bpp;
        int iplDepth = 16;
        int channels = 1;
        switch (fmt) {
            case 0: 
            case 1: {
                iplDepth = 16;
                channels = 1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int err = freenect.freenect_sync_get_depth((Pointer)this.rawDepthImageData, this.timestamp, this.deviceNumber, fmt);
        if (err != 0) {
            throw new Exception("freenect_sync_get_depth() Error " + err + ": Failed to get depth synchronously.");
        }
        int w = 640;
        int h = 480;
        if (this.rawDepthImage == null || this.rawDepthImage.width() != w || this.rawDepthImage.height() != h) {
            this.rawDepthImage = opencv_core.IplImage.createHeader(w, h, iplDepth, channels);
        }
        opencv_core.cvSetData(this.rawDepthImage, (Pointer)this.rawDepthImageData, w * channels * iplDepth / 8);
        if (iplDepth > 8 && ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ByteBuffer bb = this.rawDepthImage.getByteBuffer();
            ShortBuffer in = bb.order(ByteOrder.BIG_ENDIAN).asShortBuffer();
            ShortBuffer out = bb.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            out.put(in);
        }
        this.rawDepthImage.timestamp = this.timestamp[0];
        return this.rawDepthImage;
    }

    public opencv_core.IplImage grabVideo() throws Exception {
        int fmt = this.bpp;
        int iplDepth = 8;
        int channels = 3;
        switch (fmt) {
            case 0: {
                iplDepth = 8;
                channels = 3;
                break;
            }
            case 1: 
            case 2: {
                iplDepth = 8;
                channels = 1;
                break;
            }
            case 3: {
                iplDepth = 16;
                channels = 1;
                break;
            }
            case 5: {
                iplDepth = 8;
                channels = 3;
                break;
            }
            case 6: {
                iplDepth = 8;
                channels = 2;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int err = freenect.freenect_sync_get_video((Pointer)this.rawVideoImageData, this.timestamp, this.deviceNumber, fmt);
        if (err != 0) {
            throw new Exception("freenect_sync_get_video() Error " + err + ": Failed to get video synchronously.");
        }
        int w = 640;
        int h = 480;
        if (this.rawVideoImage == null || this.rawVideoImage.width() != w || this.rawVideoImage.height() != h) {
            this.rawVideoImage = opencv_core.IplImage.createHeader(w, h, iplDepth, channels);
        }
        opencv_core.cvSetData(this.rawVideoImage, (Pointer)this.rawVideoImageData, w * channels * iplDepth / 8);
        if (iplDepth > 8 && ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ByteBuffer bb = this.rawVideoImage.getByteBuffer();
            ShortBuffer in = bb.order(ByteOrder.BIG_ENDIAN).asShortBuffer();
            ShortBuffer out = bb.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            out.put(in);
        }
        if (channels == 3) {
            opencv_imgproc.cvCvtColor(this.rawVideoImage, this.rawVideoImage, 4);
        }
        this.rawVideoImage.timestamp = this.timestamp[0];
        return this.rawVideoImage;
    }

    public opencv_core.IplImage grab() throws Exception {
        opencv_core.IplImage image = this.depth ? this.grabDepth() : this.grabVideo();
        int w = image.width();
        int h = image.height();
        int iplDepth = image.depth();
        int channels = image.nChannels();
        if (this.colorMode == FrameGrabber.ColorMode.BGR && channels == 1) {
            if (this.returnImage == null) {
                this.returnImage = opencv_core.IplImage.create(w, h, iplDepth, 3);
            }
            opencv_imgproc.cvCvtColor(image, this.returnImage, 8);
            this.returnImage.timestamp = image.timestamp;
            return this.returnImage;
        }
        if (this.colorMode == FrameGrabber.ColorMode.GRAY && channels == 3) {
            if (this.returnImage == null) {
                this.returnImage = opencv_core.IplImage.create(w, h, iplDepth, 1);
            }
            opencv_imgproc.cvCvtColor(image, this.returnImage, 6);
            this.returnImage.timestamp = image.timestamp;
            return this.returnImage;
        }
        return image;
    }
}

