/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameRecorder;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_highgui;

public class OpenCVFrameRecorder
extends FrameRecorder {
    private static final boolean windows = Loader.getPlatformName().startsWith("windows");
    private String filename;
    private opencv_highgui.CvVideoWriter writer = null;

    public OpenCVFrameRecorder(String filename, int imageWidth, int imageHeight) {
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = 1;
        this.codecID = windows ? -1 : opencv_highgui.CV_FOURCC_DEFAULT;
        this.bitrate = 0;
        this.frameRate = 30.0;
    }

    public void release() throws Exception {
        this.stop();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public void start() throws Exception {
        this.writer = opencv_highgui.cvCreateVideoWriter(this.filename, this.codecID, this.frameRate, opencv_core.cvSize(this.imageWidth, this.imageHeight), this.pixelFormat);
        if (this.writer == null) {
            throw new Exception("cvCreateVideoWriter(): Could not create a writer");
        }
    }

    public void stop() throws Exception {
        if (this.writer != null) {
            opencv_highgui.cvReleaseVideoWriter(this.writer);
            this.writer = null;
        }
    }

    public void record(opencv_core.IplImage frame) throws Exception {
        if (this.writer != null) {
            if (opencv_highgui.cvWriteFrame(this.writer, frame) == 0) {
                throw new Exception("cvWriteFrame(): Could not record frame");
            }
        } else {
            throw new Exception("Cannot record: There is no writer");
        }
    }
}

