/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JOptionPane;

public class JavaCvErrorCallback
extends opencv_core.CvErrorCallback {
    private long lastErrorTime = 0L;
    private Component parent;
    private boolean showDialog;
    private int rc;

    public JavaCvErrorCallback(boolean showDialog, Component parent, int rc) {
        this.parent = parent;
        this.showDialog = showDialog;
        this.rc = rc;
    }

    public JavaCvErrorCallback(boolean showDialog, Component parent) {
        this(showDialog, parent, 0);
    }

    public JavaCvErrorCallback(boolean showDialog) {
        this(showDialog, null);
    }

    public JavaCvErrorCallback() {
        this(false);
    }

    public int call(int status, String func_name, String err_msg, String file_name, int line, Pointer userdata) {
        String title = "OpenCV Error";
        final String message = opencv_core.cvErrorStr(status) + " (" + err_msg + ")\nin function " + func_name + ", " + file_name + "(" + line + ")";
        System.err.println("OpenCV Error: " + message);
        Thread.dumpStack();
        if (this.showDialog) {
            if (System.currentTimeMillis() - this.lastErrorTime > 1000L) {
                if (EventQueue.isDispatchThread()) {
                    JOptionPane.showMessageDialog(this.parent, message, "OpenCV Error", 0);
                } else {
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(JavaCvErrorCallback.this.parent, message, "OpenCV Error", 0);
                            }
                        });
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            this.lastErrorTime = System.currentTimeMillis();
        }
        return this.rc;
    }
}

