/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.DC1394FrameGrabber;
import com.googlecode.javacv.FFmpegFrameGrabber;
import com.googlecode.javacv.FlyCaptureFrameGrabber;
import com.googlecode.javacv.OpenCVFrameGrabber;
import com.googlecode.javacv.OpenKinectFrameGrabber;
import com.googlecode.javacv.VideoInputFrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameGrabber {
    public static final List<Class<? extends FrameGrabber>> list = new LinkedList<Class<? extends FrameGrabber>>();
    protected String format = null;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected double frameRate = 0.0;
    protected boolean triggerMode = false;
    protected int triggerFlushSize = 0;
    protected int bpp = 0;
    protected ColorMode colorMode = ColorMode.BGR;
    protected int timeout = 10000;
    protected int numBuffers = 4;
    protected double gamma = 0.0;
    protected boolean deinterlace = false;

    public static void init() {
        for (Class<? extends FrameGrabber> c : list) {
            try {
                c.getMethod("tryLoad", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {}
        }
    }

    public static Class<? extends FrameGrabber> getDefault() {
        Class<? extends FrameGrabber> c = null;
        for (int i = 0; i < list.size(); ++i) {
            try {
                boolean mayContainCameras;
                block6: {
                    c = list.get(i);
                    c.getMethod("tryLoad", new Class[0]).invoke(null, new Object[0]);
                    mayContainCameras = false;
                    try {
                        String[] s = (String[])c.getMethod("getDeviceDescriptions", new Class[0]).invoke(null, new Object[0]);
                        if (s.length > 0) {
                            mayContainCameras = true;
                        }
                    }
                    catch (Throwable t) {
                        if (!(t.getCause() instanceof UnsupportedOperationException)) break block6;
                        mayContainCameras = true;
                    }
                }
                if (!mayContainCameras) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return c;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public boolean isTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(boolean triggerMode) {
        this.triggerMode = triggerMode;
    }

    public int getTriggerFlushSize() {
        return this.triggerFlushSize;
    }

    public void setTriggerFlushSize(int triggerFlushSize) {
        this.triggerFlushSize = triggerFlushSize;
    }

    public int getBitsPerPixel() {
        return this.bpp;
    }

    public void setBitsPerPixel(int bitsPerPixel) {
        this.bpp = bitsPerPixel;
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(ColorMode colorMode) {
        this.colorMode = colorMode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getNumBuffers() {
        return this.numBuffers;
    }

    public void setNumBuffers(int numBuffers) {
        this.numBuffers = numBuffers;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public boolean isDeinterlace() {
        return this.deinterlace;
    }

    public void setDeinterlace(boolean deinterlace) {
        this.deinterlace = deinterlace;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void trigger() throws Exception;

    public abstract opencv_core.IplImage grab() throws Exception;

    public abstract void release() throws Exception;

    public Array createArray(FrameGrabber[] frameGrabbers) {
        return new Array(frameGrabbers);
    }

    static {
        list.add(DC1394FrameGrabber.class);
        list.add(FlyCaptureFrameGrabber.class);
        list.add(OpenKinectFrameGrabber.class);
        list.add(VideoInputFrameGrabber.class);
        list.add(OpenCVFrameGrabber.class);
        list.add(FFmpegFrameGrabber.class);
    }

    public static class Array {
        private opencv_core.IplImage[] grabbedImages = null;
        private long[] latencies = null;
        private long[] bestLatencies = null;
        private long lastNewestTimestamp = 0L;
        private long bestInterval = Long.MAX_VALUE;
        protected FrameGrabber[] frameGrabbers = null;

        protected Array(FrameGrabber[] frameGrabbers) {
            this.setFrameGrabbers(frameGrabbers);
        }

        public FrameGrabber[] getFrameGrabbers() {
            return this.frameGrabbers;
        }

        public void setFrameGrabbers(FrameGrabber[] frameGrabbers) {
            this.frameGrabbers = frameGrabbers;
            this.grabbedImages = new opencv_core.IplImage[frameGrabbers.length];
            this.latencies = new long[frameGrabbers.length];
            this.bestLatencies = null;
            this.lastNewestTimestamp = 0L;
        }

        public int size() {
            return this.frameGrabbers.length;
        }

        public void start() throws Exception {
            for (FrameGrabber f : this.frameGrabbers) {
                f.start();
            }
        }

        public void stop() throws Exception {
            for (FrameGrabber f : this.frameGrabbers) {
                f.stop();
            }
        }

        public void trigger() throws Exception {
            for (FrameGrabber f : this.frameGrabbers) {
                if (!f.isTriggerMode()) continue;
                f.trigger();
            }
        }

        public opencv_core.IplImage[] grab() throws Exception {
            int i;
            if (this.frameGrabbers.length == 1) {
                this.grabbedImages[0] = this.frameGrabbers[0].grab();
                return this.grabbedImages;
            }
            long newestTimestamp = 0L;
            for (i = 0; i < this.frameGrabbers.length; ++i) {
                this.grabbedImages[i] = this.frameGrabbers[i].grab();
                if (this.grabbedImages[i] == null) continue;
                newestTimestamp = Math.max(newestTimestamp, this.grabbedImages[i].timestamp);
            }
            for (i = 0; i < this.frameGrabbers.length; ++i) {
                if (this.grabbedImages[i] == null) continue;
                this.latencies[i] = newestTimestamp - this.grabbedImages[i].timestamp;
            }
            if (this.bestLatencies == null) {
                this.bestLatencies = Arrays.copyOf(this.latencies, this.latencies.length);
            } else {
                int sum1 = 0;
                int sum2 = 0;
                for (int i2 = 0; i2 < this.frameGrabbers.length; ++i2) {
                    sum1 = (int)((long)sum1 + this.latencies[i2]);
                    sum2 = (int)((long)sum2 + this.bestLatencies[i2]);
                }
                if (sum1 < sum2) {
                    this.bestLatencies = Arrays.copyOf(this.latencies, this.latencies.length);
                }
            }
            this.bestInterval = Math.min(this.bestInterval, newestTimestamp - this.lastNewestTimestamp);
            for (i = 0; i < this.bestLatencies.length; ++i) {
                this.bestLatencies[i] = Math.min(this.bestLatencies[i], this.bestInterval * 9L / 10L);
            }
            for (int j = 0; j < 2; ++j) {
                block5: for (int i3 = 0; i3 < this.frameGrabbers.length; ++i3) {
                    if (this.frameGrabbers[i3].isTriggerMode() || this.grabbedImages[i3] == null) continue;
                    int latency = (int)(newestTimestamp - this.grabbedImages[i3].timestamp);
                    while ((double)((long)latency - this.bestLatencies[i3]) > 0.1 * (double)this.bestLatencies[i3]) {
                        this.grabbedImages[i3] = this.frameGrabbers[i3].grab();
                        if (this.grabbedImages[i3] == null) continue block5;
                        latency = (int)(newestTimestamp - this.grabbedImages[i3].timestamp);
                        if (latency >= 0) continue;
                        newestTimestamp = this.grabbedImages[i3].timestamp;
                        continue block5;
                    }
                }
            }
            this.lastNewestTimestamp = newestTimestamp;
            return this.grabbedImages;
        }

        public void release() throws Exception {
            for (FrameGrabber f : this.frameGrabbers) {
                f.release();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorMode {
        BGR,
        GRAY,
        RAW;

    }

    public static class PropertyEditor
    extends PropertyEditorSupport {
        public String getAsText() {
            Class c = (Class)this.getValue();
            return c == null ? "null" : c.getSimpleName();
        }

        public void setAsText(String s) {
            if (s == null) {
                this.setValue(null);
            }
            for (int i = 0; i < list.size(); ++i) {
                Class<? extends FrameGrabber> c = list.get(i);
                if (!s.equals(c.getSimpleName())) continue;
                this.setValue(c);
            }
        }

        public String[] getTags() {
            String[] s = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                s[i] = list.get(i).getSimpleName();
            }
            return s;
        }
    }
}

