/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.PGRFlyCapture;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class FlyCaptureFrameGrabber
extends FrameGrabber {
    private static Exception loadingException = null;
    public static final int INITIALIZE = 0;
    public static final int TRIGGER_INQ = 1328;
    public static final int IS_CAMERA_POWER = 1024;
    public static final int CAMERA_POWER = 1552;
    public static final int SOFTWARE_TRIGGER = 1580;
    public static final int SOFT_ASYNC_TRIGGER = 4140;
    public static final int IMAGE_DATA_FORMAT = 4168;
    private PGRFlyCapture.FlyCaptureContext context = new PGRFlyCapture.FlyCaptureContext(null);
    private PGRFlyCapture.FlyCaptureImage raw_image = new PGRFlyCapture.FlyCaptureImage();
    private PGRFlyCapture.FlyCaptureImage conv_image = new PGRFlyCapture.FlyCaptureImage();
    private opencv_core.IplImage temp_image;
    private opencv_core.IplImage return_image = null;
    private int[] regOut = new int[1];
    private float[] gammaOut = new float[1];

    public static String[] getDeviceDescriptions() throws Exception {
        FlyCaptureFrameGrabber.tryLoad();
        int[] count = new int[1];
        int error = PGRFlyCapture.flycaptureBusCameraCount(count);
        if (error != 0) {
            throw new Exception("flycaptureBusCameraCount() Error " + error);
        }
        int c = count[0];
        String[] descriptions = new String[c];
        if (c > 0) {
            PGRFlyCapture.FlyCaptureInfoEx info = new PGRFlyCapture.FlyCaptureInfoEx(c);
            error = PGRFlyCapture.flycaptureBusEnumerateCamerasEx(info, count);
            if (error != 0) {
                throw new Exception("flycaptureBusEnumerateCamerasEx() Error " + error);
            }
            for (int i = 0; i < descriptions.length; ++i) {
                info.position(i);
                descriptions[i] = info.pszVendorName() + " " + info.pszModelName() + " " + info.SerialNumber();
            }
        }
        return descriptions;
    }

    public static void tryLoad() throws Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(PGRFlyCapture.class);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                loadingException = (Exception)t;
                throw loadingException;
            }
            loadingException = new Exception(t);
            throw loadingException;
        }
    }

    public FlyCaptureFrameGrabber(int deviceNumber) throws Exception {
        int error = PGRFlyCapture.flycaptureCreateContext(this.context);
        if (error != 0) {
            throw new Exception("flycaptureCreateContext() Error " + error);
        }
        error = PGRFlyCapture.flycaptureInitializePlus(this.context, deviceNumber, this.numBuffers, null);
        if (error != 0) {
            throw new Exception("flycaptureInitialize() Error " + error);
        }
    }

    public void release() throws Exception {
        if (this.context != null) {
            this.stop();
            int error = PGRFlyCapture.flycaptureDestroyContext(this.context);
            this.context = null;
            if (error != 0) {
                throw new Exception("flycaptureDestroyContext() Error " + error);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public double getGamma() {
        return this.gammaOut[0];
    }

    public void start() throws Exception {
        int f = 11;
        if (this.frameRate <= 0.0) {
            f = 11;
        } else if (this.frameRate <= 1.876) {
            f = 0;
        } else if (this.frameRate <= 3.76) {
            f = 1;
        } else if (this.frameRate <= 7.51) {
            f = 2;
        } else if (this.frameRate <= 15.01) {
            f = 3;
        } else if (this.frameRate <= 30.01) {
            f = 4;
        } else if (this.frameRate <= 60.01) {
            f = 6;
        } else if (this.frameRate <= 120.01) {
            f = 7;
        } else if (this.frameRate <= 240.01) {
            f = 8;
        }
        int c = 16;
        if (this.colorMode == FrameGrabber.ColorMode.BGR || this.colorMode == FrameGrabber.ColorMode.RAW) {
            if (this.imageWidth <= 0 || this.imageHeight <= 0) {
                c = 16;
            } else if (this.imageWidth <= 640 && this.imageHeight <= 480) {
                c = 4;
            } else if (this.imageWidth <= 800 && this.imageHeight <= 600) {
                c = 18;
            } else if (this.imageWidth <= 1024 && this.imageHeight <= 768) {
                c = 21;
            } else if (this.imageWidth <= 1280 && this.imageHeight <= 960) {
                c = 23;
            } else if (this.imageWidth <= 1600 && this.imageHeight <= 1200) {
                c = 51;
            }
        } else if (this.colorMode == FrameGrabber.ColorMode.GRAY) {
            if (this.imageWidth <= 0 || this.imageHeight <= 0) {
                c = 16;
            } else if (this.imageWidth <= 640 && this.imageHeight <= 480) {
                c = this.bpp > 8 ? 6 : 5;
            } else if (this.imageWidth <= 800 && this.imageHeight <= 600) {
                c = this.bpp > 8 ? 19 : 7;
            } else if (this.imageWidth <= 1024 && this.imageHeight <= 768) {
                c = this.bpp > 8 ? 9 : 8;
            } else if (this.imageWidth <= 1280 && this.imageHeight <= 960) {
                c = this.bpp > 8 ? 24 : 10;
            } else if (this.imageWidth <= 1600 && this.imageHeight <= 1200) {
                c = this.bpp > 8 ? 52 : 11;
            }
        }
        int[] iPolarity = new int[1];
        int[] iSource = new int[1];
        int[] iRawValue = new int[1];
        int[] iMode = new int[1];
        int error = PGRFlyCapture.flycaptureGetTrigger(this.context, null, iPolarity, iSource, iRawValue, iMode, null);
        if (error != 0) {
            throw new Exception("flycaptureGetTrigger() Error " + error);
        }
        error = PGRFlyCapture.flycaptureSetTrigger(this.context, this.triggerMode, iPolarity[0], 7, 0, 0);
        if (error != 0) {
            throw new Exception("flycaptureSetTrigger() Error " + error);
        }
        if (this.triggerMode) {
            this.waitForTriggerReady();
        }
        if ((error = PGRFlyCapture.flycaptureGetCameraRegister(this.context, 4168, this.regOut)) != 0) {
            throw new Exception("flycaptureGetCameraRegister() Error " + error);
        }
        int reg = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? this.regOut[0] | 1 : this.regOut[0] & 0xFFFFFFFE;
        error = PGRFlyCapture.flycaptureSetCameraRegister(this.context, 4168, reg);
        if (error != 0) {
            throw new Exception("flycaptureSetCameraRegister() Error " + error);
        }
        error = PGRFlyCapture.flycaptureSetBusSpeed(this.context, 7, 7);
        if (error != 0 && (error = PGRFlyCapture.flycaptureSetBusSpeed(this.context, 8, 8)) != 0) {
            throw new Exception("flycaptureSetBusSpeed() Error " + error);
        }
        if (this.gamma != 0.0 && (error = PGRFlyCapture.flycaptureSetCameraAbsProperty(this.context, 6, (float)this.gamma)) != 0) {
            throw new Exception("flycaptureSetCameraAbsProperty() Error " + error + ": Could not set gamma.");
        }
        error = PGRFlyCapture.flycaptureGetCameraAbsProperty(this.context, 6, this.gammaOut);
        if (error != 0) {
            this.gammaOut[0] = 2.2f;
        }
        if ((error = PGRFlyCapture.flycaptureStart(this.context, c, f)) != 0) {
            throw new Exception("flycaptureStart() Error " + error);
        }
        error = PGRFlyCapture.flycaptureSetGrabTimeoutEx(this.context, this.timeout);
        if (error != 0) {
            throw new Exception("flycaptureSetGrabTimeoutEx() Error " + error);
        }
    }

    private void waitForTriggerReady() throws Exception {
        long time = System.currentTimeMillis();
        do {
            int error;
            if ((error = PGRFlyCapture.flycaptureGetCameraRegister(this.context, 1580, this.regOut)) == 0) continue;
            throw new Exception("flycaptureGetCameraRegister() Error " + error);
        } while (System.currentTimeMillis() - time <= (long)this.timeout && this.regOut[0] >>> 31 != 0);
    }

    public void stop() throws Exception {
        int error = PGRFlyCapture.flycaptureStop(this.context);
        if (error != 0 && error != 1) {
            throw new Exception("flycaptureStop() Error " + error);
        }
        this.temp_image = null;
        this.return_image = null;
    }

    public void trigger() throws Exception {
        this.waitForTriggerReady();
        int error = PGRFlyCapture.flycaptureSetCameraRegister(this.context, 4140, Integer.MIN_VALUE);
        if (error != 0) {
            throw new Exception("flycaptureSetCameraRegister() Error " + error);
        }
    }

    private int getNumChannels(int pixelFormat) {
        switch (pixelFormat) {
            case 16: 
            case 64: 
            case 256: 
            case 0x10000001: {
                return 3;
            }
            case 1: 
            case 32: 
            case 128: 
            case 512: 
            case 1024: {
                return 1;
            }
            case 0x10000002: {
                return 4;
            }
        }
        return -1;
    }

    private int getDepth(int pixelFormat) {
        switch (pixelFormat) {
            case 1: 
            case 16: 
            case 512: 
            case 0x10000001: 
            case 0x10000002: {
                return 8;
            }
            case 32: 
            case 64: 
            case 1024: {
                return 16;
            }
            case 128: 
            case 256: {
                return -2147483632;
            }
        }
        return 8;
    }

    public opencv_core.IplImage grab() throws Exception {
        int error = PGRFlyCapture.flycaptureGrabImage2(this.context, this.raw_image);
        if (error != 0) {
            throw new Exception("flycaptureGrabImage2() Error " + error + " (Has start() been called?)");
        }
        int w = this.raw_image.iCols();
        int h = this.raw_image.iRows();
        int format = this.raw_image.pixelFormat();
        int depth = this.getDepth(format);
        int stride = this.raw_image.iRowInc();
        int size = h * stride;
        int numChannels = this.getNumChannels(format);
        error = PGRFlyCapture.flycaptureGetCameraRegister(this.context, 4168, this.regOut);
        if (error != 0) {
            throw new Exception("flycaptureGetCameraRegister() Error " + error);
        }
        ByteOrder frameEndian = (this.regOut[0] & 1) != 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        boolean alreadySwapped = false;
        boolean colorbayer = this.raw_image.bStippled();
        boolean colorrgb = format == 16 || format == 64 || format == 0x10000001 || format == 0x10000002;
        boolean coloryuv = format == 2 || format == 4 || format == 8;
        BytePointer imageData = this.raw_image.pData();
        if ((depth == 8 || frameEndian.equals(ByteOrder.nativeOrder())) && (this.colorMode == FrameGrabber.ColorMode.RAW || this.colorMode == FrameGrabber.ColorMode.BGR && numChannels == 3 || this.colorMode == FrameGrabber.ColorMode.GRAY && numChannels == 1 && !colorbayer)) {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.createHeader(w, h, depth, numChannels);
            }
            this.return_image.widthStep(stride);
            this.return_image.imageSize(size);
            this.return_image.imageData(imageData);
        } else {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.create(w, h, depth, this.colorMode == FrameGrabber.ColorMode.BGR ? 3 : 1);
            }
            if (this.temp_image == null) {
                this.temp_image = this.colorMode == FrameGrabber.ColorMode.BGR && (numChannels > 1 || depth > 8) && !coloryuv && !colorbayer ? opencv_core.IplImage.create(w, h, depth, numChannels) : (this.colorMode == FrameGrabber.ColorMode.GRAY && colorbayer ? opencv_core.IplImage.create(w, h, depth, 3) : (this.colorMode == FrameGrabber.ColorMode.GRAY && colorrgb ? opencv_core.IplImage.createHeader(w, h, depth, 3) : (this.colorMode == FrameGrabber.ColorMode.BGR && numChannels == 1 && !coloryuv && !colorbayer ? opencv_core.IplImage.createHeader(w, h, depth, 1) : this.return_image)));
            }
            this.conv_image.iRowInc(this.temp_image.widthStep());
            this.conv_image.pData(this.temp_image.imageData());
            if (depth == 8) {
                this.conv_image.pixelFormat(this.colorMode == FrameGrabber.ColorMode.RAW ? 512 : (this.temp_image.nChannels() == 1 ? 1 : 0x10000001));
            } else {
                this.conv_image.pixelFormat(this.colorMode == FrameGrabber.ColorMode.RAW ? 1024 : (this.temp_image.nChannels() == 1 ? 32 : 64));
            }
            if (depth != 8 && this.conv_image.pixelFormat() == format && this.conv_image.iRowInc() == stride) {
                ShortBuffer in = this.raw_image.getByteBuffer().order(frameEndian).asShortBuffer();
                ShortBuffer out = this.temp_image.getByteBuffer().order(ByteOrder.nativeOrder()).asShortBuffer();
                out.put(in);
                alreadySwapped = true;
            } else if (this.colorMode == FrameGrabber.ColorMode.GRAY && colorrgb || this.colorMode == FrameGrabber.ColorMode.BGR && numChannels == 1 && !coloryuv && !colorbayer) {
                this.temp_image.widthStep(stride);
                this.temp_image.imageSize(size);
                this.temp_image.imageData(imageData);
            } else if (!colorrgb && (colorbayer || coloryuv || numChannels > 1) && (error = PGRFlyCapture.flycaptureConvertImage(this.context, this.raw_image, this.conv_image)) != 0) {
                throw new Exception("flycaptureConvertImage() Error " + error);
            }
            if (!alreadySwapped && depth != 8 && !frameEndian.equals(ByteOrder.nativeOrder())) {
                ByteBuffer bb = this.temp_image.getByteBuffer();
                ShortBuffer in = bb.order(frameEndian).asShortBuffer();
                ShortBuffer out = bb.order(ByteOrder.nativeOrder()).asShortBuffer();
                out.put(in);
            }
            if (this.colorMode == FrameGrabber.ColorMode.BGR && numChannels == 1 && !coloryuv && !colorbayer) {
                opencv_imgproc.cvCvtColor(this.temp_image, this.return_image, 8);
            } else if (this.colorMode == FrameGrabber.ColorMode.GRAY && (colorbayer || colorrgb)) {
                opencv_imgproc.cvCvtColor(this.temp_image, this.return_image, 6);
            }
        }
        PGRFlyCapture.FlyCaptureTimestamp timeStamp = this.raw_image.timeStamp();
        this.return_image.timestamp = timeStamp.ulSeconds() * 1000000 + timeStamp.ulMicroSeconds();
        return this.return_image;
    }
}

