/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.ShortBuffer;

public class ShortPointer
extends Pointer {
    public ShortPointer(short ... array) {
        this(array.length);
        this.asBuffer().put(array);
    }

    public ShortPointer(ShortBuffer buffer) {
        super(buffer);
        if (buffer.hasArray()) {
            short[] array = buffer.array();
            this.allocateArray(array.length);
            this.asBuffer().put(array);
            this.position(buffer.position());
        }
    }

    public ShortPointer(int size) {
        this.allocateArray(size);
    }

    public ShortPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public ShortPointer position(int position) {
        return (ShortPointer)super.position(position);
    }

    public ShortPointer capacity(int capacity) {
        return (ShortPointer)super.capacity(capacity);
    }

    public short get() {
        return this.get(0);
    }

    public native short get(int var1);

    public ShortPointer put(short s) {
        return this.put(0, s);
    }

    public native ShortPointer put(int var1, short var2);

    public final ShortBuffer asBuffer() {
        return this.asByteBuffer().asShortBuffer();
    }
}

