/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.annotation.Opaque;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Opaque
public class Pointer {
    private static final Field bufferAddressField;
    private static final ReferenceQueue<Pointer> referenceQueue;
    protected long address;
    protected int position;
    protected int capacity;
    private Deallocator deallocator;

    public Pointer() {
    }

    public Pointer(Pointer p) {
        if (p == null) {
            this.address = 0L;
            this.position = 0;
            this.capacity = 0;
        } else {
            this.address = p.address;
            this.position = p.position;
            this.capacity = p.capacity;
        }
    }

    public Pointer(Buffer b) {
        if (b == null || b.hasArray()) {
            this.address = 0L;
            this.position = 0;
            this.capacity = 0;
        } else {
            try {
                this.address = bufferAddressField.getLong(b);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.position = b.position();
            this.capacity = b.capacity();
        }
    }

    void init(long allocatedAddress, int allocatedCapacity, long deallocatorAddress) {
        this.address = allocatedAddress;
        this.capacity = allocatedCapacity;
        this.deallocator(new ReferenceDeallocator(this, allocatedAddress, deallocatorAddress));
    }

    public boolean isNull() {
        return this.address == 0L;
    }

    public void setNull() {
        this.address = 0L;
    }

    public int position() {
        return this.position;
    }

    public Pointer position(int position) {
        this.position = position;
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    public Pointer capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    protected Deallocator deallocator() {
        return this.deallocator;
    }

    protected Pointer deallocator(Deallocator deallocator) {
        if (this.deallocator() != null) {
            this.deallocator().deallocate();
        }
        this.deallocator = deallocator;
        DeallocatorReference r = null;
        while ((r = (DeallocatorReference)referenceQueue.poll()) != null) {
            r.clear();
            r.remove();
        }
        r = deallocator instanceof DeallocatorReference ? (DeallocatorReference)((Object)deallocator) : new DeallocatorReference(this, deallocator);
        r.add();
        return this;
    }

    public void deallocate() {
        this.deallocator.deallocate();
        this.address = 0L;
    }

    private native ByteBuffer asDirectBuffer();

    public ByteBuffer asByteBuffer() {
        if (this.isNull()) {
            return null;
        }
        int valueSize = 1;
        try {
            Class<?> c = this.getClass();
            if (c != Pointer.class) {
                valueSize = Loader.sizeof(c);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        int arrayPosition = this.position;
        int arrayCapacity = this.capacity;
        this.position = valueSize * arrayPosition;
        this.capacity = valueSize * arrayCapacity;
        ByteBuffer b = this.asDirectBuffer().order(ByteOrder.nativeOrder());
        this.position = arrayPosition;
        this.capacity = arrayCapacity;
        return b;
    }

    public Buffer asBuffer() {
        return this.asByteBuffer();
    }

    public boolean equals(Object obj) {
        if (obj == null && this.isNull()) {
            return true;
        }
        if (!(obj instanceof Pointer)) {
            return false;
        }
        Pointer other = (Pointer)obj;
        return this.address == other.address && this.position == other.position;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public String toString() {
        return this.getClass().getName() + "[address=0x" + Long.toHexString(this.address) + ",position=" + this.position + ",capacity=" + this.capacity + ",deallocator=" + this.deallocator + "]";
    }

    static {
        Field f = null;
        try {
            f = Buffer.class.getDeclaredField("address");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        bufferAddressField = f;
        referenceQueue = new ReferenceQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeallocatorReference
    extends PhantomReference<Pointer> {
        static DeallocatorReference head = null;
        DeallocatorReference prev = null;
        DeallocatorReference next = null;
        Deallocator deallocator;

        DeallocatorReference(Pointer p, Deallocator deallocator) {
            super(p, referenceQueue);
            this.deallocator = deallocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add() {
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (head == null) {
                    head = this;
                } else {
                    this.next = head;
                    this.next.prev = head = this;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void remove() {
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (this.prev == this && this.next == this) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (this.prev == null) {
                    head = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = this.next = this;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.deallocator.deallocate();
        }
    }

    private static class ReferenceDeallocator
    extends DeallocatorReference
    implements Deallocator {
        private long allocatedAddress;
        private long deallocatorAddress;

        ReferenceDeallocator(Pointer p, long allocatedAddress, long deallocatorAddress) {
            super(p, (Deallocator)null);
            this.deallocator = this;
            this.allocatedAddress = allocatedAddress;
            this.deallocatorAddress = deallocatorAddress;
        }

        public void deallocate() {
            if (this.allocatedAddress != 0L && this.deallocatorAddress != 0L) {
                this.deallocate(this.allocatedAddress, this.deallocatorAddress);
                this.deallocatorAddress = 0L;
                this.allocatedAddress = 0L;
            }
        }

        private native void deallocate(long var1, long var3);
    }

    protected static interface Deallocator {
        public void deallocate();
    }
}

