/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    static boolean loadLibraries = true;
    static Map<Class, String> loadedLibraries = Collections.synchronizedMap(new HashMap());
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatformName() {
        String jvmName = System.getProperty("java.vm.name").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (osName.startsWith("mac os x")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        return osName + "-" + osArch;
    }

    public static java.util.Properties getProperties() {
        return Loader.getProperties(Loader.getPlatformName());
    }

    public static java.util.Properties getProperties(String name) {
        java.util.Properties p = new java.util.Properties();
        p.put("platform.name", name);
        name = "properties/" + name + ".properties";
        InputStream is = Loader.class.getResourceAsStream(name);
        try {
            try {
                p.load(new InputStreamReader(is));
            }
            catch (NoSuchMethodError e) {
                p.load(is);
            }
        }
        catch (Exception e) {
            name = "properties/generic.properties";
            is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is);
                }
            }
            catch (Exception e2) {
                throw new MissingResourceException("Could not even get generic properties: " + e2.getMessage(), Loader.class.getName(), name);
            }
        }
        return p;
    }

    public static void appendProperties(java.util.Properties properties, Class<?> cls) {
        Platform[] platforms;
        String platformName = properties.getProperty("platform.name");
        Properties classProperties = cls.getAnnotation(Properties.class);
        if (classProperties == null) {
            try {
                Platform platform = cls.getAnnotation(Platform.class);
                if (platform == null) {
                    return;
                }
                platforms = new Platform[]{platform};
            }
            catch (Throwable t) {
                System.err.println("Could not append properties for " + cls + ": " + t);
                return;
            }
        } else {
            platforms = classProperties.value();
        }
        String[] define = new String[]{};
        String[] include = new String[]{};
        String[] cinclude = new String[]{};
        String[] includepath = new String[]{};
        String[] options = new String[]{};
        String[] linkpath = new String[]{};
        String[] link = new String[]{};
        String[] preloadpath = new String[]{};
        String[] preload = new String[]{};
        for (Platform p : platforms) {
            String[][] names = new String[][]{p.value(), p.not()};
            boolean[] matches = new boolean[]{false, false};
            block3: for (int i = 0; i < names.length; ++i) {
                for (String s : names[i]) {
                    if (!platformName.startsWith(s)) continue;
                    matches[i] = true;
                    continue block3;
                }
            }
            if (names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]) continue;
            if (p.define().length > 0) {
                define = p.define();
            }
            if (p.include().length > 0) {
                include = p.include();
            }
            if (p.cinclude().length > 0) {
                cinclude = p.cinclude();
            }
            if (p.includepath().length > 0) {
                includepath = p.includepath();
            }
            if (p.options().length > 0) {
                options = p.options();
            }
            if (p.linkpath().length > 0) {
                linkpath = p.linkpath();
            }
            if (p.link().length > 0) {
                link = p.link();
            }
            if (p.preloadpath().length > 0) {
                preloadpath = p.preloadpath();
            }
            if (p.preload().length <= 0) continue;
            preload = p.preload();
        }
        String s = properties.getProperty("path.separator");
        Loader.appendProperty(properties, "generator.define", "\u0000", define);
        Loader.appendProperty(properties, "generator.include", "\u0000", include);
        Loader.appendProperty(properties, "generator.cinclude", "\u0000", cinclude);
        Loader.appendProperty(properties, "compiler.includepath", s, includepath);
        if (options.length > 0) {
            String defaultOptions = properties.getProperty("compiler.options");
            properties.setProperty("compiler.options", "");
            for (int i = 0; i < options.length; ++i) {
                String o = defaultOptions;
                if (options[i].length() > 0) {
                    o = properties.getProperty("compiler.options." + options[i]);
                }
                Loader.appendProperty(properties, "compiler.options", " ", o);
            }
        }
        Loader.appendProperty(properties, "compiler.linkpath", s, linkpath);
        Loader.appendProperty(properties, "compiler.link", s, link);
        Loader.appendProperty(properties, "loader.preloadpath", s, linkpath);
        Loader.appendProperty(properties, "loader.preloadpath", s, preloadpath);
        Loader.appendProperty(properties, "loader.preload", s, link);
        Loader.appendProperty(properties, "loader.preload", s, preload);
    }

    public static void appendProperty(java.util.Properties properties, String name, String separator, String ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        String value = "";
        for (String v : values) {
            if (v == null || v.length() == 0) continue;
            if (value.length() > 0 && !value.endsWith(separator)) {
                value = value + separator;
            }
            value = value + v;
        }
        String value2 = properties.getProperty(name, "");
        if (value2.length() > 0) {
            value = value + separator;
        }
        properties.setProperty(name, value + value2);
    }

    public static String getLibraryName(Class cls) {
        return "jni" + cls.getSimpleName();
    }

    public static Class getCallerClass(int i) {
        Class[] classContext = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (i < classContext.length) {
            return classContext[i];
        }
        return null;
    }

    public static File extractResource(Class cls, String name, File directory) throws IOException {
        return Loader.extractResource(cls, name, directory, null, null);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        InputStream is = cls.getResourceAsStream(name);
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int n;
            if (prefix == null && suffix == null) {
                file = new File(directory, new File(name).getName());
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directory);
            }
            FileOutputStream os = new FileOutputStream(file);
            byte[] data = new byte[is.available()];
            while ((n = is.read(data)) > 0) {
                os.write(data, 0, n);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e;
        }
        return file;
    }

    public static void preload(String[] paths, String[] libnames) {
        for (int i = 0; i < libnames.length; ++i) {
            boolean loaded = false;
            for (int j = 0; j < paths.length; ++j) {
                String filename = paths[j] + File.separator + System.mapLibraryName(libnames[i]);
                if (!new File(filename).exists()) continue;
                try {
                    System.load(filename);
                    loaded = true;
                    break;
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (loaded) continue;
            try {
                System.loadLibrary(libnames[i]);
                continue;
            }
            catch (UnsatisfiedLinkError e) {
                // empty catch block
            }
        }
    }

    public static String load() {
        Class cls = Loader.getCallerClass(3);
        return Loader.load(cls);
    }

    public static String load(Class cls) {
        if (!loadLibraries) {
            return null;
        }
        String className = cls.getName();
        int topIndex = className.indexOf(36);
        if (topIndex > 0) {
            className = className.substring(0, topIndex);
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            NoClassDefFoundError e = new NoClassDefFoundError(ex.toString());
            e.initCause(ex);
            throw e;
        }
        String filename = loadedLibraries.get(cls);
        if (filename != null) {
            return filename;
        }
        java.util.Properties p = (java.util.Properties)Loader.getProperties().clone();
        Loader.appendProperties(p, cls);
        String pathSeparator = p.getProperty("path.separator");
        String platformRoot = p.getProperty("platform.root");
        if (platformRoot != null && !platformRoot.endsWith(File.separator)) {
            platformRoot = platformRoot + File.separator;
        }
        String preloadPath = p.getProperty("loader.preloadpath");
        String preloadLibraries = p.getProperty("loader.preload");
        if (preloadPath != null && preloadLibraries != null) {
            String[] preloadPaths = preloadPath.split(pathSeparator);
            if (platformRoot != null) {
                for (int i = 0; i < preloadPaths.length; ++i) {
                    if (new File(preloadPaths[i]).isAbsolute()) continue;
                    preloadPaths[i] = platformRoot + preloadPaths[i];
                }
            }
            Loader.preload(preloadPaths, preloadLibraries.split(pathSeparator));
        }
        File tempFile = null;
        try {
            String libname = Loader.getLibraryName(cls);
            String prefix = p.getProperty("library.prefix") + libname;
            String suffix = p.getProperty("library.suffix");
            String resourceName = p.getProperty("platform.name") + '/' + prefix + suffix;
            tempFile = Loader.extractResource(cls, resourceName, null, prefix, suffix);
            if (tempFile != null) {
                String tempFilename = tempFile.getAbsolutePath();
                System.load(tempFilename);
                loadedLibraries.put(cls, tempFilename);
                String string = tempFilename;
                return string;
            }
            System.loadLibrary(libname);
            loadedLibraries.put(cls, libname);
            String string = libname;
            return string;
        }
        catch (UnsatisfiedLinkError e) {
            if (tempFile != null) {
                tempFile.delete();
            }
            throw e;
        }
        catch (IOException ex) {
            if (tempFile != null) {
                tempFile.delete();
            }
            UnsatisfiedLinkError e = new UnsatisfiedLinkError(ex.toString());
            e.initCause(ex);
            throw e;
        }
        finally {
            if (tempFile != null) {
                tempFile.deleteOnExit();
            }
        }
    }

    public static void main(String[] args) {
        for (String filename : args) {
            File file = new File(filename);
            while (file.exists() && !file.delete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    static void putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        Class<?> c = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
        Loader.putMemberOffset(c.asSubclass(Pointer.class), member, offset);
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        return memberOffsets.get(type).get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return memberOffsets.get(type).get("sizeof");
    }

    static {
        if (Loader.getPlatformName().startsWith("windows")) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (loadedLibraries.isEmpty()) {
                        return;
                    }
                    try {
                        LinkedList<String> command = new LinkedList<String>();
                        command.add(System.getProperty("java.home") + "/bin/java");
                        command.add("-classpath");
                        command.add(System.getProperty("java.class.path"));
                        command.add(Loader.class.getName());
                        command.addAll(loadedLibraries.values());
                        new ProcessBuilder(command).start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        memberOffsets = new WeakHashMap();
    }
}

