/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.IntBuffer;

public class IntPointer
extends Pointer {
    public IntPointer(String s) {
        this(s.length() + 1);
        this.putString(s);
    }

    public IntPointer(int ... array) {
        this(array.length);
        this.asBuffer().put(array);
    }

    public IntPointer(IntBuffer buffer) {
        super(buffer);
        if (buffer.hasArray()) {
            int[] array = buffer.array();
            this.allocateArray(array.length);
            this.asBuffer().put(array);
            this.position(buffer.position());
        }
    }

    public IntPointer(int size) {
        this.allocateArray(size);
    }

    public IntPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public IntPointer position(int position) {
        return (IntPointer)super.position(position);
    }

    public IntPointer capacity(int capacity) {
        return (IntPointer)super.capacity(capacity);
    }

    public int[] getStringCodePoints() {
        int[] newbuffer;
        int[] buffer = new int[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != 0) {
            ++j;
            if (++i < buffer.length) continue;
            newbuffer = new int[2 * buffer.length];
            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
            buffer = newbuffer;
        }
        newbuffer = new int[i];
        System.arraycopy(buffer, 0, newbuffer, 0, i);
        return newbuffer;
    }

    public String getString() {
        int[] codePoints = this.getStringCodePoints();
        return new String(codePoints, 0, codePoints.length);
    }

    public IntPointer putString(String s) {
        int[] codePoints = new int[s.length()];
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = s.codePointAt(i);
        }
        this.asBuffer().put(codePoints).put(0);
        return this;
    }

    public int get() {
        return this.get(0);
    }

    public native int get(int var1);

    public IntPointer put(int j) {
        return this.put(0, j);
    }

    public native IntPointer put(int var1, int var2);

    public final IntBuffer asBuffer() {
        return this.asByteBuffer().asIntBuffer();
    }
}

