/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.BoolPointer;
import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.CLongPointer;
import com.googlecode.javacpp.CharPointer;
import com.googlecode.javacpp.DoublePointer;
import com.googlecode.javacpp.FloatPointer;
import com.googlecode.javacpp.FunctionPointer;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.LongPointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacpp.ShortPointer;
import com.googlecode.javacpp.SizeTPointer;
import com.googlecode.javacpp.annotation.Adapter;
import com.googlecode.javacpp.annotation.Allocator;
import com.googlecode.javacpp.annotation.ArrayAllocator;
import com.googlecode.javacpp.annotation.ByPtr;
import com.googlecode.javacpp.annotation.ByPtrPtr;
import com.googlecode.javacpp.annotation.ByPtrRef;
import com.googlecode.javacpp.annotation.ByRef;
import com.googlecode.javacpp.annotation.ByVal;
import com.googlecode.javacpp.annotation.Cast;
import com.googlecode.javacpp.annotation.Const;
import com.googlecode.javacpp.annotation.Convention;
import com.googlecode.javacpp.annotation.Function;
import com.googlecode.javacpp.annotation.Index;
import com.googlecode.javacpp.annotation.MemberGetter;
import com.googlecode.javacpp.annotation.MemberSetter;
import com.googlecode.javacpp.annotation.Name;
import com.googlecode.javacpp.annotation.Namespace;
import com.googlecode.javacpp.annotation.NoOffset;
import com.googlecode.javacpp.annotation.Opaque;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import com.googlecode.javacpp.annotation.ValueGetter;
import com.googlecode.javacpp.annotation.ValueSetter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
implements Closeable {
    public static final String JNI_VERSION = "JNI_VERSION_1_4";
    private static final Logger logger = Logger.getLogger(Generator.class.getName());
    private java.util.Properties properties;
    private File file;
    private PrintWriter writer;
    private PrintWriter out;
    private LinkedListRegister<String> functionDefinitions;
    private LinkedListRegister<String> functionPointers;
    private LinkedListRegister<Class> deallocators;
    private LinkedListRegister<Class> arrayDeallocators;
    private LinkedListRegister<Class> jclasses;
    private HashMap<Class, LinkedList<String>> members;

    public Generator(java.util.Properties properties, String filename) {
        this(properties, new File(filename));
    }

    public Generator(java.util.Properties properties, File file) {
        this.properties = properties;
        this.file = file;
        this.writer = null;
    }

    public Generator(java.util.Properties properties, PrintWriter writer) {
        this.properties = properties;
        this.file = null;
        this.writer = writer;
    }

    public boolean generate(Class<?> ... classes) throws FileNotFoundException {
        this.out = new PrintWriter(new Writer(){

            public void close() {
            }

            public void flush() {
            }

            public void write(char[] cbuf, int off, int len) {
            }
        });
        this.functionDefinitions = new LinkedListRegister();
        this.functionPointers = new LinkedListRegister();
        this.deallocators = new LinkedListRegister();
        this.arrayDeallocators = new LinkedListRegister();
        this.jclasses = new LinkedListRegister();
        this.members = new HashMap();
        if (this.doClasses(classes)) {
            this.out = this.writer != null ? this.writer : new PrintWriter(this.file);
            this.doClasses(classes);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }

    private boolean doClasses(Class<?> ... classes) {
        this.out.println("/* DO NOT EDIT THIS FILE - IT IS MACHINE GENERATED */");
        this.out.println();
        String define = this.properties.getProperty("generator.define");
        if (define != null && define.length() > 0) {
            for (String s : define.split("\u0000")) {
                this.out.println("#define " + s);
            }
            this.out.println();
        }
        String[] include = new String[]{this.properties.getProperty("generator.include"), this.properties.getProperty("generator.cinclude")};
        for (int i = 0; i < include.length; ++i) {
            if (include[i] == null || include[i].length() <= 0) continue;
            if (i == 1) {
                this.out.println("extern \"C\" {");
            }
            for (String s : include[i].split("\u0000")) {
                char[] chars = s.toCharArray();
                this.out.print("#include ");
                char c = chars[0];
                if (c != '<' && c != '\"') {
                    this.out.print('\"');
                }
                this.out.print(chars);
                c = chars[chars.length - 1];
                if (c != '>' && c != '\"') {
                    this.out.print('\"');
                }
                this.out.println();
            }
            if (i == 1) {
                this.out.println("}");
            }
            this.out.println();
        }
        this.out.println("#ifdef _WIN32");
        this.out.println("    #define _JAVASOFT_JNI_MD_H_");
        this.out.println();
        this.out.println("    #define JNIEXPORT __declspec(dllexport)");
        this.out.println("    #define JNIIMPORT __declspec(dllimport)");
        this.out.println("    #define JNICALL __stdcall");
        this.out.println();
        this.out.println("    typedef int jint;");
        this.out.println("    typedef __int64 jlong;");
        this.out.println("    typedef signed char jbyte;");
        this.out.println("#endif");
        this.out.println("#include <jni.h>");
        this.out.println("#include <stddef.h>");
        this.out.println("#ifndef _WIN32");
        this.out.println("    #include <stdint.h>");
        this.out.println("#endif");
        this.out.println("#include <stdio.h>");
        this.out.println("#include <stdlib.h>");
        this.out.println("#include <string.h>");
        this.out.println("#include <exception>");
        this.out.println("#include <vector>");
        this.out.println();
        this.out.println("#define jlong_to_ptr(a) ((void*)(uintptr_t)(a))");
        this.out.println("#define ptr_to_jlong(a) ((jlong)(uintptr_t)(a))");
        this.out.println("#ifdef ANDROID");
        this.out.println("    #define NewWeakGlobalRef(o) NewGlobalRef(o)");
        this.out.println("    #define DeleteWeakGlobalRef(o) DeleteGlobalRef(o)");
        this.out.println("#endif");
        this.out.println();
        this.out.println("#if defined(_MSC_VER)");
        this.out.println("    #define noinline __declspec(noinline)");
        this.out.println("#elif defined(__GNUC__)");
        this.out.println("    #define noinline __attribute__((noinline))");
        this.out.println("#else");
        this.out.println("    #define noinline");
        this.out.println("#endif");
        this.out.println();
        for (String s : this.functionDefinitions) {
            this.out.println(s);
        }
        this.out.println();
        for (String s : this.functionPointers) {
            this.out.println("static jobject " + s + " = NULL;");
        }
        this.out.println();
        for (Class c : this.deallocators) {
            String name = "JavaCPP_" + Generator.mangle(c.getName());
            String type = FunctionPointer.class.isAssignableFrom(c) ? name + "*" : Generator.getCPPTypeName(c)[0];
            this.out.println("static void " + name + "_deallocate(" + type + " address) { delete address; }");
        }
        for (Class c : this.arrayDeallocators) {
            String name = "JavaCPP_" + Generator.mangle(c.getName());
            String type = FunctionPointer.class.isAssignableFrom(c) ? name + "*" : Generator.getCPPTypeName(c)[0];
            this.out.println("static void " + name + "_deallocateArray(" + type + " address) { delete[] address; }");
        }
        this.out.println();
        this.out.println("static JavaVM* JavaCPP_vm = NULL;");
        this.out.println("static const char* JavaCPP_classNames[" + this.jclasses.size() + "] = {");
        Iterator classIterator = this.jclasses.iterator();
        int maxMemberSize = 0;
        while (classIterator.hasNext()) {
            LinkedList<String> m;
            Class c = (Class)classIterator.next();
            this.out.print("        \"" + c.getName().replace('.', '/') + "\"");
            if (classIterator.hasNext()) {
                this.out.println(",");
            }
            if ((m = this.members.get(c)) == null || m.size() <= maxMemberSize) continue;
            maxMemberSize = m.size();
        }
        this.out.println(" };");
        this.out.println("static jclass JavaCPP_classes[" + this.jclasses.size() + "] = { NULL };");
        this.out.println("static jmethodID JavaCPP_initMethodID = NULL;");
        this.out.println("static jfieldID JavaCPP_addressFieldID = NULL;");
        this.out.println("static jfieldID JavaCPP_positionFieldID = NULL;");
        this.out.println("static jfieldID JavaCPP_capacityFieldID = NULL;");
        this.out.println();
        this.out.println("static noinline jclass JavaCPP_getClass(JNIEnv* e, int i) {");
        this.out.println("    if (JavaCPP_classes[i] == NULL) {");
        this.out.println("        jclass c = e->FindClass(JavaCPP_classNames[i]);");
        this.out.println("        if (c == NULL || e->ExceptionCheck()) {");
        this.out.println("            fprintf(stderr, \"Error loading class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("        JavaCPP_classes[i] = (jclass)e->NewWeakGlobalRef(c);");
        this.out.println("        if (JavaCPP_classes[i] == NULL || e->ExceptionCheck()) {");
        this.out.println("            fprintf(stderr, \"Error creating global reference of class %s.\", JavaCPP_classNames[i]);");
        this.out.println("            return NULL;");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    return JavaCPP_classes[i];");
        this.out.println("}");
        this.out.println();
        this.out.println("static noinline void JavaCPP_handleException(JNIEnv* e) {");
        this.out.println("    try {");
        this.out.println("        throw;");
        this.out.println("    } catch (std::exception& ex) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(RuntimeException.class) + "), ex.what());");
        this.out.println("    } catch (...) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(RuntimeException.class) + "), \"Unknown exception.\");");
        this.out.println("    }");
        this.out.println("}");
        this.out.println();
        this.out.println("template <class P> static inline P JavaCPP_dereference(JNIEnv* e, P* pointer) {");
        this.out.println("    if (pointer == NULL) {");
        this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"Return pointer address is NULL.\");");
        this.out.println("        return P();");
        this.out.println("    }");
        this.out.println("    return *pointer;");
        this.out.println("}");
        this.out.println();
        this.out.println("template<class P, class T = P> class VectorAdapter {");
        this.out.println("public:");
        this.out.println("    VectorAdapter(P* pointer, int capacity) : pointer(pointer), capacity(capacity),");
        this.out.println("        vec2(pointer ? std::vector<T>(pointer, pointer + capacity) : std::vector<T>()), vec(vec2) { }");
        this.out.println("    VectorAdapter(const std::vector<T>& vec) : pointer(0), capacity(0), vec((std::vector<T>&)vec) { }");
        this.out.println("    void assign(P* pointer, int capacity) {");
        this.out.println("        this.pointer = pointer;");
        this.out.println("        this.capacity = capacity;");
        this.out.println("        vec.assign(pointer, pointer + capacity);");
        this.out.println("    }");
        this.out.println("    static void deallocate(P* pointer) { delete[] pointer; }");
        this.out.println("    operator P*() {");
        this.out.println("        if (vec.size() > capacity) {");
        this.out.println("            pointer = new P[vec.size()];");
        this.out.println("            capacity = vec.size();");
        this.out.println("        }");
        this.out.println("        if (pointer) {");
        this.out.println("            std::copy(vec.begin(), vec.end(), pointer);");
        this.out.println("        }");
        this.out.println("        return pointer;");
        this.out.println("    }");
        this.out.println("    operator const P*()        { return &vec[0]; }");
        this.out.println("    operator std::vector<T>&() { return vec; }");
        this.out.println("    operator std::vector<T>*() { return pointer ? &vec : 0; }");
        this.out.println("    P* pointer;");
        this.out.println("    unsigned int capacity;");
        this.out.println("    std::vector<T> vec2;");
        this.out.println("    std::vector<T>& vec;");
        this.out.println("};");
        this.out.println();
        this.out.println("extern \"C\" {");
        this.out.println();
        this.out.println("JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void* reserved) {");
        this.out.println("    JavaCPP_vm = vm;");
        this.out.println("    JNIEnv* e;");
        this.out.println("    if (vm->GetEnv((void**)&e, JNI_VERSION_1_4) != JNI_OK) {");
        this.out.println("        fprintf(stderr, \"Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnLoad().\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    const char* members[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            LinkedList<String> m = this.members.get(classIterator.next());
            Iterator iterator = memberIterator = m == null ? null : m.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                this.out.print("\"" + (String)memberIterator.next() + "\"");
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.println("    int offsets[" + this.jclasses.size() + "][" + maxMemberSize + "] = {");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            Iterator memberIterator;
            this.out.print("            { ");
            Class c = (Class)classIterator.next();
            LinkedList<String> m = this.members.get(c);
            Iterator iterator = memberIterator = m == null ? null : m.iterator();
            while (memberIterator != null && memberIterator.hasNext()) {
                String[] typeName = Generator.getCPPTypeName(c);
                String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                String memberName = (String)memberIterator.next();
                if ("sizeof".equals(memberName)) {
                    if ("void".equals(valueTypeName)) {
                        valueTypeName = "void*";
                    }
                    this.out.print("sizeof(" + valueTypeName + ")");
                } else {
                    this.out.print("offsetof(" + valueTypeName + "," + memberName + ")");
                }
                if (!memberIterator.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.print(" }");
            if (!classIterator.hasNext()) continue;
            this.out.println(",");
        }
        this.out.println(" };");
        this.out.print("    int memberOffsetSizes[" + this.jclasses.size() + "] = { ");
        classIterator = this.jclasses.iterator();
        while (classIterator.hasNext()) {
            LinkedList<String> m = this.members.get(classIterator.next());
            this.out.print(m == null ? 0 : m.size());
            if (!classIterator.hasNext()) continue;
            this.out.print(", ");
        }
        this.out.println(" };");
        this.out.println("    jmethodID putMemberOffsetMethodID = e->GetStaticMethodID(JavaCPP_getClass(e, " + this.jclasses.register(Loader.class) + "), \"putMemberOffset\", \"(Ljava/lang/String;Ljava/lang/String;I)V\");");
        this.out.println("    if (putMemberOffsetMethodID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting putMemberOffset method ID of Loader class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + " && !e->ExceptionCheck(); i++) {");
        this.out.println("        for (int j = 0; j < memberOffsetSizes[i] && !e->ExceptionCheck(); j++) {");
        this.out.println("            if (e->PushLocalFrame(2) == 0) {");
        this.out.println("                jvalue args[3];");
        this.out.println("                args[0].l = e->NewStringUTF(JavaCPP_classNames[i]);");
        this.out.println("                args[1].l = e->NewStringUTF(members[i][j]);");
        this.out.println("                args[2].i = offsets[i][j];");
        this.out.println("                e->CallStaticVoidMethodA(JavaCPP_getClass(e, " + this.jclasses.register(Loader.class) + "), putMemberOffsetMethodID, args);");
        this.out.println("                e->PopLocalFrame(NULL);");
        this.out.println("            }");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    JavaCPP_initMethodID = e->GetMethodID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"init\", \"(JIJ)V\");");
        this.out.println("    if (JavaCPP_initMethodID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting init method ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_addressFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"address\", \"J\");");
        this.out.println("    if (JavaCPP_addressFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting address field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_positionFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"position\", \"I\");");
        this.out.println("    if (JavaCPP_positionFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting position field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    JavaCPP_capacityFieldID = e->GetFieldID(JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), \"capacity\", \"I\");");
        this.out.println("    if (JavaCPP_capacityFieldID == NULL || e->ExceptionCheck()) {");
        this.out.println("        fprintf(stderr, \"Error getting capacity field ID of Pointer class.\");");
        this.out.println("        return 0;");
        this.out.println("    }");
        this.out.println("    return e->GetVersion();");
        this.out.println("}");
        this.out.println();
        this.out.println("JNIEXPORT void JNICALL JNI_OnUnload(JavaVM* vm, void* reserved) {");
        this.out.println("    JNIEnv* e;");
        this.out.println("    if (vm->GetEnv((void**)&e, JNI_VERSION_1_4) != JNI_OK) {");
        this.out.println("        fprintf(stderr, \"Could not get JNIEnv for JNI_VERSION_1_4 inside JNI_OnUnLoad().\");");
        this.out.println("        return;");
        this.out.println("    }");
        for (String s : this.functionPointers) {
            this.out.println("    e->DeleteGlobalRef(" + s + ");");
        }
        this.out.println("    for (int i = 0; i < " + this.jclasses.size() + "; i++) {");
        this.out.println("        e->DeleteWeakGlobalRef(JavaCPP_classes[i]);");
        this.out.println("    }");
        this.out.println("}");
        this.out.println();
        this.doMethods(Pointer.class);
        this.doMethods(BytePointer.class);
        this.doMethods(ShortPointer.class);
        this.doMethods(IntPointer.class);
        this.doMethods(LongPointer.class);
        this.doMethods(FloatPointer.class);
        this.doMethods(DoublePointer.class);
        this.doMethods(CharPointer.class);
        this.doMethods(PointerPointer.class);
        this.doMethods(BoolPointer.class);
        this.doMethods(CLongPointer.class);
        this.doMethods(SizeTPointer.class);
        boolean didSomethingUseful = false;
        for (Class<?> cls : classes) {
            didSomethingUseful |= this.doMethods(cls);
        }
        this.out.println("}");
        this.out.println();
        return didSomethingUseful;
    }

    private boolean doMethods(Class<?> cls) {
        Properties classProperties = cls.getAnnotation(Properties.class);
        boolean platformMatches = false;
        if (classProperties != null) {
            for (Platform p : classProperties.value()) {
                if (!this.checkPlatform(p)) continue;
                platformMatches = true;
            }
        } else if (this.checkPlatform(cls.getAnnotation(Platform.class))) {
            platformMatches = true;
        }
        if (!platformMatches) {
            return false;
        }
        LinkedList<String> memberList = this.members.get(cls);
        if (!(cls.isAnnotationPresent(Opaque.class) && cls != Pointer.class || FunctionPointer.class.isAssignableFrom(cls) || cls.isAnnotationPresent(NoOffset.class))) {
            if (memberList == null) {
                memberList = new LinkedList();
                this.members.put(cls, memberList);
            }
            if (!memberList.contains("sizeof")) {
                memberList.add("sizeof");
            }
        }
        Class<?>[] classes = cls.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!Pointer.class.isAssignableFrom(classes[i]) && !Pointer.Deallocator.class.isAssignableFrom(classes[i])) continue;
            this.doMethods(classes[i]);
        }
        String[] typeName = Generator.getCPPTypeName(cls);
        Method[] methods = cls.getDeclaredMethods();
        boolean[] callbackAllocators = new boolean[methods.length];
        Method functionMethod = Generator.getFunctionMethod(cls, callbackAllocators);
        if (functionMethod != null) {
            this.functionDefinitions.register("struct JavaCPP_" + Generator.mangle(cls.getName()) + " { " + typeName[0] + "pointer" + typeName[1] + "; };");
        }
        for (int i = 0; i < methods.length; ++i) {
            MethodInformation methodInfo;
            if (!this.checkPlatform(methods[i].getAnnotation(Platform.class)) || (methodInfo = Generator.getMethodInformation(methods[i])) == null) continue;
            String baseFunctionName = Generator.mangle(cls.getName()) + "_" + Generator.mangle(methodInfo.name);
            if (!(!methodInfo.memberGetter && !methodInfo.memberSetter || methodInfo.noOffset || memberList == null || Modifier.isStatic(methodInfo.modifiers) || memberList.contains(methodInfo.memberName[0]))) {
                memberList.add(methodInfo.memberName[0]);
            }
            if (callbackAllocators[i]) {
                this.doCallback(cls, functionMethod, baseFunctionName);
            }
            this.out.print("JNIEXPORT " + Generator.getJNITypeName(methodInfo.returnType) + " JNICALL Java_" + baseFunctionName);
            if (methodInfo.overloaded) {
                this.out.print("__" + Generator.mangle(Generator.getSignature(methodInfo.parameterTypes)));
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                this.out.print("(JNIEnv* e, jclass c");
            } else {
                this.out.print("(JNIEnv* e, jobject o");
            }
            for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
                this.out.print(", " + Generator.getJNITypeName(methodInfo.parameterTypes[j]) + " p" + j);
            }
            this.out.println(") {");
            if (callbackAllocators[i]) {
                this.doCallbackAllocator(cls, functionMethod, baseFunctionName);
                continue;
            }
            if (!(Modifier.isStatic(methodInfo.modifiers) || methodInfo.allocator || methodInfo.arrayAllocator || methodInfo.deallocator)) {
                String[] thisType = (String[])typeName.clone();
                if (methodInfo.bufferGetter && "void*".equals(thisType[0])) {
                    thisType[0] = "char*";
                } else if (FunctionPointer.class.isAssignableFrom(cls)) {
                    thisType[0] = "JavaCPP_" + Generator.mangle(cls.getName()) + "*";
                    thisType[1] = "";
                }
                this.out.println("    " + thisType[0] + " pointer" + thisType[1] + " = (" + thisType[0] + thisType[1] + ")jlong_to_ptr(e->GetLongField(o, JavaCPP_addressFieldID));");
                this.out.println("    if (pointer == NULL) {");
                this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"This pointer address is NULL.\");");
                this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                this.out.println("    }");
                if (FunctionPointer.class.isAssignableFrom(cls)) {
                    this.out.println("    if (!pointer->pointer) {");
                    this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"This function pointer address is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (!cls.isAnnotationPresent(Opaque.class) || methodInfo.bufferGetter) {
                    this.out.println("    jint position = e->GetIntField(o, JavaCPP_positionFieldID);");
                    this.out.println("    pointer += position;");
                    if (methodInfo.bufferGetter) {
                        this.out.println("    jint capacity = e->GetIntField(o, JavaCPP_capacityFieldID);");
                    }
                }
            }
            this.doParametersBefore(methodInfo);
            String returnVariable = this.doReturnBefore(methodInfo);
            this.doCall(methodInfo, returnVariable);
            this.doReturnAfter(methodInfo);
            this.doParametersAfter(methodInfo);
            if (methodInfo.returnType != Void.TYPE) {
                this.out.println("    return r;");
            }
            this.out.println("}");
        }
        this.out.println();
        return true;
    }

    private void doParametersBefore(MethodInformation methodInfo) {
        String adapterLine = "";
        Adapter prevAdapter = null;
        int prevAdapterArgc = 0;
        for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
            if (methodInfo.parameterTypes[j].isPrimitive()) continue;
            Annotation passBy = Generator.getParameterBy(methodInfo, j);
            String cast = Generator.getParameterCast(methodInfo, j);
            String[] typeName = Generator.getCPPTypeName(methodInfo.parameterTypes[j]);
            Adapter adapter = Generator.getParameterAdapter(methodInfo, j);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                typeName[0] = "JavaCPP_" + Generator.mangle(methodInfo.parameterTypes[j].getName()) + "*";
                typeName[1] = "";
            }
            this.out.print("    " + typeName[0] + " pointer" + j + typeName[1] + " = ");
            if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("p" + j + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")jlong_to_ptr(e->GetLongField(p" + j + ", JavaCPP_addressFieldID));");
                if (j == 0 && FunctionPointer.class.isAssignableFrom(methodInfo.cls) && methodInfo.cls.isAnnotationPresent(Namespace.class) || passBy instanceof ByVal || passBy instanceof ByRef) {
                    this.out.println("    if (pointer" + j + " == NULL) {");
                    this.out.println("        e->ThrowNew(JavaCPP_getClass(e, " + this.jclasses.register(NullPointerException.class) + "), \"Pointer address of parameter " + j + " is NULL.\");");
                    this.out.println("        return" + (methodInfo.returnType == Void.TYPE ? ";" : " 0;"));
                    this.out.println("    }");
                }
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j + " = p" + j + " == NULL ? 0 : e->GetIntField(p" + j + ", JavaCPP_capacityFieldID);");
                }
                if (!(methodInfo.parameterTypes[j].isAnnotationPresent(Opaque.class) || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef)) {
                    this.out.println("    jint position" + j + " = p" + j + " == NULL ? 0 : e->GetIntField(p" + j + ", JavaCPP_positionFieldID);");
                    this.out.println("    pointer" + j + " += position" + j + ";");
                    if (adapter != null || prevAdapter != null) {
                        this.out.println("    capacity" + j + " -= position" + j + ";");
                    }
                }
            } else if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println("p" + j + " == NULL ? NULL : e->GetStringUTFChars(p" + j + ", NULL);");
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j + " = 0;");
                }
            } else if (methodInfo.parameterTypes[j].isArray()) {
                String s = methodInfo.parameterTypes[j].getComponentType().getName();
                s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
                this.out.println("p" + j + " == NULL ? NULL : e->Get" + s + "ArrayElements(p" + j + ", NULL);");
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j + " = p" + j + " == NULL ? 0 : e->GetArrayLength(p" + j + ");");
                }
            } else if (Buffer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.println("p" + j + " == NULL ? NULL : (" + typeName[0] + typeName[1] + ")e->GetDirectBufferAddress(p" + j + ");");
                if (adapter != null || prevAdapter != null) {
                    this.out.println("    jint capacity" + j + " = p" + j + " == NULL ? 0 : e->GetDirectBufferCapacity(p" + j + ");");
                }
            } else {
                this.out.println("p" + j + ";");
                logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has unsupported parameter type \"" + methodInfo.parameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
            }
            if (adapter != null) {
                adapterLine = "    " + adapter.value() + " adapter" + j + "(";
                prevAdapter = adapter;
                prevAdapterArgc = adapter.argc();
            }
            if (prevAdapter != null) {
                if (!FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                    adapterLine = adapterLine + cast;
                }
                adapterLine = adapterLine + "pointer" + j + ", capacity" + j;
                if (--prevAdapterArgc > 0) {
                    adapterLine = adapterLine + ", ";
                }
            }
            if (prevAdapter == null || prevAdapterArgc > 0) continue;
            this.out.println(adapterLine + ");");
            prevAdapter = null;
            prevAdapterArgc = 0;
        }
    }

    private String doReturnBefore(MethodInformation methodInfo) {
        String returnVariable = "";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println("    if (!e->IsSameObject(e->GetObjectClass(o), JavaCPP_getClass(e, " + this.jclasses.register(methodInfo.cls) + "))) {");
                this.out.println("        return;");
                this.out.println("    }");
                String[] typeName = Generator.getCPPTypeName(methodInfo.cls);
                returnVariable = typeName[0] + " rpointer" + typeName[1] + " = ";
            }
        } else {
            String[] typeName = Generator.getCastedCPPTypeName(methodInfo.annotations, methodInfo.returnType);
            if (methodInfo.valueSetter || methodInfo.memberSetter) {
                this.out.println("    jobject r = o;");
            } else if (methodInfo.returnType.isPrimitive()) {
                this.out.println("    " + Generator.getJNITypeName(methodInfo.returnType) + " r = 0;");
                returnVariable = typeName[0] + " rvalue" + typeName[1] + " = ";
            } else {
                Annotation returnBy = Generator.getBy(methodInfo.annotations);
                Adapter adapter = Generator.getAdapter(methodInfo.annotations);
                returnVariable = "rpointer = ";
                if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        typeName[0] = "JavaCPP_" + Generator.mangle(methodInfo.returnType.getName()) + "*";
                        typeName[1] = "";
                        returnVariable = "rpointer->pointer = ";
                    }
                    String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                    if (returnBy instanceof ByVal) {
                        returnVariable = returnVariable + "new " + valueTypeName + typeName[1] + "(";
                    } else if (returnBy instanceof ByRef) {
                        returnVariable = returnVariable + "&";
                    } else if (returnBy instanceof ByPtrPtr) {
                        returnVariable = returnVariable + "JavaCPP_dereference(e, ";
                    }
                    this.out.println("    jobject r = NULL;");
                    this.out.println("    " + typeName[0] + " rpointer" + typeName[1] + ";");
                    if (FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                        this.out.println("    rpointer = new " + valueTypeName + ";");
                    }
                } else if (methodInfo.returnType == String.class) {
                    this.out.println("    jstring r = NULL;");
                    this.out.println("    const char* rpointer;");
                } else if (methodInfo.bufferGetter) {
                    this.out.println("    jobject r = NULL;");
                    this.out.println("    char* rpointer;");
                } else {
                    logger.log(Level.WARNING, "Method \"" + methodInfo.method + "\" has unsupported return type \"" + methodInfo.returnType.getCanonicalName() + "\". Compilation will most likely fail.");
                }
                if (adapter != null) {
                    returnVariable = adapter.value() + " radapter(";
                }
            }
        }
        if (methodInfo.mayThrowException) {
            this.out.println("    try {");
        }
        return returnVariable;
    }

    private void doCall(MethodInformation methodInfo, String returnVariable) {
        int j;
        String indent = methodInfo.mayThrowException ? "        " : "    ";
        String prefix = "(";
        String suffix = ")";
        int skipParameters = 0;
        if (methodInfo.deallocator) {
            this.out.println(indent + "void* allocatedAddress = jlong_to_ptr(p0);");
            this.out.println(indent + "void (*deallocatorAddress)(void*) = (void(*)(void*))jlong_to_ptr(p1);");
            this.out.println(indent + "if (deallocatorAddress != NULL && allocatedAddress != NULL) {");
            this.out.println(indent + "    (*deallocatorAddress)(allocatedAddress);");
            this.out.println(indent + "}");
            return;
        }
        if (methodInfo.valueGetter || methodInfo.valueSetter || methodInfo.memberGetter || methodInfo.memberSetter) {
            this.out.print(indent + returnVariable);
            int k = methodInfo.parameterTypes.length - 1;
            if ((methodInfo.valueSetter || methodInfo.memberSetter) && !(Generator.getParameterBy(methodInfo, k) instanceof ByRef) && methodInfo.parameterTypes[k] == String.class) {
                this.out.print("strcpy(");
                prefix = ", ";
            } else {
                prefix = methodInfo.valueGetter || methodInfo.memberGetter ? "" : " = ";
                suffix = "";
            }
            if (Modifier.isStatic(methodInfo.modifiers)) {
                String[] namespace = Generator.getCPPTypeName(methodInfo.cls);
                if (namespace[0] != null && namespace[0].length() > 0) {
                    this.out.print(namespace[0].substring(0, namespace[0].length() - 1));
                    this.out.print("::");
                }
                if (methodInfo.method.isAnnotationPresent(Namespace.class)) {
                    Namespace ns = methodInfo.method.getAnnotation(Namespace.class);
                    this.out.print(ns.value());
                    this.out.print("::");
                }
                this.out.print(methodInfo.memberName[0]);
            } else if (methodInfo.memberGetter || methodInfo.memberSetter) {
                this.out.print("pointer->" + methodInfo.memberName[0]);
            } else {
                Index index = methodInfo.cls.getAnnotation(Index.class);
                this.out.print(index != null ? "(*pointer)" : (methodInfo.dim > 0 ? "pointer" : "*pointer"));
            }
        } else if (methodInfo.bufferGetter) {
            this.out.print(indent + returnVariable + "pointer");
            prefix = "";
            suffix = "";
        } else {
            this.out.print(indent + returnVariable);
            if (FunctionPointer.class.isAssignableFrom(methodInfo.cls)) {
                if (methodInfo.cls.isAnnotationPresent(Namespace.class)) {
                    this.out.print("(pointer0->*(pointer->pointer))");
                    skipParameters = 1;
                } else {
                    this.out.print("(*pointer->pointer)");
                }
            } else if (methodInfo.allocator) {
                String[] typeName = Generator.getCPPTypeName(methodInfo.cls);
                String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                this.out.print("new " + valueTypeName);
                if (methodInfo.arrayAllocator) {
                    prefix = "[";
                    suffix = "]";
                }
            } else if (Modifier.isStatic(methodInfo.modifiers)) {
                String[] namespace = Generator.getCPPTypeName(methodInfo.cls);
                if (namespace[0] != null && namespace[0].length() > 0) {
                    this.out.print(namespace[0].substring(0, namespace[0].length() - 1));
                    this.out.print("::");
                }
                if (methodInfo.method.isAnnotationPresent(Namespace.class)) {
                    Namespace ns = methodInfo.method.getAnnotation(Namespace.class);
                    this.out.print(ns.value());
                    this.out.print("::");
                }
                this.out.print(methodInfo.memberName[0]);
            } else {
                Index index = methodInfo.cls.getAnnotation(Index.class);
                if (index != null) {
                    this.out.print("(*pointer)");
                    prefix = "." + methodInfo.memberName[0] + prefix;
                } else {
                    this.out.print("pointer->" + methodInfo.memberName[0]);
                }
            }
        }
        for (j = skipParameters; j < methodInfo.dim; ++j) {
            String cast = Generator.getParameterCast(methodInfo, j);
            this.out.print("[" + cast + (methodInfo.parameterTypes[j].isPrimitive() ? "p" : "pointer") + j + "]");
        }
        if (methodInfo.memberName.length > 1) {
            this.out.print(methodInfo.memberName[1]);
        }
        this.out.print(prefix);
        for (j = skipParameters + methodInfo.dim; j < methodInfo.parameterTypes.length; ++j) {
            Annotation passBy = Generator.getParameterBy(methodInfo, j);
            String cast = Generator.getParameterCast(methodInfo, j);
            Adapter adapter = Generator.getParameterAdapter(methodInfo, j);
            if (("(void*)".equals(cast) || "(void *)".equals(cast)) && methodInfo.parameterTypes[j] == Long.TYPE) {
                this.out.print("jlong_to_ptr(p" + j + ")");
            } else if (methodInfo.parameterTypes[j].isPrimitive()) {
                this.out.print(cast + "p" + j);
            } else if (adapter != null) {
                this.out.print("adapter" + j);
                j += adapter.argc() - 1;
            } else if (FunctionPointer.class.isAssignableFrom(methodInfo.parameterTypes[j])) {
                this.out.print(cast + "(pointer" + j + " == NULL ? NULL : pointer" + j + "->pointer)");
            } else if (passBy instanceof ByVal || passBy instanceof ByRef) {
                this.out.print("*" + cast + "pointer" + j);
            } else if (passBy instanceof ByPtrPtr) {
                this.out.print(cast + "&pointer" + j);
            } else {
                this.out.print(cast + "pointer" + j);
            }
            if (j >= methodInfo.parameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.print(suffix);
        if (methodInfo.memberName.length > 2) {
            this.out.print(methodInfo.memberName[2]);
        }
        if (Generator.getBy(methodInfo.annotations) instanceof ByRef && methodInfo.returnType == String.class) {
            this.out.print(".c_str()");
        }
    }

    private void doReturnAfter(MethodInformation methodInfo) {
        String indent;
        Annotation returnBy = Generator.getBy(methodInfo.annotations);
        Adapter adapter = Generator.getAdapter(methodInfo.annotations);
        if (adapter != null) {
            this.out.print(")");
        }
        if (returnBy instanceof ByVal || returnBy instanceof ByPtrPtr) {
            this.out.print(")");
        }
        if (!methodInfo.deallocator) {
            this.out.println(";");
        }
        String string = indent = methodInfo.mayThrowException ? "        " : "    ";
        if (methodInfo.returnType == Void.TYPE) {
            if (methodInfo.allocator || methodInfo.arrayAllocator) {
                this.out.println(indent + "jvalue args[3];");
                this.out.println(indent + "args[0].j = ptr_to_jlong(rpointer);");
                this.out.println(indent + "args[1].i = " + (methodInfo.arrayAllocator ? "p0;" : "1;"));
                this.out.print(indent + "args[2].j = ptr_to_jlong(&JavaCPP_" + Generator.mangle(methodInfo.cls.getName()));
                if (methodInfo.arrayAllocator) {
                    this.out.println("_deallocateArray);");
                    this.arrayDeallocators.register(methodInfo.cls);
                } else {
                    this.out.println("_deallocate);");
                    this.deallocators.register(methodInfo.cls);
                }
                this.out.println(indent + "e->CallNonvirtualVoidMethodA(o, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
            }
        } else if (!methodInfo.valueSetter && !methodInfo.memberSetter) {
            if (methodInfo.returnType.isPrimitive()) {
                this.out.println(indent + "r = (" + Generator.getJNITypeName(methodInfo.returnType) + ")rvalue;");
            } else {
                boolean needInit = false;
                if (adapter != null) {
                    this.out.println(indent + "rpointer = radapter;");
                    this.out.println(indent + "int rcapacity = radapter.capacity;");
                    this.out.println(indent + "jlong deallocator = ptr_to_jlong(&(" + adapter.value() + "::deallocate));");
                    needInit = true;
                } else if (returnBy instanceof ByVal || FunctionPointer.class.isAssignableFrom(methodInfo.returnType)) {
                    this.out.println(indent + "int rcapacity = 1;");
                    this.out.println(indent + "jlong deallocator = ptr_to_jlong(&JavaCPP_" + Generator.mangle(methodInfo.returnType.getName()) + "_deallocate);");
                    this.deallocators.register(methodInfo.returnType);
                    needInit = true;
                }
                if (Pointer.class.isAssignableFrom(methodInfo.returnType)) {
                    if (!Modifier.isStatic(methodInfo.modifiers) && methodInfo.cls == methodInfo.returnType && !(returnBy instanceof ByVal)) {
                        this.out.println(indent + "if (rpointer == pointer) {");
                        this.out.println(indent + "    r = o;");
                        this.out.println(indent + "} else if (rpointer != NULL) {");
                    } else {
                        this.out.println(indent + "if (rpointer != NULL) {");
                    }
                    this.out.println(indent + "    r = e->AllocObject(JavaCPP_getClass(e, " + this.jclasses.register(methodInfo.returnType) + "));");
                    if (needInit) {
                        this.out.println(indent + "    if (deallocator != 0) {");
                        this.out.println(indent + "        jvalue args[3];");
                        this.out.println(indent + "        args[0].j = ptr_to_jlong(rpointer);");
                        this.out.println(indent + "        args[1].i = rcapacity;");
                        this.out.println(indent + "        args[2].j = deallocator;");
                        this.out.println(indent + "        e->CallNonvirtualVoidMethodA(r, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                        this.out.println(indent + "    } else {");
                        this.out.println(indent + "        e->SetLongField(r, JavaCPP_addressFieldID, ptr_to_jlong(rpointer));");
                        this.out.println(indent + "        e->SetIntField(r, JavaCPP_capacityFieldID, rcapacity);");
                        this.out.println(indent + "    }");
                    } else {
                        this.out.println(indent + "    e->SetLongField(r, JavaCPP_addressFieldID, ptr_to_jlong(rpointer));");
                    }
                    this.out.println(indent + "}");
                } else if (methodInfo.returnType == String.class) {
                    this.out.println(indent + "if (rpointer != NULL) {");
                    this.out.println(indent + "    r = e->NewStringUTF(rpointer);");
                    this.out.println(indent + "}");
                } else if (methodInfo.bufferGetter) {
                    this.out.println(indent + "if (rpointer != NULL) {");
                    this.out.println(indent + "    r = e->NewDirectByteBuffer(rpointer, capacity);");
                    this.out.println(indent + "}");
                }
            }
        }
    }

    private void doParametersAfter(MethodInformation methodInfo) {
        String indent = methodInfo.mayThrowException ? "        " : "    ";
        for (int j = 0; j < methodInfo.parameterTypes.length; ++j) {
            Annotation passBy = Generator.getParameterBy(methodInfo, j);
            String cast = Generator.getParameterCast(methodInfo, j);
            String[] typeName = Generator.getCPPTypeName(methodInfo.parameterTypes[j]);
            Adapter adapter = Generator.getParameterAdapter(methodInfo, j);
            if (adapter != null && adapter.out()) {
                for (int k = 0; k < adapter.argc(); ++k) {
                    this.out.println(indent + typeName[0] + " rpointer" + (j + k) + typeName[1] + " = adapter" + j + ";");
                    this.out.println(indent + "if (rpointer" + (j + k) + " != pointer" + (j + k) + ") {");
                    this.out.println(indent + "    jvalue args[3];");
                    this.out.println(indent + "    args[0].j = ptr_to_jlong(rpointer" + (j + k) + ");");
                    this.out.println(indent + "    args[1].i = adapter" + j + ".capacity" + (k > 0 ? k + ";" : ";"));
                    this.out.println(indent + "    args[2].j = ptr_to_jlong(&(" + adapter.value() + "::deallocate));");
                    this.out.println(indent + "    e->CallNonvirtualVoidMethodA(p" + j + ", JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                    this.out.println(indent + "}");
                }
            } else if (Pointer.class.isAssignableFrom(methodInfo.parameterTypes[j]) && (passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) && !methodInfo.valueSetter && !methodInfo.memberSetter) {
                this.out.println(indent + "if (p" + j + " != NULL) e->SetLongField(p" + j + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j + "));");
            }
            if (methodInfo.parameterTypes[j] == String.class) {
                this.out.println(indent + "if (p" + j + " != NULL) e->ReleaseStringUTFChars(p" + j + ", pointer" + j + ");");
                continue;
            }
            if (!methodInfo.parameterTypes[j].isArray()) continue;
            String s = methodInfo.parameterTypes[j].getComponentType().getName();
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            this.out.println(indent + "if (p" + j + " != NULL) e->Release" + s + "ArrayElements(p" + j + ", pointer" + j + ", 0);");
        }
        if (methodInfo.mayThrowException) {
            this.out.println("    } catch (...) {");
            this.out.println("        JavaCPP_handleException(e);");
            this.out.println("    }");
        }
    }

    private void doCallback(Class<?> cls, Method callbackMethod, String callbackName) {
        Convention convention = cls.getAnnotation(Convention.class);
        String callingConvention = convention == null ? "" : convention.value() + " ";
        Class<?> callbackReturnType = callbackMethod.getReturnType();
        Class<?>[] callbackParameterTypes = callbackMethod.getParameterTypes();
        Annotation[] callbackAnnotations = callbackMethod.getAnnotations();
        Annotation[][] callbackParameterAnnotations = callbackMethod.getParameterAnnotations();
        this.functionPointers.register("JavaCPP_" + callbackName + "_instance");
        this.out.println("static jmethodID JavaCPP_" + callbackName + "_callMethodID = NULL;");
        String[] paramTypeName = Generator.getAnnotatedCPPTypeName(callbackAnnotations, callbackReturnType);
        this.out.print("static " + paramTypeName[0] + paramTypeName[1] + " " + callingConvention + "JavaCPP_" + callbackName + "_callback(");
        for (int j = 0; j < callbackParameterTypes.length; ++j) {
            paramTypeName = Generator.getAnnotatedCPPTypeName(callbackParameterAnnotations[j], callbackParameterTypes[j]);
            this.out.print(paramTypeName[0] + " p" + j + paramTypeName[1]);
            if (j >= callbackParameterTypes.length - 1) continue;
            this.out.print(", ");
        }
        this.out.println(") {");
        String returnVariable = "";
        if (callbackReturnType != Void.TYPE) {
            this.out.println("    " + Generator.getJNITypeName(callbackReturnType) + " r = 0;");
            returnVariable = "r";
        }
        String callbackReturnCast = Generator.getCast(callbackAnnotations, callbackReturnType);
        this.out.println("    JNIEnv* e;");
        this.out.println("    if (JavaCPP_vm->AttachCurrentThread((void**)&e, NULL) != JNI_OK) {");
        this.out.println("        fprintf(stderr, \"Could not attach the JavaVM to the current thread in callback for " + cls.getName() + ".\");");
        this.out.println("        return" + (callbackReturnType == Void.TYPE ? ";" : " " + callbackReturnCast + "0;"));
        this.out.println("    }");
        if (callbackParameterTypes.length > 0) {
            this.out.println("    jvalue args[" + callbackParameterTypes.length + "];");
            for (int j = 0; j < callbackParameterTypes.length; ++j) {
                String[] typeName;
                if (callbackParameterTypes[j].isPrimitive()) {
                    this.out.println("    args[" + j + "]." + Generator.getSignature(callbackParameterTypes[j]).toLowerCase() + " = p" + j + ";");
                    continue;
                }
                Annotation passBy = Generator.getBy(callbackParameterAnnotations[j]);
                Adapter adapter = Generator.getAdapter(callbackParameterAnnotations[j]);
                String[] stringArray = typeName = adapter != null ? Generator.getCPPTypeName(callbackParameterTypes[j]) : Generator.getCastedCPPTypeName(callbackParameterAnnotations[j], callbackParameterTypes[j]);
                if (adapter != null) {
                    this.out.println("    " + adapter.value() + " adapter" + j + "(p" + j + ");");
                    this.out.println("    int capacity" + j + " = adapter" + j + ".capacity;");
                    this.out.println("    jlong deallocator" + j + " = ptr_to_jlong(&(" + adapter.value() + "::deallocate));");
                }
                if (Pointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                        typeName[0] = "JavaCPP_" + Generator.mangle(callbackParameterTypes[j].getName()) + "*";
                        typeName[1] = "";
                    }
                    String valueTypeName = typeName[0].substring(0, typeName[0].length() - 1);
                    this.out.println("    jobject o" + j + " = NULL;");
                    this.out.println("    " + typeName[0] + " pointer" + j + typeName[1] + ";");
                    if (FunctionPointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                        this.out.println("    " + valueTypeName + " function" + j + ";");
                        this.out.println("    function" + j + ".pointer = p" + j + ";");
                        this.out.println("    pointer" + j + " = &function" + j + ";");
                    } else if (adapter != null) {
                        this.out.println("    pointer" + j + " = adapter" + j + ";");
                    } else if (passBy instanceof ByVal || passBy instanceof ByRef) {
                        this.out.println("    pointer" + j + " = (" + typeName[0] + typeName[1] + ")&p" + j + ";");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    if (p" + j + " == NULL) {");
                        this.out.println("        throw std::exception(\"Pointer address of parameter " + j + " is NULL.\")");
                        this.out.println("    }");
                        this.out.println("    pointer" + j + " = *p" + j + ";");
                    } else {
                        this.out.println("    pointer" + j + " = p" + j + ";");
                    }
                    String s = "    o" + j + " = e->AllocObject(JavaCPP_getClass(e, " + this.jclasses.register(callbackParameterTypes[j]) + "));";
                    if (adapter != null && adapter.out() || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                        this.out.println(s);
                    } else {
                        this.out.println("    if (pointer" + j + " != NULL) { ");
                        this.out.println("    " + s);
                        this.out.println("    }");
                    }
                    this.out.println("    if (o" + j + " != NULL) { ");
                    if (adapter != null) {
                        this.out.println("        if (deallocator" + j + " != 0) {");
                        this.out.println("            jvalue args[3];");
                        this.out.println("            args[0].j = ptr_to_jlong(pointer" + j + ");");
                        this.out.println("            args[1].i = capacity" + j + ";");
                        this.out.println("            args[2].j = deallocator" + j + ";");
                        this.out.println("            e->CallNonvirtualVoidMethodA(o" + j + ", JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
                        this.out.println("        } else {");
                        this.out.println("            e->SetLongField(o" + j + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j + "));");
                        this.out.println("            e->SetIntField(o" + j + ", JavaCPP_capacityFieldID, capacity" + j + ");");
                        this.out.println("        }");
                    } else {
                        this.out.println("        e->SetLongField(o" + j + ", JavaCPP_addressFieldID, ptr_to_jlong(pointer" + j + "));");
                    }
                    this.out.println("    }");
                    this.out.println("    args[" + j + "].l = o" + j + ";");
                    continue;
                }
                if (callbackParameterTypes[j] == String.class) {
                    this.out.println("    jstring o" + j + " = p" + j + " == NULL ? NULL : e->NewStringUTF(" + (adapter != null ? "adapter" : "p") + j + ");");
                    this.out.println("    args[" + j + "].l = o" + j + ";");
                    continue;
                }
                logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported parameter type \"" + callbackParameterTypes[j].getCanonicalName() + "\". Compilation will most likely fail.");
            }
        }
        if (returnVariable.length() > 0) {
            returnVariable = returnVariable + " = ";
        }
        String s = "Object";
        if (callbackReturnType.isPrimitive()) {
            s = callbackReturnType.getName();
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        this.out.println("    " + returnVariable + "e->Call" + s + "MethodA(JavaCPP_" + callbackName + "_instance, JavaCPP_" + callbackName + "_callMethodID, " + (callbackParameterTypes.length == 0 ? "NULL);" : "args);"));
        for (int j = 0; j < callbackParameterTypes.length; ++j) {
            if (Pointer.class.isAssignableFrom(callbackParameterTypes[j])) {
                String[] typeName = Generator.getCastedCPPTypeName(callbackParameterAnnotations[j], callbackParameterTypes[j]);
                Annotation passBy = Generator.getBy(callbackParameterAnnotations[j]);
                Adapter adapter = Generator.getAdapter(callbackParameterAnnotations[j]);
                if (adapter != null && adapter.out() || passBy instanceof ByPtrPtr || passBy instanceof ByPtrRef) {
                    this.out.println("    " + typeName[0] + " rpointer" + j + typeName[1] + " = (" + typeName[0] + typeName[1] + ")jlong_to_ptr(e->GetLongField(o" + j + ", JavaCPP_addressFieldID);");
                    if (adapter != null && adapter.out()) {
                        this.out.println("    jint rcapacity" + j + " = e->GetIntField(o" + j + ", JavaCPP_capacityFieldID));");
                    }
                    if (!callbackParameterTypes[j].isAnnotationPresent(Opaque.class)) {
                        this.out.println("    jint rposition" + j + " = e->GetIntField(o" + j + ", JavaCPP_positionFieldID));");
                        this.out.println("    rpointer" + j + " += rposition" + j + ";");
                        if (adapter != null && adapter.out()) {
                            this.out.println("    rcapacity" + j + " -= rposition" + j + ";");
                        }
                    }
                    if (adapter != null && adapter.out()) {
                        this.out.println("    adapter" + j + ".assign(rpointer" + j + ", rcapacity" + j + ");");
                    } else if (passBy instanceof ByPtrPtr) {
                        this.out.println("    *p" + j + " = rpointer" + j + ";");
                    } else if (passBy instanceof ByPtrRef) {
                        this.out.println("    p" + j + " = rpointer" + j + ";");
                    }
                }
            }
            if (callbackParameterTypes[j].isPrimitive()) continue;
            this.out.println("    e->DeleteLocalRef(o" + j + ");");
        }
        if (callbackReturnType != Void.TYPE) {
            Annotation returnBy = Generator.getBy(callbackAnnotations);
            String[] returnTypeName = Generator.getCPPTypeName(callbackReturnType);
            Adapter adapter = Generator.getAdapter(callbackAnnotations);
            if (callbackReturnType.isPrimitive()) {
                this.out.println("    return " + callbackReturnCast + "r;");
            } else {
                if (Pointer.class.isAssignableFrom(callbackReturnType)) {
                    this.out.println("    " + returnTypeName[0] + " rpointer" + returnTypeName[1] + " = r == NULL ? NULL : (" + returnTypeName[0] + returnTypeName[1] + ")jlong_to_ptr(e->GetLongField(r, JavaCPP_addressFieldID));");
                    if (adapter != null) {
                        this.out.println("    jint rcapacity = r == NULL ? 0 : e->GetIntField(r, JavaCPP_capacityFieldID);");
                    }
                    if (!callbackReturnType.isAnnotationPresent(Opaque.class)) {
                        this.out.println("    jint rposition = r == NULL ? 0 : e->GetIntField(r, JavaCPP_positionFieldID);");
                        this.out.println("    rpointer += rposition;");
                        if (adapter != null) {
                            this.out.println("    rcapacity -= rposition;");
                        }
                    }
                } else if (Buffer.class.isAssignableFrom(callbackReturnType)) {
                    this.out.println("    " + returnTypeName[0] + " rpointer" + returnTypeName[1] + " = r == NULL ? NULL : e->GetDirectBufferAddress(r);");
                    if (adapter != null) {
                        this.out.println("    jint rcapacity = r == NULL ? 0 : e->GetDirectBufferCapacity(r);");
                    }
                } else {
                    logger.log(Level.WARNING, "Callback \"" + callbackMethod + "\" has unsupported return type \"" + callbackReturnType.getCanonicalName() + "\". Compilation will most likely fail.");
                }
                if (adapter != null) {
                    this.out.println("    return " + adapter.value() + "(" + callbackReturnCast + "rpointer, rcapacity);");
                } else if (FunctionPointer.class.isAssignableFrom(callbackReturnType)) {
                    this.out.println("    return " + callbackReturnCast + "(rpointer == NULL ? NULL : rpointer->pointer);");
                } else if (returnBy instanceof ByVal || returnBy instanceof ByRef) {
                    this.out.println("    if (rpointer == NULL) {");
                    this.out.println("        throw std::exception(\"Return pointer address is NULL.\");");
                    this.out.println("    }");
                    this.out.println("    return *" + callbackReturnCast + "rpointer;");
                } else if (returnBy instanceof ByPtrPtr) {
                    this.out.println("    return " + callbackReturnCast + "&rpointer;");
                } else {
                    this.out.println("    return " + callbackReturnCast + "rpointer;");
                }
            }
        }
        this.out.println("}");
    }

    private void doCallbackAllocator(Class cls, Method callbackMethod, String callbackName) {
        String valueTypeName = "JavaCPP_" + Generator.mangle(cls.getName());
        this.out.println("    e->DeleteGlobalRef(JavaCPP_" + callbackName + "_instance);");
        this.out.println("    JavaCPP_" + callbackName + "_instance = e->NewGlobalRef(o);");
        this.out.println("    if (JavaCPP_" + callbackName + "_instance == NULL) {");
        this.out.println("        fprintf(stderr, \"Error creating global reference of " + cls.getName() + " instance for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    JavaCPP_" + callbackName + "_callMethodID = e->GetMethodID(e->GetObjectClass(o), \"" + callbackMethod.getName() + "\", \"(" + Generator.getSignature(callbackMethod.getParameterTypes()) + ")" + Generator.getSignature(callbackMethod.getReturnType()) + "\");");
        this.out.println("    if (JavaCPP_" + callbackName + "_callMethodID == NULL) {");
        this.out.println("        fprintf(stderr, \"Error getting method ID of function caller \\\"" + callbackMethod + "\\\" for callback.\");");
        this.out.println("        return;");
        this.out.println("    }");
        this.out.println("    " + valueTypeName + "* rpointer = new " + valueTypeName + ";");
        this.out.println("    rpointer->pointer = &JavaCPP_" + callbackName + "_callback;");
        this.out.println("    jvalue args[3];");
        this.out.println("    args[0].j = ptr_to_jlong(rpointer);");
        this.out.println("    args[1].i = 1;");
        this.out.println("    args[2].j = ptr_to_jlong(&" + valueTypeName + "_deallocate);");
        this.deallocators.register(cls);
        this.out.println("    e->CallNonvirtualVoidMethodA(o, JavaCPP_getClass(e, " + this.jclasses.register(Pointer.class) + "), JavaCPP_initMethodID, args);");
        this.out.println("}");
    }

    public boolean checkPlatform(Platform platform) {
        if (platform == null) {
            return true;
        }
        String platformName = this.properties.getProperty("platform.name");
        String[][] names = new String[][]{platform.value(), platform.not()};
        boolean[] matches = new boolean[]{false, false};
        block0: for (int i = 0; i < names.length; ++i) {
            for (String s : names[i]) {
                if (!platformName.startsWith(s)) continue;
                matches[i] = true;
                continue block0;
            }
        }
        return !(names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]);
    }

    private static Method getFunctionMethod(Class<?> cls, boolean[] callbackAllocators) {
        if (!FunctionPointer.class.isAssignableFrom(cls)) {
            return null;
        }
        Method[] methods = cls.getDeclaredMethods();
        Method functionMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            int modifiers = methods[i].getModifiers();
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            Class<?> returnType = methods[i].getReturnType();
            if (!Modifier.isNative(modifiers) || Modifier.isStatic(modifiers)) continue;
            if (callbackAllocators != null && methodName.startsWith("allocate") && returnType == Void.TYPE && parameterTypes.length == 0) {
                callbackAllocators[i] = true;
                continue;
            }
            if (!methodName.startsWith("call")) continue;
            functionMethod = methods[i];
        }
        return functionMethod;
    }

    public static MethodInformation getMethodInformation(Method method) {
        String[] stringArray;
        if (!Modifier.isNative(method.getModifiers())) {
            return null;
        }
        MethodInformation info = new MethodInformation();
        info.cls = method.getDeclaringClass();
        info.method = method;
        info.annotations = method.getAnnotations();
        info.modifiers = method.getModifiers();
        info.returnType = method.getReturnType();
        info.name = method.getName();
        Name name = method.getAnnotation(Name.class);
        if (name != null) {
            stringArray = name.value();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = info.name;
        }
        info.memberName = stringArray;
        Index index = method.getAnnotation(Index.class);
        info.dim = index != null ? index.value() : 0;
        info.parameterTypes = method.getParameterTypes();
        info.parameterAnnotations = method.getParameterAnnotations();
        Annotation behavior = Generator.getBehavior(method);
        boolean canBeGetter = info.returnType != Void.TYPE;
        boolean canBeSetter = (info.returnType == Void.TYPE || info.returnType == info.cls) && info.parameterTypes.length > 0;
        boolean canBeAllocator = !Modifier.isStatic(info.modifiers) && info.returnType == Void.TYPE;
        boolean canBeArrayAllocator = canBeAllocator && info.parameterTypes.length == 1 && (info.parameterTypes[0] == Integer.TYPE || info.parameterTypes[0] == Long.TYPE);
        boolean valueGetter = false;
        boolean valueSetter = false;
        boolean memberGetter = false;
        boolean memberSetter = false;
        Method pairedMethod = null;
        Method[] methods = info.cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method2 = methods[i];
            int modifiers2 = method2.getModifiers();
            Class<?> returnType2 = method2.getReturnType();
            String methodName2 = method2.getName();
            Class<?>[] parameterTypes2 = method2.getParameterTypes();
            if (method.equals(method2) || !Modifier.isNative(modifiers2)) continue;
            boolean canBeValueGetter = false;
            boolean canBeValueSetter = false;
            if (canBeGetter && "get".equals(info.name) && "put".equals(methodName2)) {
                canBeValueGetter = true;
            } else if (canBeSetter && "put".equals(info.name) && "get".equals(methodName2)) {
                canBeValueSetter = true;
            } else {
                if (!methodName2.equals(info.name)) continue;
                info.overloaded = true;
            }
            boolean sameIndexParameters = true;
            for (int j = 0; j < info.parameterTypes.length && j < parameterTypes2.length; ++j) {
                if (info.parameterTypes[j] == parameterTypes2[j]) continue;
                sameIndexParameters = false;
            }
            if (!sameIndexParameters) continue;
            if (canBeGetter && parameterTypes2.length - 1 == info.parameterTypes.length && info.returnType == parameterTypes2[parameterTypes2.length - 1] && (returnType2 == Void.TYPE || returnType2 == info.cls)) {
                pairedMethod = method2;
                valueGetter = canBeValueGetter;
                memberGetter = !canBeValueGetter;
                continue;
            }
            if (!canBeSetter || info.parameterTypes.length - 1 != parameterTypes2.length || returnType2 != info.parameterTypes[info.parameterTypes.length - 1]) continue;
            pairedMethod = method2;
            valueSetter = canBeValueSetter;
            memberSetter = !canBeValueSetter;
        }
        if (canBeGetter && behavior instanceof ValueGetter) {
            info.valueGetter = true;
        } else if (canBeSetter && behavior instanceof ValueSetter) {
            info.valueSetter = true;
        } else if (canBeGetter && behavior instanceof MemberGetter) {
            info.memberGetter = true;
        } else if (canBeSetter && behavior instanceof MemberSetter) {
            info.memberSetter = true;
        } else if (canBeAllocator && behavior instanceof Allocator) {
            info.allocator = true;
        } else if (canBeArrayAllocator && behavior instanceof ArrayAllocator) {
            info.arrayAllocator = true;
            info.allocator = true;
        } else if (behavior == null) {
            if (info.returnType == Void.TYPE && "deallocate".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 2 && info.parameterTypes[0] == Long.TYPE && info.parameterTypes[1] == Long.TYPE) {
                info.deallocator = true;
            } else if (canBeAllocator && "allocate".equals(info.name)) {
                info.allocator = true;
            } else if (canBeArrayAllocator && "allocateArray".equals(info.name)) {
                info.arrayAllocator = true;
                info.allocator = true;
            } else if (info.returnType.isAssignableFrom(ByteBuffer.class) && "asDirectBuffer".equals(info.name) && !Modifier.isStatic(info.modifiers) && info.parameterTypes.length == 0) {
                info.bufferGetter = true;
            } else if (valueGetter) {
                info.valueGetter = true;
                info.pairedMethod = pairedMethod;
            } else if (valueSetter) {
                info.valueSetter = true;
                info.pairedMethod = pairedMethod;
            } else if (memberGetter) {
                info.memberGetter = true;
                info.pairedMethod = pairedMethod;
            } else if (memberSetter) {
                info.memberSetter = true;
                info.pairedMethod = pairedMethod;
            }
        } else {
            logger.log(Level.WARNING, "Method \"" + method + "\" cannot behave like a \"" + behavior + "\". No code will be generated.");
            return null;
        }
        if (name == null && info.pairedMethod != null && (name = info.pairedMethod.getAnnotation(Name.class)) != null) {
            info.memberName = name.value();
        }
        info.noOffset = method.isAnnotationPresent(NoOffset.class);
        if (!info.noOffset && info.pairedMethod != null) {
            info.noOffset = info.pairedMethod.isAnnotationPresent(NoOffset.class);
        }
        if (info.valueGetter || info.memberGetter) {
            info.dim = info.parameterTypes.length;
        } else if (info.memberSetter || info.valueSetter) {
            info.dim = info.parameterTypes.length - 1;
        }
        if (!((info.deallocator || info.valueGetter || info.valueSetter || info.memberGetter || info.memberSetter || info.bufferGetter) && !(Generator.getBy(info.annotations) instanceof ByVal))) {
            info.mayThrowException = true;
        }
        return info;
    }

    public static Adapter getParameterAdapter(MethodInformation methodInfo, int j) {
        Adapter adapter = Generator.getAdapter(methodInfo.parameterAnnotations[j]);
        if (adapter == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            adapter = Generator.getAdapter(methodInfo.pairedMethod.getAnnotations());
        }
        return adapter;
    }

    public static Adapter getAdapter(Annotation ... annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof Adapter)) continue;
            return (Adapter)a;
        }
        return null;
    }

    public static String getParameterCast(MethodInformation methodInfo, int j) {
        String cast = Generator.getCast(methodInfo.parameterAnnotations[j], methodInfo.parameterTypes[j]);
        if ((cast == null || cast.length() == 0) && j == methodInfo.parameterTypes.length - 1 && (methodInfo.valueSetter || methodInfo.memberSetter) && methodInfo.pairedMethod != null) {
            cast = Generator.getCast(methodInfo.pairedMethod.getAnnotations(), methodInfo.pairedMethod.getReturnType());
        }
        return cast;
    }

    public static String getCast(Annotation[] annotations, Class<?> type) {
        String[] typeName = null;
        for (Annotation a : annotations) {
            if (a instanceof Cast) {
                typeName = Generator.getCastedCPPTypeName(annotations, type);
                continue;
            }
            if (!(a instanceof Const)) continue;
            typeName = Generator.getAnnotatedCPPTypeName(annotations, type);
        }
        return typeName != null ? "(" + (String)typeName[0] + typeName[1] + ")" : "";
    }

    public static Annotation getParameterBy(MethodInformation methodInfo, int j) {
        Annotation passBy = Generator.getBy(methodInfo.parameterAnnotations[j]);
        if (passBy == null && methodInfo.pairedMethod != null && (methodInfo.valueSetter || methodInfo.memberSetter)) {
            passBy = Generator.getBy(methodInfo.pairedMethod.getAnnotations());
        }
        return passBy;
    }

    public static Annotation getBy(Annotation ... annotations) {
        Annotation byAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof ByPtr) && !(a instanceof ByPtrPtr) && !(a instanceof ByPtrRef) && !(a instanceof ByRef) && !(a instanceof ByVal)) continue;
            if (byAnnotation != null) {
                logger.log(Level.WARNING, "\"By\" annotation \"" + byAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            byAnnotation = a;
        }
        return byAnnotation;
    }

    public static Annotation getBehavior(Method method) {
        Annotation[] annotations = method.getAnnotations();
        Annotation behaviorAnnotation = null;
        for (Annotation a : annotations) {
            if (!(a instanceof Function) && !(a instanceof Allocator) && !(a instanceof ArrayAllocator) && !(a instanceof ValueSetter) && !(a instanceof ValueGetter) && !(a instanceof MemberGetter) && !(a instanceof MemberSetter)) continue;
            if (behaviorAnnotation != null) {
                logger.log(Level.WARNING, "Behavior annotation \"" + behaviorAnnotation + "\" already found. Ignoring superfluous annotation \"" + a + "\".");
                continue;
            }
            behaviorAnnotation = a;
        }
        return behaviorAnnotation;
    }

    public static String[] getAnnotatedCPPTypeName(Annotation[] annotations, Class<?> type) {
        String[] typeName = Generator.getCastedCPPTypeName(annotations, type);
        String prefix = typeName[0];
        String suffix = typeName[1];
        Annotation by = Generator.getBy(annotations);
        if (by instanceof ByVal) {
            prefix = prefix.substring(0, prefix.length() - 1);
        } else if (by instanceof ByRef) {
            prefix = prefix.substring(0, prefix.length() - 1) + "&";
        } else if (by instanceof ByPtrPtr) {
            prefix = prefix + "*";
        } else if (by instanceof ByPtrRef) {
            prefix = prefix + "&";
        }
        typeName[0] = prefix;
        typeName[1] = suffix;
        return typeName;
    }

    public static String[] getCastedCPPTypeName(Annotation[] annotations, Class<?> type) {
        String[] typeName = null;
        boolean warning = false;
        for (Annotation a : annotations) {
            if (a instanceof Cast) {
                warning = typeName != null;
                String prefix = ((Cast)a).value();
                String suffix = "";
                int parenthesis = prefix.indexOf(41);
                if (parenthesis > 0) {
                    suffix = prefix.substring(parenthesis).trim();
                    prefix = prefix.substring(0, parenthesis).trim();
                }
                typeName = new String[]{prefix, suffix};
                continue;
            }
            if (!(a instanceof Const)) continue;
            warning = typeName != null;
            typeName = Generator.getCPPTypeName(type);
            typeName[0] = "const " + typeName[0];
        }
        if (warning) {
            logger.log(Level.WARNING, "\"Cast\" and \"Const\" annotations are mutually exclusive.");
        }
        if (typeName == null) {
            typeName = Generator.getCPPTypeName(type);
        }
        return typeName;
    }

    public static String[] getCPPTypeName(Class<?> type) {
        String prefix = "";
        String suffix = "";
        if (type == Buffer.class || type == Pointer.class) {
            prefix = "void*";
        } else if (type == byte[].class || type == ByteBuffer.class || type == BytePointer.class) {
            prefix = "signed char*";
        } else if (type == short[].class || type == ShortBuffer.class || type == ShortPointer.class) {
            prefix = "short*";
        } else if (type == int[].class || type == IntBuffer.class || type == IntPointer.class) {
            prefix = "int*";
        } else if (type == long[].class || type == LongBuffer.class || type == LongPointer.class) {
            prefix = "jlong*";
        } else if (type == float[].class || type == FloatBuffer.class || type == FloatPointer.class) {
            prefix = "float*";
        } else if (type == double[].class || type == DoubleBuffer.class || type == DoublePointer.class) {
            prefix = "double*";
        } else if (type == char[].class || type == CharBuffer.class || type == CharPointer.class) {
            prefix = "unsigned short*";
        } else if (type == boolean[].class) {
            prefix = "unsigned char*";
        } else if (type == PointerPointer.class) {
            prefix = "void**";
        } else if (type == String.class) {
            prefix = "const char*";
        } else if (type == Byte.TYPE) {
            prefix = "signed char";
        } else if (type == Long.TYPE) {
            prefix = "jlong";
        } else if (type == Character.TYPE) {
            prefix = "unsigned short";
        } else if (type == Boolean.TYPE) {
            prefix = "unsigned char";
        } else if (type.isPrimitive()) {
            prefix = type.getName();
        } else if (FunctionPointer.class.isAssignableFrom(type)) {
            Method functionMethod = Generator.getFunctionMethod(type, null);
            if (functionMethod != null) {
                int j;
                Convention convention = type.getAnnotation(Convention.class);
                String callingConvention = convention == null ? "" : convention.value() + " ";
                Namespace namespace = type.getAnnotation(Namespace.class);
                String spaceName = namespace == null ? "" : namespace.value() + "::";
                Class<?> returnType = functionMethod.getReturnType();
                Class<?>[] parameterTypes = functionMethod.getParameterTypes();
                Annotation[] annotations = functionMethod.getAnnotations();
                Annotation[][] parameterAnnotations = functionMethod.getParameterAnnotations();
                String[] returnTypeName = Generator.getAnnotatedCPPTypeName(annotations, returnType);
                prefix = returnTypeName[0] + returnTypeName[1] + " (" + callingConvention + spaceName + "*";
                suffix = ")(";
                int n = j = namespace == null ? 0 : 1;
                while (j < parameterTypes.length) {
                    String[] paramTypeName = Generator.getAnnotatedCPPTypeName(parameterAnnotations[j], parameterTypes[j]);
                    suffix = suffix + paramTypeName[0] + " p" + j + paramTypeName[1];
                    if (j < parameterTypes.length - 1) {
                        suffix = suffix + ", ";
                    }
                    ++j;
                }
                suffix = suffix + ")";
            }
        } else {
            String spacedType = "";
            while (type != null) {
                String spaceName;
                Namespace namespace = type.getAnnotation(Namespace.class);
                String string = spaceName = namespace == null ? "" : namespace.value();
                if (Pointer.class.isAssignableFrom(type)) {
                    String s;
                    Name name = type.getAnnotation(Name.class);
                    if (name == null) {
                        s = type.getName();
                        s = s.substring(s.lastIndexOf("$") + 1);
                    } else {
                        s = name.value()[0];
                    }
                    spaceName = spaceName.length() == 0 ? s : spaceName + "::" + s;
                }
                if (spacedType.length() == 0) {
                    spacedType = spaceName;
                } else if (spaceName.length() > 0) {
                    spacedType = spaceName + "::" + spacedType;
                }
                type = type.getDeclaringClass();
            }
            prefix = spacedType.length() > 0 ? spacedType + "*" : "";
        }
        return new String[]{prefix, suffix};
    }

    public static String getJNITypeName(Class type) {
        if (type == Byte.TYPE) {
            return "jbyte";
        }
        if (type == Short.TYPE) {
            return "jshort";
        }
        if (type == Integer.TYPE) {
            return "jint";
        }
        if (type == Long.TYPE) {
            return "jlong";
        }
        if (type == Float.TYPE) {
            return "jfloat";
        }
        if (type == Double.TYPE) {
            return "jdouble";
        }
        if (type == Character.TYPE) {
            return "jchar";
        }
        if (type == Boolean.TYPE) {
            return "jboolean";
        }
        if (type == byte[].class) {
            return "jbyteArray";
        }
        if (type == short[].class) {
            return "jshortArray";
        }
        if (type == int[].class) {
            return "jintArray";
        }
        if (type == long[].class) {
            return "jlongArray";
        }
        if (type == float[].class) {
            return "jfloatArray";
        }
        if (type == double[].class) {
            return "jdoubleArray";
        }
        if (type == char[].class) {
            return "jcharArray";
        }
        if (type == boolean[].class) {
            return "jbooleanArray";
        }
        if (type.isArray()) {
            return "jobjectArray";
        }
        if (type == String.class) {
            return "jstring";
        }
        if (type == Class.class) {
            return "jclass";
        }
        if (type == Void.TYPE) {
            return "void";
        }
        return "jobject";
    }

    public static String getSignature(Class ... types) {
        StringBuilder signature = new StringBuilder(2 * types.length);
        for (int i = 0; i < types.length; ++i) {
            signature.append(Generator.getSignature(types[i]));
        }
        return signature.toString();
    }

    public static String getSignature(Class type) {
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type.isArray()) {
            return type.getName().replace(".", "/");
        }
        return "L" + type.getName().replace(".", "/") + ";";
    }

    public static String mangle(String name) {
        StringBuilder mangledName = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                mangledName.append(c);
                continue;
            }
            if (c == '_') {
                mangledName.append("_1");
                continue;
            }
            if (c == ';') {
                mangledName.append("_2");
                continue;
            }
            if (c == '[') {
                mangledName.append("_3");
                continue;
            }
            if (c == '.' || c == '/') {
                mangledName.append("_");
                continue;
            }
            String code = Integer.toHexString(c);
            mangledName.append("_0");
            switch (code.length()) {
                case 1: {
                    mangledName.append("0");
                }
                case 2: {
                    mangledName.append("0");
                }
                case 3: {
                    mangledName.append("0");
                }
            }
            mangledName.append(code);
        }
        return mangledName.toString();
    }

    public static class MethodInformation {
        public Class<?> cls;
        public Method method;
        public Annotation[] annotations;
        public int modifiers;
        public Class<?> returnType;
        public String name;
        public String[] memberName;
        public int dim;
        public Class<?>[] parameterTypes;
        public Annotation[][] parameterAnnotations;
        public boolean overloaded;
        public boolean noOffset;
        public boolean deallocator;
        public boolean allocator;
        public boolean arrayAllocator;
        public boolean bufferGetter;
        public boolean valueGetter;
        public boolean valueSetter;
        public boolean memberGetter;
        public boolean memberSetter;
        public Method pairedMethod;
        public boolean mayThrowException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedListRegister<E>
    extends LinkedList<E> {
        public int register(E e) {
            int i = this.indexOf(e);
            if (i < 0) {
                this.add(e);
                i = this.size() - 1;
            }
            return i;
        }
    }
}

