/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.FloatBuffer;

public class FloatPointer
extends Pointer {
    public FloatPointer(float ... array) {
        this(array.length);
        this.asBuffer().put(array);
    }

    public FloatPointer(FloatBuffer buffer) {
        super(buffer);
        if (buffer.hasArray()) {
            float[] array = buffer.array();
            this.allocateArray(array.length);
            this.asBuffer().put(array);
            this.position(buffer.position());
        }
    }

    public FloatPointer(int size) {
        this.allocateArray(size);
    }

    public FloatPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public FloatPointer position(int position) {
        return (FloatPointer)super.position(position);
    }

    public FloatPointer capacity(int capacity) {
        return (FloatPointer)super.capacity(capacity);
    }

    public float get() {
        return this.get(0);
    }

    public native float get(int var1);

    public FloatPointer put(float f) {
        return this.put(0, f);
    }

    public native FloatPointer put(int var1, float var2);

    public final FloatBuffer asBuffer() {
        return this.asByteBuffer().asFloatBuffer();
    }
}

