/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.CharBuffer;

public class CharPointer
extends Pointer {
    public CharPointer(String s) {
        this(s.toCharArray().length + 1);
        this.putString(s);
    }

    public CharPointer(char ... array) {
        this(array.length);
        this.asBuffer().put(array);
    }

    public CharPointer(CharBuffer buffer) {
        super(buffer);
        if (buffer.hasArray()) {
            char[] array = buffer.array();
            this.allocateArray(array.length);
            this.asBuffer().put(array);
            this.position(buffer.position());
        }
    }

    public CharPointer(int size) {
        this.allocateArray(size);
    }

    public CharPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public CharPointer position(int position) {
        return (CharPointer)super.position(position);
    }

    public CharPointer capacity(int capacity) {
        return (CharPointer)super.capacity(capacity);
    }

    public char[] getStringChars() {
        char[] newbuffer;
        char[] buffer = new char[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != '\u0000') {
            ++j;
            if (++i < buffer.length) continue;
            newbuffer = new char[2 * buffer.length];
            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
            buffer = newbuffer;
        }
        newbuffer = new char[i];
        System.arraycopy(buffer, 0, newbuffer, 0, i);
        return newbuffer;
    }

    public String getString() {
        return new String(this.getStringChars());
    }

    public CharPointer putString(String s) {
        char[] chars = s.toCharArray();
        this.asBuffer().put(chars).put('\u0000');
        return this;
    }

    public char get() {
        return this.get(0);
    }

    public native char get(int var1);

    public CharPointer put(char c) {
        return this.put(0, c);
    }

    public native CharPointer put(int var1, char var2);

    public final CharBuffer asBuffer() {
        return this.asByteBuffer().asCharBuffer();
    }
}

