/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class BytePointer
extends Pointer {
    public BytePointer(String s, String charsetName) throws UnsupportedEncodingException {
        this(s.getBytes(charsetName).length + 1);
        this.putString(s, charsetName);
    }

    public BytePointer(String s) {
        this(s.getBytes().length + 1);
        this.putString(s);
    }

    public BytePointer(byte ... array) {
        this(array.length);
        this.asBuffer().put(array);
    }

    public BytePointer(ByteBuffer buffer) {
        super(buffer);
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            this.allocateArray(array.length);
            this.asBuffer().put(array);
            this.position(buffer.position());
        }
    }

    public BytePointer(int size) {
        this.allocateArray(size);
    }

    public BytePointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public BytePointer position(int position) {
        return (BytePointer)super.position(position);
    }

    public BytePointer capacity(int capacity) {
        return (BytePointer)super.capacity(capacity);
    }

    public byte[] getStringBytes() {
        byte[] newbuffer;
        byte[] buffer = new byte[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != 0) {
            ++j;
            if (++i < buffer.length) continue;
            newbuffer = new byte[2 * buffer.length];
            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
            buffer = newbuffer;
        }
        newbuffer = new byte[i];
        System.arraycopy(buffer, 0, newbuffer, 0, i);
        return newbuffer;
    }

    public String getString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.getStringBytes(), charsetName);
    }

    public String getString() {
        return new String(this.getStringBytes());
    }

    public BytePointer putString(String s, String charsetName) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(charsetName);
        this.asBuffer().put(bytes).put((byte)0);
        return this;
    }

    public BytePointer putString(String s) {
        byte[] bytes = s.getBytes();
        this.asBuffer().put(bytes).put((byte)0);
        return this;
    }

    public byte get() {
        return this.get(0);
    }

    public native byte get(int var1);

    public BytePointer put(byte b) {
        return this.put(0, b);
    }

    public native BytePointer put(int var1, byte var2);

    public final ByteBuffer asBuffer() {
        return (ByteBuffer)super.asBuffer();
    }
}

