/*
 * Decompiled with CFR 0.152.
 */
package MotorControlSolution;

import MotorControlSolution.RobotVelocityController;
import MotorControlSolution.WheelVelocityControllerI;

public class RobotVelocityControllerBalanced
extends RobotVelocityController {
    protected double[] desiredAngularVelocity = new double[2];
    protected double desiredAngularVelocityAvg;
    protected double desiredAngularVelocityDiff;
    protected double actualDiffAngle;
    protected double desiredDiffAngle;
    protected int updateDbg = 0;

    public RobotVelocityControllerBalanced() {
        super(new WheelVelocityControllerI(), new WheelVelocityControllerI());
    }

    public void controlStep(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        d = this.desiredDiffAngle - this.actualDiffAngle;
        d2 = this.desiredAngularVelocityAvg + this.gain * d;
        d3 = this.desiredAngularVelocityAvg - this.gain * d;
        this.wheelVelocityController[0].setDesiredAngularVelocity(d2);
        this.wheelVelocityController[1].setDesiredAngularVelocity(-d3);
        dArray[0] = this.wheelVelocityController[0].controlStep();
        dArray[1] = -this.wheelVelocityController[1].controlStep();
    }

    public void setDesiredAngularVelocity(double d, double d2) {
        this.desiredAngularVelocity[0] = d;
        this.desiredAngularVelocity[1] = d2;
        this.desiredAngularVelocityAvg = (d + d2) / 2.0;
        this.desiredAngularVelocityDiff = d - d2;
    }

    public void setDesiredAngularVelocity(int n, double d) {
        double d2 = this.desiredAngularVelocity[0];
        double d3 = this.desiredAngularVelocity[1];
        if (n == 0) {
            d2 = d;
        }
        if (n == 1) {
            d3 = d;
        }
        this.setDesiredAngularVelocity(d2, d3);
    }

    public double getDesiredAngularVelocity(int n) {
        return this.desiredAngularVelocity[n];
    }

    public void update(double d, double d2, double d3) {
        super.update(d, d2, d3);
        this.actualDiffAngle += d2 * this.wheelVelocityController[0].computeRadiansPerTick();
        this.actualDiffAngle -= d3 * this.wheelVelocityController[1].computeRadiansPerTick();
        this.desiredDiffAngle += this.desiredAngularVelocityDiff * d;
    }

    public String getName() {
        return "balanced";
    }
}

