/*
 * Decompiled with CFR 0.152.
 */
package MotorControlSolution;

import MotorControlSolution.VelocityController;
import MotorControlSolution.WheelVelocityController;

public class RobotVelocityController
extends VelocityController {
    protected WheelVelocityController[] wheelVelocityController = new WheelVelocityController[2];

    public RobotVelocityController(WheelVelocityController wheelVelocityController, WheelVelocityController wheelVelocityController2) {
        this.wheelVelocityController[0] = wheelVelocityController;
        this.wheelVelocityController[1] = wheelVelocityController2;
    }

    public WheelVelocityController getWheelVelocityController(int n) {
        return this.wheelVelocityController[n];
    }

    public void controlStep(double[] dArray) {
        dArray[0] = this.wheelVelocityController[0].controlStep();
        dArray[1] = -this.wheelVelocityController[1].controlStep();
    }

    public void setDesiredAngularVelocity(double d, double d2) {
        this.wheelVelocityController[0].setDesiredAngularVelocity(d);
        this.wheelVelocityController[1].setDesiredAngularVelocity(-d2);
    }

    public void setDesiredAngularVelocity(int n, double d) {
        this.wheelVelocityController[n].setDesiredAngularVelocity(d * (n == 1 ? -1.0 : 1.0));
    }

    public double getDesiredAngularVelocity(int n) {
        return this.wheelVelocityController[n].getDesiredAngularVelocity() * (n == 1 ? -1.0 : 1.0);
    }

    public double computeAngularVelocity(int n) {
        return this.wheelVelocityController[n].computeAngularVelocity() * (n == 1 ? -1.0 : 1.0);
    }

    public void update(double d, double d2, double d3) {
        super.update(d);
        this.wheelVelocityController[0].update(d, d2);
        this.wheelVelocityController[1].update(d, -d3);
    }

    public String getName() {
        return "pass-through";
    }
}

