/*
 * Decompiled with CFR 0.152.
 */
package MotorControlSolution;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RobotGraph
extends JFrame
implements Observer {
    private static final long serialVersionUID = -1299466487663318439L;
    private int[] prev_ticks;
    private static final double WHEEL_METERS_PER_TICK = 1.19908E-5;
    private static final double WHEELBASE = 0.428;
    private double[] pose = new double[]{0.0, 0.0, 0.0};
    private List<double[]> poseHistory = new ArrayList<double[]>();
    private PaintablePanel p;
    private static final int FRAME_HEIGHT = 500;
    private static final int FRAME_WIDTH = 500;
    private static final double MAG_INCREMENT_PER_MOUSE_WHEEL_NOTCH = 1.05;
    private static final double X_MAX_INITIAL = 4.0;
    private static final double X_MIN_INITIAL = -4.0;
    private static final double Y_MAX_INITIAL = 4.0;
    private static final double Y_MIN_INITIAL = -4.0;
    private double total_mag = 1.0;
    private double x_step = 1.0;
    private double y_step = 1.0;
    private double x_max = 4.0;
    private double x_min = -4.0;
    private double y_max = 4.0;
    private double y_min = -4.0;
    private MyMouseListener ml = new MyMouseListener();
    public static final double BODY_WIDTH = 0.38;
    public static final double BODY_LENGTH = 0.38;
    public static final double WHEEL_WIDTH = 0.02;
    public static final double WHEEL_LENGTH = 0.12;
    public static final double WHEEL_DISPLACEMENT = 0.21;
    public static final double BODY_DISPLACEMENT = -0.09;
    public static final Shape WHEEL_SHAPE = new RoundRectangle2D.Double(-0.06, -0.01, 0.12, 0.02, 0.005, 0.005);
    public static final Shape BODY_SHAPE = new Rectangle2D.Double(-0.19, -0.19, 0.38, 0.38);
    public static final GeneralPath ROBOT_SHAPE = new GeneralPath();

    public RobotGraph() {
        this.setPreferredSize(new Dimension(501, 532));
        this.setWidgets();
        this.poseHistory.add(new double[]{0.0, 0.0, 0.0});
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    private void setWidgets() {
        this.p = new PaintablePanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.p, "Center");
        this.setContentPane(jPanel);
        this.addMouseWheelListener(this.ml);
        this.addMouseListener(this.ml);
        this.addMouseMotionListener(this.ml);
        this.addKeyListener(this.ml);
    }

    public void update(int[] nArray) {
        if (this.prev_ticks == null && nArray[0] == 0 && nArray[1] == 0) {
            this.prev_ticks = nArray;
        } else if (this.prev_ticks == null) {
            return;
        }
        if (nArray[0] == 0 && nArray[1] == 0) {
            return;
        }
        double d = (double)nArray[0] * 1.19908E-5;
        double d2 = (double)nArray[1] * 1.19908E-5;
        double d3 = (d - d2) / 0.428;
        this.pose[2] = this.pose[2] + -d3;
        this.pose[0] = this.pose[0] + (d + d2) * Math.cos(this.pose[2]) / 2.0;
        this.pose[1] = this.pose[1] + (d + d2) * Math.sin(this.pose[2]) / 2.0;
        this.poseHistory.add(new double[]{this.pose[0], this.pose[1], this.pose[2]});
        this.prev_ticks[0] = nArray[0];
        this.prev_ticks[1] = nArray[1];
        this.repaint();
    }

    public void update(Observable observable, Object object) {
        int[] nArray = (int[])object;
        this.update(nArray);
    }

    public static void main(String[] stringArray) {
        RobotGraph robotGraph = new RobotGraph();
        robotGraph.setPreferredSize(new Dimension(501, 532));
        robotGraph.setResizable(false);
        robotGraph.setDefaultCloseOperation(3);
        robotGraph.pack();
        robotGraph.setVisible(true);
    }

    static {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToIdentity();
        affineTransform.translate(-0.09, 0.0);
        ROBOT_SHAPE.append(affineTransform.createTransformedShape(BODY_SHAPE), false);
        affineTransform.setToIdentity();
        affineTransform.translate(0.0, 0.21);
        ROBOT_SHAPE.append(affineTransform.createTransformedShape(WHEEL_SHAPE), false);
        affineTransform.setToIdentity();
        affineTransform.translate(0.0, -0.21);
        ROBOT_SHAPE.append(affineTransform.createTransformedShape(WHEEL_SHAPE), false);
        ROBOT_SHAPE.append(new Line2D.Double(0.0, 0.0, 0.01, 0.0), false);
        ROBOT_SHAPE.append(new Line2D.Double(0.0, 0.0, 0.0, 0.01), false);
    }

    public class PaintablePanel
    extends JPanel {
        private static final long serialVersionUID = 6617333561144522727L;

        public PaintablePanel() {
            super(true);
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setColor(Color.black);
            double d = 500.0 / (RobotGraph.this.x_max - RobotGraph.this.x_min);
            double d2 = 500.0 / (RobotGraph.this.y_max - RobotGraph.this.y_min);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(250.0 - (RobotGraph.this.x_min + RobotGraph.this.x_max) / 2.0 * d, -250.0 - (RobotGraph.this.y_min + RobotGraph.this.y_max) / 2.0 * d2);
            affineTransform.scale(d, d2);
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(new BasicStroke((float)(1.0 * (RobotGraph.this.x_max - RobotGraph.this.x_min) / (500.0 * RobotGraph.this.total_mag))));
            int n = RobotGraph.this.poseHistory.size() - 2;
            if (n >= 0) {
                this.paintPosition(((double[])RobotGraph.this.poseHistory.get(n))[0], ((double[])RobotGraph.this.poseHistory.get(n))[1], ((double[])RobotGraph.this.poseHistory.get(n))[2], graphics2D, true);
            }
            this.drawGrid(graphics2D);
            this.drawAxes(graphics2D);
            this.paintRobotHistory(graphics2D);
            this.paintPosition(RobotGraph.this.pose[0], RobotGraph.this.pose[1], RobotGraph.this.pose[2], graphics2D, false);
        }

        private void paintRobotHistory(Graphics2D graphics2D) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.orange);
            for (int i = 0; i < RobotGraph.this.poseHistory.size(); ++i) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(((double[])RobotGraph.this.poseHistory.get(i))[0] - 0.01, ((double[])RobotGraph.this.poseHistory.get(i))[1] - 0.01, 0.02, 0.02);
                graphics2D.fill(double_);
            }
            graphics2D.setColor(color);
        }

        private void paintPosition(double d, double d2, double d3, Graphics2D graphics2D, boolean bl) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToIdentity();
            affineTransform.translate(d, d2);
            affineTransform.rotate(d3);
            Color color = graphics2D.getColor();
            if (bl) {
                graphics2D.setColor(new Color(238, 238, 238));
                double d4 = ROBOT_SHAPE.getBounds2D().getWidth();
                double d5 = ROBOT_SHAPE.getBounds2D().getHeight();
                Rectangle2D.Double double_ = new Rectangle2D.Double(d - d4, d2 - d5, ROBOT_SHAPE.getBounds2D().getWidth() * 2.0, ROBOT_SHAPE.getBounds2D().getHeight() * 2.0);
                graphics2D.fill(double_);
            } else {
                graphics2D.draw(affineTransform.createTransformedShape(ROBOT_SHAPE));
            }
            graphics2D.setColor(color);
        }

        private void drawGrid(Graphics2D graphics2D) {
            double d;
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.GREEN);
            for (d = RobotGraph.this.x_min - 2.0 * RobotGraph.this.x_step; d <= RobotGraph.this.x_max + 2.0 * RobotGraph.this.x_step; d += RobotGraph.this.x_step) {
                graphics2D.drawLine((int)Math.round(d), (int)Math.round(RobotGraph.this.y_min - 2.0 * RobotGraph.this.y_step), (int)Math.round(d), (int)Math.round(RobotGraph.this.y_max + 2.0 * RobotGraph.this.y_step));
            }
            for (d = RobotGraph.this.y_min - 2.0 * RobotGraph.this.y_step; d <= RobotGraph.this.y_max + 2.0 * RobotGraph.this.y_step; d += RobotGraph.this.y_step) {
                graphics2D.drawLine((int)Math.round(RobotGraph.this.x_min - 2.0 * RobotGraph.this.x_step), (int)Math.round(d), (int)Math.round(RobotGraph.this.x_max + 2.0 * RobotGraph.this.x_step), (int)Math.round(d));
            }
            graphics2D.setColor(color);
        }

        private void drawAxes(Graphics2D graphics2D) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine((int)Math.round(RobotGraph.this.x_min - 2.0 * RobotGraph.this.x_step), Math.round(0.0f), (int)Math.round(RobotGraph.this.x_max + 2.0 * RobotGraph.this.x_step), Math.round(0.0f));
            graphics2D.drawLine(Math.round(0.0f), (int)Math.round(RobotGraph.this.y_min - 2.0 * RobotGraph.this.y_step), Math.round(0.0f), (int)Math.round(RobotGraph.this.y_max + 2.0 * RobotGraph.this.y_step));
            graphics2D.setColor(color);
        }
    }

    private class MyMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    KeyListener {
        private int[] start_drag = new int[2];

        private MyMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.start_drag[0] = mouseEvent.getX();
            this.start_drag[1] = mouseEvent.getY();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - this.start_drag[0];
            int n2 = mouseEvent.getY() - this.start_drag[1];
            double d = (double)(-n) / 500.0 * (RobotGraph.this.x_max - RobotGraph.this.x_min);
            RobotGraph.this.x_min += d;
            RobotGraph.this.x_max += d;
            double d2 = (double)n2 / 500.0 * (RobotGraph.this.y_max - RobotGraph.this.y_min);
            RobotGraph.this.y_min += d2;
            RobotGraph.this.y_max += d2;
            this.start_drag[0] = mouseEvent.getX();
            this.start_drag[1] = mouseEvent.getY();
            RobotGraph.this.repaint();
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            if (n < 0) {
                RobotGraph.this.total_mag /= 1.05;
                RobotGraph.this.x_max /= 1.05;
                RobotGraph.this.x_min /= 1.05;
                RobotGraph.this.y_max /= 1.05;
                RobotGraph.this.y_min /= 1.05;
            } else {
                RobotGraph.this.total_mag *= 1.05;
                RobotGraph.this.x_max *= 1.05;
                RobotGraph.this.x_min *= 1.05;
                RobotGraph.this.y_max *= 1.05;
                RobotGraph.this.y_min *= 1.05;
            }
            RobotGraph.this.repaint();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown()) {
                switch (keyEvent.getKeyCode()) {
                    case 40: {
                        RobotGraph.this.total_mag *= 1.05;
                        RobotGraph.this.x_max *= 1.05;
                        RobotGraph.this.x_min *= 1.05;
                        RobotGraph.this.y_max *= 1.05;
                        RobotGraph.this.y_min *= 1.05;
                        break;
                    }
                    case 38: {
                        RobotGraph.this.total_mag /= 1.05;
                        RobotGraph.this.x_max /= 1.05;
                        RobotGraph.this.x_min /= 1.05;
                        RobotGraph.this.y_max /= 1.05;
                        RobotGraph.this.y_min /= 1.05;
                    }
                }
            } else {
                double d = 0.0;
                double d2 = 0.0;
                switch (keyEvent.getKeyCode()) {
                    case 39: {
                        d = -0.025 * (RobotGraph.this.x_max - RobotGraph.this.x_min);
                        break;
                    }
                    case 40: {
                        d2 = 0.025 * (RobotGraph.this.y_max - RobotGraph.this.y_min);
                        break;
                    }
                    case 37: {
                        d = 0.025 * (RobotGraph.this.x_max - RobotGraph.this.x_min);
                        break;
                    }
                    case 38: {
                        d2 = -0.025 * (RobotGraph.this.y_max - RobotGraph.this.y_min);
                    }
                }
                RobotGraph.this.x_max += d;
                RobotGraph.this.x_min += d;
                RobotGraph.this.y_max += d2;
                RobotGraph.this.y_min += d2;
            }
            RobotGraph.this.repaint();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

