
(require (lib "load.ss" "slibinit"))
(require 'macro)
(require 'sort)
(require (lib "graphics.ss" "graphics"))

;;; For DrScheme
;;;---------------------------------------------------------------
;;; graphics

(define *window* #f)			; display window
(define *window-width* 500)		; pixels
(define *window-height* 500)		; pixels

(define *color* (make-rgb 0 0 0))
(define *draw-line* #f)

(define (open-window)
  (open-graphics)
  (if (not *window*)
      (set! *window* (open-viewport "6.034" *window-width* *window-height*)))
  (if (not *draw-line*)
      (set! *draw-line* (draw-line *window*)))
  *window*
  )

(define (clear-window)
  ((clear-viewport *window*))
  (set! *color* (make-rgb 0 0 0)))

(define (draw-line x1 y1 x2 y2)
  (*draw-line* (make-posn x1 y1) (make-posn x2 y2) *color*))

(define (set-color color-values)
  (set! *color* (make-rgb (first color-values) (second color-values) (third color-values))))

(define (scale-x x) (* (/ *window-width* *display-size*) x))
;; The y axis on DrScheme points down, so reverse it.
(define (scale-y y) (- *window-height* (* (/ *window-height* *display-size*) y)))

;;;---------------------------------------------------------------

;;; making DrScheme more mit scheme compatible...

(require 'hash-table)
(define (hash-table/get hashtab key default)
  (or ((hash-inquirer equal?) hashtab key) default))
(define hash-table/put! (hash-associator equal?))
(define hash-table/remove! (hash-remover equal?))
(define (make-equal-hash-table . size)
  (if (null? size) (make-hash-table 1009) (make-hash-table (car size))))
(define (make-eq-hash-table . size)
  (if (null? size) (make-hash-table 1009) (make-hash-table (car size))))

(require 'priority-queue)

;;; wt-tree supports lookup and delete operations 

(define (make-wt-tree-type fun)
  (lambda (x y) (not (fun (car x) (car y)))))

(define (make-wt-tree fun)		; scm does max
  (make-heap fun))

(define (wt-tree/empty? wt)
  (= 0 (heap-length wt)))

(define (wt-tree/delete-min! wt)
  (heap-extract-max! wt))

(define (wt-tree/min-datum wt)
  (let ((max (heap-extract-max! wt)))
    (heap-insert! wt max)
    (cdr max)))

(define (wt-tree/add! wt key datum)
  (heap-insert! wt (cons key datum)))

(define (wt-tree/size wt) 
  (heap-length wt))

(define (wt-tree/delete wt key)
  ;; not implemented...
  (error "wt-tree/delete is not implemented in scm"))

(define-macro (define-structure name-info . components)
  `(define-struct ,(car name-info) ,components))

(define first car)
(define rest cdr)
(define second cadr)
(define third caddr)
(define fourth cadddr)

(define-macro (declare . args) 
  `(display ',args))

(define-macro (define-integrable . args)
  `(define ,@args))

(define (load-option x) x)

(define (there-exists? l fn)
  (if (null? l)
      #f
      (or (fn (car l))
          (there-exists? (cdr l) fn))))

(define (for-all? l fn)
  (if (null? l)
      #t
      (and (fn (car l))
           (for-all? (cdr l) fn))))

;;; Procedures common in 6.001                                                                                 
(define inc (lambda (x) (+ x 1)))
(define dec (lambda (x) (- x 1)))

(define filter
  (lambda (pred sequence)
    (cond ((null? sequence) '())
          ((pred (car sequence))
           (cons (car sequence)
                 (filter pred (cdr sequence))))
          (else (filter pred (cdr sequence))))))

(define (list-transform-positive l pred)
  (filter pred l))

(define (list-transform-negative l pred)
  (filter (lambda (x) (not (pred x))) l))

(define leaf? (lambda (x) (not (list? x))))

(define accumulate
  (lambda (init op lst)
    (if (null? lst)
        init
        (op (car lst) (accumulate init op (cdr lst))))))

(define (reduce op init lst)
  (accumulate init op lst))

(define map-tree
  (lambda (op tree)
    (if (leaf? tree)
        (op tree)
        (map (lambda (subtree) (map-tree op subtree))
             tree))))

(define accumulate-tree
  (lambda (init op tree)
    (if (leaf? tree)
        tree
        (accumulate init op
                    (map (lambda (subtree)
                           (accumulate-tree init op subtree))
                         tree)))))
(define (sublist l start end)
  (define (loop x i)
    (cond ((null? x) '())
          ((and (>= i start) (< i end))
           (cons (car x)
                 (loop (cdr x) (+ i 1))))
          ((< i end)
           (loop (cdr x) (+ i 1)))
          (else '())
          ))
  (if (>= end start)
      (loop l 0)
      (error "Sublist, end is before start")))

(define (list-head l k) (sublist l 0 k))

(define (list-tail l k)
  (cond ((null? l) '())
        ((<= k 0) l)
        (else (list-tail (cdr l) (- k 1)))))

(define (list-search-positive lst pred)
  (cond ((null? lst) #f)
        ((pred (car lst)) (car lst))
        (else (list-search-positive (cdr lst) pred))))

(define (delete-loop elt l compare)
  (cond ((null? l) '())
        ((compare elt (car l))
         (delete-loop elt (cdr l) compare))
        (else
         (cons (car l)
               (delete-loop elt (cdr l) compare)))))

(define (delete e l) (delete-loop e l equal?))
(define (delq e l) (delete-loop e l eq?))
(define (delv e l) (delete-loop e l eqv?))

;;;  Purpose:      Remove duplicates in a list.
;;;  Sample argument: (a b c b d)
;;;  Sample value:    (a b c d)

(define (remove-duplicates l)
  (cond ((null? l) '())
        ((member (first l) (rest l)) (remove-duplicates (rest l)))
        (else (cons (first l) (remove-duplicates (rest l))))))

;;;  Purpose:      Counts the number of times an expression appears in a list.
;;;  Sample argument: (a b c b a)
;;;  Sample value:    2                                                                                
(define (count x l)
  (let ((n 0))
    (for-each (lambda (e) (if (equal? e x) (set! n (+ 1 n))))
              l)
    n))

(define (vector-map procedure vec)
  (list->vector (map procedure (vector->list vec))))

(define (vector-first v)
  (vector-ref v 0))

(define (vector-second v)
  (vector-ref v 1))

(define (vector-third v)
  (vector-ref v 2))

(define (vector-fourth v)
  (vector-ref v 3))

(define (vector-tail v s)
  (list->vector (list-tail (vector->list v) s)))

(define (vector-head v e)
  (list->vector (list-head (vector->list v) e)))

(define (subvector v s e)
  (list->vector (sublist (vector->list v) s e)))

(define (vector-binary-search v key-cmp unwrap k)
  (list-search-positive (vector->list v)
    (lambda (x) (equal? k (unwrap x)))))
