/*
 * Decompiled with CFR 0.152.
 */
package app;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;

public class Midi {
    static int[] scale = new int[]{60, 62, 64, 65, 67, 69, 71, 72, 74, 76, 77, 79, 81, 83, 84};
    static MidiChannel channel;
    static Synthesizer synthesizer;
    static int velocity;
    static int duration;

    public static void init() {
        try {
            synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        Midi.setChannelRegular();
    }

    public static void setChannelPercussion() {
        channel = synthesizer.getChannels()[9];
    }

    public static void setChannelRegular() {
        channel = synthesizer.getChannels()[5];
    }

    public static void setChannel(int c) {
        channel = synthesizer.getChannels()[c];
    }

    public static void play(int note, int duration) {
        channel.noteOn(note, velocity);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        channel.noteOff(note);
    }

    public static void play(int note) {
        Midi.play(note, duration);
    }

    public static void play(Note note) {
        Midi.play(scale[note.ordinal()]);
    }

    public static void play(char note) {
        int i = note - 49;
        if (i >= 0 && i < scale.length) {
            Midi.play(scale[i]);
        }
    }

    static {
        velocity = 100;
        duration = 200;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Note {
        c,
        d,
        e,
        f,
        g,
        a,
        b,
        c2,
        d2,
        e2,
        f2,
        g2,
        a2,
        b2,
        c3;

    }
}

