/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.Midi;
import app.MusicMachine;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class MusicWindow
extends JFrame {
    public MusicWindow() {
        super("Music Window");
        this.setup();
    }

    public void setup() {
        Midi.init();
        final MusicMachine m1 = new MusicMachine();
        final MusicMachine m2 = new MusicMachine();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                char key = (char)e.getKeyCode();
                if (key == 'P') {
                    m1.playKeyPressed();
                    m2.playKeyPressed();
                } else if (key == 'R') {
                    m1.recordKeyPressed();
                    m2.recordKeyPressed();
                } else {
                    m1.noteKeyPressed(key);
                    m2.noteKeyPressed(MusicWindow.octave(key));
                }
            }
        });
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent e) {
                m1.mouseClicked();
                m2.mouseClicked();
            }
        });
        this.setPreferredSize(new Dimension(300, 200));
        this.setDefaultCloseOperation(3);
        String versNum = this.getVersionNumber();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        JLabel textLabel = new JLabel("Version: " + versNum);
        textLabel.setAlignmentX(0.5f);
        contentPane.add(Box.createRigidArea(new Dimension(0, 5)));
        contentPane.add(textLabel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 15)));
        JLabel nLab = new JLabel("Press numbered keys to play notes.");
        nLab.setAlignmentX(0.5f);
        contentPane.add(nLab);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel mouseLab1 = new JLabel("Click mouse to toggle between");
        JLabel mouseLab2 = new JLabel("regular and percussion mode.");
        mouseLab1.setAlignmentX(0.5f);
        mouseLab2.setAlignmentX(0.5f);
        contentPane.add(mouseLab1);
        contentPane.add(mouseLab2);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel rLab = new JLabel("Press 'r' to start/stop recording.");
        rLab.setAlignmentX(0.5f);
        contentPane.add(rLab);
        contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel pLab = new JLabel("Press 'p' to play recording.");
        pLab.setAlignmentX(0.5f);
        contentPane.add(pLab);
        this.add(contentPane);
    }

    private String getVersionNumber() {
        try {
            URL url = this.getClass().getResource(".txt");
            String classFileName = this.getClass().getSimpleName() + ".class";
            String packageName = this.getClass().getPackage().getName();
            String pathToThisClass = this.getClass().getResource(classFileName).toString();
            String pathToManifest = pathToThisClass.substring(0, pathToThisClass.length() - classFileName.length() - 1 - packageName.length() - 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(pathToManifest).openStream());
            Attributes attribs = manifest.getMainAttributes();
            return attribs.getValue("Version-Number");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Cannot determine version number";
        }
    }

    public static char octave(char key) {
        return (char)(key + 7);
    }
}

