#include <stdio.h>
#include <time.h>
#include <math.h>
#include <stdlib.h>
#include <omp.h>

#define MAX_LENGTH 1024

int main(int argc, char* argv[])
{
  double a, b, l;
  long numTrials;

  char fileName[MAX_LENGTH];

  FILE* outfile;
  double startTime;
  double elapsedTime;
 

  double PI = 0.0;

  // Fragment to process the command line parameters
  if (argc < 6){
    fprintf(stderr,"%s a b l numTrials outputFileName\n", argv[0]);
    exit(-1);
  }
     
  a = atof(argv[1]);
  b = atof(argv[2]);
  l = atof(argv[3]);
  numTrials = atol(argv[4]);
  sprintf(fileName, "%s.out",argv[5]);
    
 
  startTime = omp_get_wtime();

  //
  // TODO: Estimate PI here
  //

  elapsedTime = omp_get_wtime() - startTime;

  outfile = fopen(fileName, "a+");
  fprintf(outfile, "\n\na = %3.1f\tb = %f\tl = %3.1f\tnumTrials = %10d\tEstimate  = %2.16f\tError = %2.5f\tElapsed Time = %0.6f\n",a,b,l,numTrials,PI,fabs((PI-M_PI))/M_PI*100.0, elapsedTime);    
  fflush(outfile);
  fclose(outfile);
}
