#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "mpi.h"

#ifndef MAX
#define MAX(a,b) ((a > b) ? a : b)
#endif

#define MAX_LENGTH 1024
#define MAX_PROCS 128

int main(int argc, char* argv[])
{
  double a, b, l;
  long numTrials;

  char fileName[MAX_LENGTH];

  FILE* outFile;
  unsigned int myRank, numProcs;

  double tStart, tFinish;

  //
  // TODO: Write code here to initialize MPI
  //

  // Fragment to process the command line parameters
  if(myRank == 0){
    if (argc < 6){
      fprintf(stderr,"%s a b l numTrials outputFileName\n", argv[0]);
      MPI_Finalize();
      exit(-1);
    }
    
    a = atof(argv[1]);
    b = atof(argv[2]);
    l = atof(argv[3]);
    numTrials = atol(argv[4]);

    if (a <=0 ||  b <= 0 || l <=0 || l >= MAX(a,b)){
      MPI_Finalize();
      fprintf(stderr,"Invalid input\n");
      exit(-1);
    }

    sprintf(fileName, "%s.out",argv[5]);
  }
  
  //
  // TODO: Transmit data to other processors
  //

  tStart = MPI_Wtime();
  
  // 
  // TODO: Perform the embarrasingly parallel steps here
  //

  tFinish = MPI_Wtime();


  //
  // TODO: Aggregate the data at the root node and compute the estimate for PI
  //

  // Output timing data and 
  // Echo back and input parameters and the estimate for PI

  if(myRank == 0){
    int i = 0;

    outFile = fopen(fileName,"w+");

    fprintf(outFile, "Number of processors: %d\n", numProcs);

    fprintf(outFile, "Elapsed time: %0.6f seconds\n", tFinish - tStart);

    fprintf(outFile, "\n\na = %3.1f\tb = %f\tl = %3.1f\tnumTrials = %10d\tEstimate = %2.16f\tError = %2.5f\n",a,b,l,numTrials,PI,fabs((PI-M_PI))/M_PI*100.0);    
    fflush(outFile);
    fclose(outFile);

  }	       
  
  MPI_Finalize();
  exit(0);
}
