function z=buffon(a,b,l, trials)
 
%% Embarassingly Parallel Part                    
r=rand(trials,3);
x =a*r(:,1)+l*cos(2*pi*r(:,3));  % x coord of other end of needle
y =b*r(:,2)+l*sin(2*pi*r(:,3));  % y coord of other end of needle
inside = (x >= 0) & (y>=0) & (x <= a) & (y <= b);
 
%% Collective Operation (the sum)         
buffonpi=(2*l*(a+b) - l^2)/ (a*b*(1-sum(inside)/trials));
 
%%  Front end
z=[buffonpi;pi;abs(pi-buffonpi)/pi];      
