#include "tdrender.h"
#include <GL/glu.h>
#include <iostream>
#include <math.h>

/*
**  The following two #defines are hacks to get the axis numbers' display
**  to look fine.
*/

#ifndef diff
#define diff(a,b) ((a == b) ? 0 : (a > b) ? 1 : -1)
#endif

#ifndef zaxis
#define zaxis(a,b) ((a < b) ? 1.5 : 0.8)
#endif

#ifndef DEG_TO_RAD
#define DEG_TO_RAD(a) (a * M_PI / 180)
#endif

TDRender::TDRender(int w, int h, int rank, double *data, int nrows, 
		       int ncols, DistLayout *data_layout, double angleX, 
		       double angleZ, double camera_zoom) : 
  Render(w, h, rank, data, 0, 0, nrows, ncols, data_layout, false) {

  axes_length = axes_length * (1 + (int) camera_zoom);
  rotZ = angleZ;
  rotX = angleX;

}

void TDRender::axes3D(int x1, int y1, int z1,
			int x2, int y2, int z2,
			int x3, int y3, int z3,
			bool ticks, bool numbers, int last_tick, 
			int first_tick) {

  line(x1, y1, z1, x2, y2, z2);
  if (ticks || numbers)
    ticks3D(x1, y1, z1, x2, y2, z2, x3, y3, z3, ticks, numbers, last_tick, 
	    first_tick);
}

void TDRender::ticks3D(int x1, int y1, int z1,
			 int x2, int y2, int z2,
			 int x3, int y3, int z3,
			 bool ticks, bool numbers, int last_tick, 
			 int first_tick) {

  int line_length = max(max(x2 - x1, y2 - y1), z2 - z1);

  int tick_distance = min(MIN_TICK_DISTANCE, line_length);

  // Find out how many ticks we can have
  int num_ticks = line_length / tick_distance;
  
  int gap = (line_length % tick_distance) * 
    (last_tick - first_tick) / line_length;

  double stride = (double) (last_tick - first_tick - gap) / (double) num_ticks;

  glLineStipple(1, 0x0F0F);

  if (first_tick == last_tick) {
    // hack when the matrix data is flat
    last_tick = first_tick + 1;
    stride = 1;
    tick_distance = axes_length;
  }

  for (double i = first_tick; i <= (int) last_tick; i += stride) {
    double offset = ((i - first_tick) / stride) * tick_distance;
    if (ticks) {
      glEnable(GL_LINE_STIPPLE);
      line(x1 + diff(x2,x1) * offset,
	   y1 + diff(y2,y1) * offset,
	   z1 + diff(z2,z1) * offset,
	   x3 + diff(x2,x1) * offset,
	   y3 + diff(y2,y1) * offset,
	   z3 + diff(z2,z1) * offset);
      glDisable(GL_LINE_STIPPLE);
    }
    
    if (numbers) {
      double x_diff = x1 + diff(x2,x1) * offset - diff(x3,x1) * 10;
      double y_diff = y1 + diff(y2,y1) * offset - diff(y3,y1) * 10;
      double z_diff = z1 + diff(z2,z1) * offset - diff(z3,z1) * 10;
      line (x_diff, y_diff, z_diff, 
	    x1 + diff(x2,x1) * offset, 
	    y1 + diff(y2,y1) * offset,
	    z1 + diff(z2,z1) * offset);
      glPushMatrix();
      glTranslated(x1 + diff(x2,x1) * offset - diff(x3,x1) * 15,
		   y1 + diff(y2,y1) * offset - diff(y3,y1) * zaxis(y3,y1) * 15,
		   z1 + diff(z2,z1) * offset - diff(z3,z1) * 15);
      glRotated(-rotX, cos(DEG_TO_RAD(-rotZ)), sin(DEG_TO_RAD(-rotZ)), 0);
      glRotated(-rotZ, 0, 0, 1);
      num((int) i, 0, 0, 0);
      glPopMatrix();
    }
  }
}

void TDRender::coordinates() {
 
  axes3D(0, 0, 0, 
	 axes_length, 0, 0, 
	 0, axes_length, 0, 
	 true, true, nr + 1);
  axes3D(0, 0, 0, 
	 0, axes_length, 0, 
	 axes_length, 0, 0, 
	 true, true, nc + 1);
  axes3D(axes_length, 0, 0, 
	 axes_length, axes_length, 0, 
	 axes_length, 0, axes_length, 
	 true, false, nc + 1);
  axes3D(0, axes_length, 0, 
	 axes_length, axes_length, 0, 
	 0, axes_length, axes_length, true, false, nr + 1);
  axes3D(0, axes_length, 0, 
	 0, axes_length, axes_length, 
	 0, 0, 0, 
	 false, true, (int) maxZ, (int) minZ);
  axes3D(axes_length, 0, 0, 
	 axes_length, 0, axes_length, 
	 axes_length, axes_length, 0, 
	 true, false, (int) maxZ, (int) minZ);
  axes3D(axes_length, axes_length, 0, 
	 axes_length, axes_length, axes_length, 
	 0, axes_length, 0, 
	 true, false, (int) maxZ, (int) minZ);
  axes3D(axes_length, 0, axes_length, 
	 axes_length, axes_length, axes_length, 
	 0, 0, 0, 
	 false, false, 0);
  axes3D(0, axes_length, axes_length, 
	 axes_length, axes_length, axes_length, 
	 0, 0, 0, 
	 false, false, 0);
}

void TDRender::coordinatesGL() {

  perspective();

}

void TDRender::dataGL() {

  if (r != DISPLAY_NODE) {
    perspective();
  }

}

void TDRender::perspective() {

  glViewport(0, 0, width, height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-width/2, width/2, -height/2, height/2, 
	  -axes_length, 6 * axes_length);

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  gluLookAt(0., axes_length/2, axes_length, 0., 0., 0., 0., 1., 0.);

  glEnable (GL_NORMALIZE);
  glEnable (GL_DEPTH_TEST);

  glDisable(GL_CULL_FACE);
  
  glRotated(-90, 1, 0, 0);
  glRotated(rotZ, 0, 0, 1);
  glRotated(rotX, cos(DEG_TO_RAD(-rotZ)), sin(DEG_TO_RAD(-rotZ)), 0);

  glTranslated(-axes_length/2, -axes_length/2, -axes_length/2);

  glLineWidth(AXES_WIDTH);
  glColor3ub(BLACK, 0, 0);

}
