#include "surfrender.h"
#include <GL/glu.h>
#include <iostream>
#include <math.h>

SurfRender::SurfRender(int w, int h, int rank, double *data, int nrows, 
		       int ncols, DistLayout *data_layout, double angleX, 
		       double angleZ, double camera_zoom) : 
  TDRender(w, h, rank, data, nrows, ncols, data_layout, 
	   angleX, angleZ, camera_zoom) {

}

bool SurfRender::draw_help(int offset) {

  offset = offset * 6;

  lx = blocks_data[offset + 0];
  ly = blocks_data[offset + 1];
  data_nr = blocks_data[offset + 2] - lx + 1;
  data_nc = blocks_data[offset + 3] - ly + 1;

  if (data_nr <= 1 &&
      data_nc <= 1)
    return true;

  int rOffset = blocks_data[offset + 4];
  int cOffset = blocks_data[offset + 5];

  glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

  draw_surface(rOffset, cOffset);

  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
  glEnable(GL_POLYGON_OFFSET_FILL);
  glPolygonOffset(1.0, 1.0);
  glColor3ub(9, 0, 0);
  draw_surface(rOffset, cOffset);
  glDisable(GL_POLYGON_OFFSET_FILL);

  return false;
 
}

void SurfRender::draw_surface(int rOffset, int cOffset) {
    
  double x_const = (double) axes_length / (double) (nc + 1);
  double y_const = (double) axes_length / (double) (nr + 1);
  double z_interval = maxZ - minZ;
  double z_const;
  if (z_interval != 0) 
    z_const = 0.8 * (double) axes_length / z_interval;
  else 
    z_const = 0.;

  double color_offset = (NUM_COLORS - 1)/ z_interval;
  double z1, z2, z3, z4;
  int row, col, color_index;

  for(int j = 0; j < data_nc - 1; j++)
  {
    glBegin(GL_QUAD_STRIP);
      for(int i = 0; i < data_nr - 1; i++) 
	{
	  row = i + rOffset;
	  col = j + cOffset;
	 
	  z1 = data_buffer[col * lRows + row];
	  z2 = data_buffer[(col + 1) * lRows + row];
	  z3 = data_buffer[col * lRows + row + 1];
	  z4 = data_buffer[(col + 1) * lRows + row + 1];
       
	  color_index = FIRST_COLOR + (int) ((z1 - minZ) * color_offset);
	  assert(color_index < FIRST_COLOR + NUM_COLORS);

	  glColor3ub(color_index, 0, 0);
	  glVertex3f((j + ly + 1) * x_const, (i + lx + 1) * y_const, 
		     (z1 - minZ) * z_const);
	  glVertex3f((j + ly + 2) * x_const, (i + lx + 1) * y_const, 
		     (z2 - minZ) * z_const);
	  glVertex3f((j + ly + 1) * x_const, (i + lx + 2) * y_const,
		     (z3 - minZ) * z_const);
	  glVertex3f((j + ly + 2) * x_const, (i + lx + 2) * y_const,
		     (z4 - minZ) * z_const);
	}
      glEnd();
  }
}
