#ifndef _RENDER_H_
#define _RENDER_H_

#include <GL/osmesa.h>
#include <assert.h>
#include "MatrixManager.h"
#include "textures.h"

const int AXES_WIDTH = 2;
const int DISPLAY_NODE = 0;
const int BLACK = 1;
const int GRAY = 2;
const int WHITE = 0;
const int FIRST_COLOR = 3;
const int NUM_COLORS = 64;
const int MIN_TICK_DISTANCE = 40;
const double MINISCULE = 1e-10;

#ifndef max
#define max(a,b) ((a < b) ? b : a)
#endif

#ifndef min
#define min(a,b) ((a < b) ? a : b)
#endif

class TDRender;
class SpyRender;

class Render {
  friend TDRender;
  friend SpyRender;

 public:
  
  Render(int w, int h, int rank, double *data, int start_row, 
	 int start_column, int nrows, int ncols, DistLayout *data_layout, 
	 bool render_spy);
  ~Render();
  
  float* draw();
  
 protected:
  bool is_spy;
  int nonzero, num_nonzeros;
  int num_blocks;
  int *blocks_data;
  int r, nr, nc, sr, sc, lx, ly, data_nr, data_nc, num_procs;
  int width, height, axes_length;
  int lCols, lRows;
  int image_info[4];
  int valid;
  int *valid_procs;
  double minZ, maxZ;
  double* data_buffer;
  void* image_buffer;
  GLfloat *depth_buffer, *send_depth;
  GLuint tex_ids[11];
  float *final_image;
  unsigned char* send_buffer;
  OSMesaContext ctx;

  void axes(double x1, double y1, double z1,
	    double x2, double y2, double z2);

 private:
  
  void collect_images();
  void line(double x1, double y1, double z1,
	    double x2, double y2, double z2);
  void num(int num, double x, double y, double z);
  void single_num(int num, double x, double y, double z);	
  void ticks(double x1, double y1, double z1, 
	     double x2, double y2, double z2);
  void ticks_help(double constant, double var1, double var2, 
		  int first_tick, int last_tick, bool x_axis);
  void perspective();
  void initTexture();
  void rectangle();
  void reshape();
  void send();

  virtual void done_drawing();
  virtual void coordinatesGL() = 0;
  virtual void dataGL() = 0;
  virtual void coordinates() = 0;
  virtual bool draw_help(int offset) = 0;
};

#endif
