/*
 * MATLAB*P visulaiztion routines. 
 * Created by Jack Holloway, Adnan Sulejmanpasic, & Oskar Bruening
 * Spring 2002 final project 6.338
 */
#include "prec.h"
#include "PPServer.h"
#include "PPPackage.h"
#include "PPLogger.h"
#include "PPArg.h"
#include "enum.h"
#include "PPUtils.h"
#include <iostream>
#include <mpi.h>
#include "spyrender.h"
#include "surfrender.h"
#include "meshrender.h"
#include "myblacs.h"


#ifdef PPSTATIC 
#include "PPInit.h"
#endif

//#define DEBUG_PPVISUAL
//#define VERBOSE

extern "C" {
  void ppsize(PPServer &, PPArgList &, PPArgList &);
  void ppspy(PPServer &, PPArgList &, PPArgList &);
  void ppsurf(PPServer &, PPArgList &, PPArgList &);
  void ppmesh(PPServer &, PPArgList &, PPArgList &);
}

int ppspy_getData(PPServer &, PPMatrixID, float *&, int, 
		  int, int, int, int, int);
void ppspy_dumpFile(int, int, int, int, DistLayout *, double *, int);
int pp3d_getData(PPServer &, PPMatrixID, float *&, int, 
		 int, double, double, double, bool);
void pp3d(PPServer &, PPArgList &, PPArgList &, bool);

/* gets the size of a matrix and returns it as a normal integer b/c
   I couldn't figure out how to do it using the layoot stuff
*/
extern "C" void
ppsize(PPServer &inServer, PPArgList &inArgs, PPArgList &outArgs)
{
  
  if (inArgs.length() != 1) {
    outArgs.addError(BADINPUTARGS, "Number of input args should be 1.");
    return;
  }
    
  PPMatrixID in = (PPMatrixID) *(inArgs[0]); // input maxtrix
  if (!(inServer.mMan)->isValidMatrix(in)) {
    outArgs.addError(BADINPUTARGS, "Invalid Matrix in arg 0");
    return;
  }
  
  outArgs.addNoError();
  if( (inServer.sCon)->isRoot())
    {
      int gRows = (inServer.mMan)->getGRows(in);//global rows
      int gCols = (inServer.mMan)->getGCols(in);//global columns
      outArgs.add(gRows);
      outArgs.add(gCols);
      return;
    }
}

extern "C" void
ppspy(PPServer &inServer, PPArgList &inArgs, PPArgList &outArgs)
{
  int ret_code, image_w, image_h, sr, sc, er, ec;
  int gRows, gCols;
  float *pixel_buffer;
  pixel_buffer = NULL;


  //pixel_buffer = new float[image_w*image_h];
  // Adnan generates this, doesn't delete it in his destructor.
  // input checking
  if (inArgs.length() != 7) {
    outArgs.addError(BADINPUTARGS, "Number of input args should be 7.");
    return;
  }

  PPMatrixID in = (PPMatrixID) *(inArgs[0]); // input maxtrix
  if (!(inServer.mMan)->isValidMatrix(in)) {
    outArgs.addError(BADINPUTARGS, "Invalid Matrix in arg 0");
    return;
  }

  gRows = (inServer.mMan)->getGRows(in);//global rows
  gCols = (inServer.mMan)->getGCols(in);//global cols

  image_h = *(inArgs[1]);
  image_w = *(inArgs[2]);
  sr = *(inArgs[3]);
  sc = *(inArgs[4]);
  er = *(inArgs[5]);
  er = er + sr - 1;
  ec = *(inArgs[6]);
  ec = ec + sc - 1;

  /*
  if(ec > gCols)
    ec = gCols;
  if(er > gRows)
    er = gRows;
  */
#ifdef DEBUG_PPVISUAL
  if( (inServer.sCon)->isRoot())
    {
      cout<<"gCols = "<<gCols<<endl;
      cout<<"gRows = "<<gRows<<endl;
      cout<<"image height = *(inArgs[1])="<<image_h<<endl;
      cout<<"image width = *(inArgs[2])="<<image_w<<endl;
      cout<<"sr = *(inArgs[3])="<<sr<<endl;
      cout<<"sc = *(inArgs[4])="<<sc<<endl;
      cout<<"er = *(inArgs[5])="<<er<<endl;
      cout<<"ec = *(inArgs[6])="<<ec<<endl;
    }
#endif

  if (image_w < 1) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 1(image HEIGHT)");
    return;
  }
  if (image_h < 1) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 2(image WIDTH)");
    return;
  }
  if (sr < 0) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 3(zoom start row)");
    return;
  }
  if (sc < 0) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 4(zoom start column)");
    return;
  }
  if (er < 1) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 5(zoom rect HEIGHT)");
    return;
  }
  if (ec < 1) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 6(zoom rect WIDTH)");
    return;
  }
  
  int myid = (inServer.sCon)->processorID();
  /* Make the important call */
  ret_code = ppspy_getData(inServer, in, pixel_buffer, image_w, image_h, 
			   sr, sc, er,ec);
  
  
  if(ret_code == -1)
    {
      outArgs.addError(BADINPUTARGS, "Data not distributed correctly.");
      return;
    }
  else if(ret_code == -2)
    {
      outArgs.addError(BADINPUTARGS, "Error finding data distribution on node.");
      return;
    }
  else if(ret_code == 0)
    {
      // should be all set
      outArgs.addNoError();
      if( (inServer.sCon)->isRoot())
	{
	  // return the pixel buffer as a column vector (rgb values for each pixel)
	  // messed up.
	  if(pixel_buffer != NULL) {
	    //cout<<"Root node here: I'm sending the pixel buffer to MATLAB.\n";
	    outArgs.add((float *)pixel_buffer,image_w*image_h*3,1);
	  }
	  else
	    cerr<<"This is BAD NEWS: Pixel buffer NULL.\n";
	  
	}      
    }
}


int ppspy_getData(PPServer &inServer, PPMatrixID in, 
		  float *&pixel_buffer, int imgwidth, int imgheight,
		  int sr, int sc, int er, int ec) {
  // get some useful information
  int nprocs = (inServer.sCon)->numProcessors();
  int lRows = (inServer.mMan)->getLRows(in);//local rows
  int lCols = (inServer.mMan)->getLCols(in);//local columns
  int lSize = (inServer.mMan)->getLSize(in);//local size
  int gRows = (inServer.mMan)->getGRows(in);//global rows
  int gCols = (inServer.mMan)->getGCols(in);//global columns
  int gSize = (inServer.mMan)->getGSize(in);//local size
  int MB = (inServer.mMan)->getMB(in);
  int NB = (inServer.mMan)->getNB(in);
  int myid = (inServer.sCon)->processorID();
  PPDistType dist = (inServer.mMan)->getDist(in);
  DistLayout *data_layout;
  int mystartrow, myendrow, mystartcolumn, myendcolumn;
  
  // Get info about the context we are using  
  data_layout = (inServer.mMan)->getDistWindows(in,nprocs, myid);
  if(data_layout == NULL) // something bad happened
    return -2;

  /*mystartrow = (inServer.mMan)->getStartRow(in,nprocs);
    mystartcolumn = (inServer.mMan)->getStartCol(in,nprocs);
    
    myendrow = mystartrow + lRows - 1;
    myendcolumn = mystartcolumn + lCols - 1;
  */
      
  // data real
  if ((inServer.mMan)->isReal(in)) {    
    ELTYPE *raw = (ELTYPE *) (inServer.mMan)->getData(in);
    
#ifdef DEBUG_PPVISUAL
    ppspy_dumpFile(gRows, gCols, lRows, lCols, data_layout, raw, myid);
#ifdef VERBOSE
    cout<<"------- ppspy: node "<<myid<<" ---------\nlRows: "<<lRows
	<<" lCols: "<<lCols<<"\ngRows: "<<gRows
	<<" gCols: "<<gCols<<endl;
#endif
#endif
    
    // send stuff to Adnan's code...
    // He'll need the current proc's rank, 
    // it's beginning and ending columns and
    // rows, the actual data array, the global size (column * row)
    
#ifdef _RENDER_H_
    
    SpyRender ppspyRenderer = SpyRender(imgwidth, imgheight, 
					myid, raw,
					sr, sc, 
					er, ec,
					data_layout);
    
    // need to get the root node to write the 
    // pixel buffer into the int *pixel_buffer buffer.
    pixel_buffer = ppspyRenderer.draw();
    if(((inServer.sCon)->isRoot()) && (pixel_buffer == NULL)) {
      cerr<<"BAD NEWS, son, this here pixel buffer ain't nothin' but NULL.\n";
    }
    
    
    
#endif
  }
  // data complex
  /*
    else {
    
    CELTYPE *raw = (CELTYPE *) (inServer.mMan)->getData(in);
    
    // we need this transposed!  because thus sath FFTW
    for (int j=0; j<lCols; j++) {
    for (int i=0; i<lRows; i++) {
    data[i*lCols+j].re = raw[j*lRows+i].real();
    data[i*lCols+j].im = raw[j*lRows+i].imag();
    }
    }
    }
  */
  
  delete data_layout;
  return 0;
}



void ppspy_dumpFile(int gRows, int gCols, int lRows, int lCols, DistLayout *data_layout, double *raw, int rank)
{
  ofstream out;
  char file_name[80];
  int rows, cols, offset, r1, c1, r2, c2, roffset, coffset;
  sprintf(file_name, "debug_matrix_%i.dat", rank);
  out.open(file_name);
  out<<"%Info for processor "<<rank<<endl;

  for(int block = 0; block < data_layout->blocks; block ++)
    {
      r1 = data_layout->block_data[block*6 + 0];
      r2 = data_layout->block_data[block*6 + 2];
      c1 = data_layout->block_data[block*6 + 1];
      c2 = data_layout->block_data[block*6 + 3];
      rows = r2 - r1 + 1;
      cols = c2 - c1 + 1;
      roffset = data_layout->block_data[block*6 + 4];
      coffset = data_layout->block_data[block*6 + 5];
      
      if(rows > 1 && cols > 1)
	{
	  cout<<"processor "<<rank<<" dumping data for it's "
	      <<block<<" block: ("<<r1<<", "<<c1<<") -> ("
	      <<r2<<", "<<c2<<") :: offset = "<<offset<<".\n";
	  out<<"%Block "<<block<<" from ("<<r1<<", "<<c1<<") to ("
	     <<r2<<", "<<c2<<")"<<endl;
	  for(int j=0; j<cols; j++)
	    {
	      for(int i = 0; i<rows; i++) 
		{
		  out<<raw[(j+coffset)*lCols+(i+roffset)]<<" ";
		}
	      out<<endl;
	    }
	}
      else
	cout<<"processor "<<rank<<" skipping dump of it's "<<block<<" block.\n";
      
    }
  out.close();
}



extern "C" void
ppmesh(PPServer &inServer, PPArgList &inArgs, PPArgList &outArgs)
{
  //cout<<"::::::::::::::::::::::::ppmesh\n";
  pp3d(inServer, inArgs, outArgs, false);
}

/* entry for matlab*p surface command */
extern "C" void
ppsurf(PPServer &inServer, PPArgList &inArgs, PPArgList &outArgs)
{
  //cout<<"::::::::::::::::::::::::ppsurf\n";
  pp3d(inServer, inArgs, outArgs, true);
}



void
pp3d(PPServer &inServer, PPArgList &inArgs, PPArgList &outArgs, bool surf)
{
  int ret_code, image_w, image_h;
  double theta, phi, zoom;
  int gRows, gCols;
  float *pixel_buffer;
  pixel_buffer = NULL;

  if (inArgs.length() != 6) {
    outArgs.addError(BADINPUTARGS, "Number of input args should be 6.");
    return;
  }

  PPMatrixID in = (PPMatrixID) *(inArgs[0]); // input maxtrix
  if (!(inServer.mMan)->isValidMatrix(in)) {
    outArgs.addError(BADINPUTARGS, "Invalid Matrix in arg 0");
    return;
  }

  gRows = (inServer.mMan)->getGRows(in);//global rows
  gCols = (inServer.mMan)->getGCols(in);//global rows

  image_w = *(inArgs[1]);
  image_h = *(inArgs[2]);
  theta = *(inArgs[3]);
  phi = *(inArgs[4]);
  zoom = *(inArgs[5]);
#ifdef DEBUG_PPVISUAL
  if( (inServer.sCon)->isRoot())
    {
      cout<<"image width = *(inArgs[1])="<<image_w<<endl;
      cout<<"image height = *(inArgs[2])="<<image_h<<endl;
      cout<<"theta = *(inArgs[3])="<<theta<<endl;
      cout<<"phi = *(inArgs[4])="<<phi<<endl;
      cout<<"zoom = *(inArgs[5])="<<zoom<<endl;
    }
#endif

  if (image_w < 1) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 1(IMAGE WIDTH)");
    return;
  }
  if (image_h < 1) {
    outArgs.addError(BADINPUTARGS, "Integer expected in arg 2(IMAGE HEIGHT)");
    return;
  }
  
  if (zoom < 0) {
    outArgs.addError(BADINPUTARGS, "POSITIVE integer expected in arg 5(ZOOM)");
    return;
  }
  /* Make the important call */
  if(surf)
    ret_code = pp3d_getData(inServer, in, pixel_buffer, image_w, image_h, 
			    theta, phi, zoom, true);
  else
    ret_code = pp3d_getData(inServer, in, pixel_buffer, image_w, image_h, 
			    theta, phi, zoom, false);
  // the last argument is tells us that we need to be doing a surface
  // rendering.
  if(ret_code == -1)
    {
      outArgs.addError(BADINPUTARGS, "Data not distributed correctly.");
      return;
    }
  else if(ret_code == -2)
    {
      outArgs.addError(BADINPUTARGS, "Error finding data distribution on node.");
      return;
    }
  else if(ret_code == 0)
    {
      // should be all set
      outArgs.addNoError();
      if( (inServer.sCon)->isRoot())
	{
	  if(pixel_buffer != NULL) {
	    //cout<<"Matlab is getting : "<<pixel_buffer<<endl;
	    outArgs.add((float *)pixel_buffer,image_w*image_h*3,1);
	  }
	  else
	    cerr<<"This is BAD NEWS: Pixel buffer NULL.\n";
	  
	}      
    }
}





int pp3d_getData(PPServer &inServer, PPMatrixID in, 
		  float *&pixel_buffer, int imgheight, int imgwidth,
		  double theta, double phi, double zoom, bool surf) {
  int nprocs = (inServer.sCon)->numProcessors();
  int lRows = (inServer.mMan)->getLRows(in);//local rows
  int lCols = (inServer.mMan)->getLCols(in);//local columns
  int lSize = (inServer.mMan)->getLSize(in);//local size
  int gRows = (inServer.mMan)->getGRows(in);//global rows
  int gCols = (inServer.mMan)->getGCols(in);//global columns
  int gSize = (inServer.mMan)->getGSize(in);//local size
  int MB = (inServer.mMan)->getMB(in);
  int NB = (inServer.mMan)->getNB(in);
  int myid = (inServer.sCon)->processorID();
  PPDistType dist = (inServer.mMan)->getDist(in);
  DistLayout *data_layout;
  int mystartrow, myendrow, mystartcolumn, myendcolumn;
  
  data_layout = (inServer.mMan)->getDistWindows(in,nprocs, myid);
  if(data_layout == NULL) // something bad happened
    return -2;

  if ((inServer.mMan)->isReal(in)) {    
    ELTYPE *raw = (ELTYPE *) (inServer.mMan)->getData(in);
    
#ifdef DEBUG_PPVISUAL
    ppspy_dumpFile(gRows, gCols, lRows, lCols, data_layout, raw, myid);
#ifdef VERBOSE
    cout<<"------- ppspy: node "<<myid<<" ---------\nlRows: "<<lRows
	<<" lCols: "<<lCols<<"\ngRows: "<<gRows
	<<" gCols: "<<gCols<<endl;
#endif
#endif
    
#ifdef _SURF_RENDER_H_
#ifdef _MESH_RENDER_H_
    if(surf) {
      SurfRender ppsurfRenderer = SurfRender(imgwidth, imgheight, 
					     myid, raw, 
					     gRows, gCols,
					     data_layout, 
					     theta, phi, zoom);
      
      pixel_buffer = ppsurfRenderer.draw();
    }
    else {
      MeshRender ppmeshRenderer = MeshRender(imgwidth, imgheight, 
					     myid, raw, 
					     gRows, gCols,
					     data_layout, 
					     theta, phi, zoom);
      
      pixel_buffer = ppmeshRenderer.draw();
    }
    if(((inServer.sCon)->isRoot()) && (pixel_buffer == NULL)) {
      cerr<<"BAD NEWS, son, this here pixel buffer ain't nothin' but NULL.\n";
    }
#endif
#endif
  }
  delete data_layout;
  return 0;
}





///////////////////////////////////
// INITIALIZATION
///////////////////////////////////



#ifndef PPSTATIC
extern "C" PPError ppinitialize(PPPackage *pack, PPLogger *Log) {
#else
extern "C" PPError PPVisual_initialize(PPPackage *pack, PPLogger *Log) {
#endif
  
  pack->addFunc("ppspy",&ppspy);
  pack->addFunc("ppsurf",&ppsurf);
  pack->addFunc("ppmesh",&ppmesh);
  pack->addFunc("ppsize",&ppsize);
  
  return NOERR;
}
  
