%
% beta parallel data spy implementation.
% USAGE: ppspy(A) spys the ddense object A
%
function ppspy(a)

[ecode,estr,mat_rows,mat_cols] = ppclient('ppsize',a);
if ecode ~= 0
 error(estr);
end; 

rows = mat_rows;
cols = mat_cols;
%scale the image size down.. we don't want it to be too big..
if(rows*cols>1024^2)
  if(rows == cols)
    rows = 1024;
    cols = 1024;
  elseif(rows > cols)
    cols = round(cols*1024/rows);
    rows = 1024;    
  elseif(cols > rows)
    rows = round(rows*1024/cols);
    cols = 1024;
  end;
else
  sprintf('Don't even bother using PPSPY at this size. Instead, I'm\nbringing the data back to this node and rendering it using tradition SPY.');
  tmp = pp2matlab(a)
  sprintf('..\n')
  spy(tmp);
end;


[ecode,estr,data] = ppclient('ppspy',a,rows,cols,0,0,mat_rows,mat_cols);
if ecode ~= 0
  error(estr);
end;

D(:,:,1) = reshape(data(1:3:cols*rows*3), cols, rows);
D(:,:,2) = reshape(data(2:3:cols*rows*3), cols, rows);
D(:,:,3) = reshape(data(3:3:cols*rows*3), cols, rows);

image(D);

return;
