function varargout = ppspy(varargin)
% PPSPY Application M-file for ppspy.fig
%    FIG = PPSPY launch ppspy GUI.
%    PPSPY('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 27-Apr-2002 13:02:31


if nargin == 1  % LAUNCH GUI
  [ecode,estr,H, W] = ppclient('ppsize',varargin{1});
  if ecode ~= 0
    error(estr);
  end

  if (H*W < 1024^2)
    spy(pp2matlab(varargin{1}));
    sprintf('Your Matrix is smaller than 1024x1024 elements.\nWe will for efficency reasons use the regular spy\n')
    return;
  end
    
    %  spy1input = varargin{1};
  fig = openfig(mfilename,'reuse');
  global SPY1PINP;
  global SPY1VARS;
  global SPY1LAST;
  global SPY1ZOOM;  
  SPY1PINP = varargin{1};
  
  % Border in pixels [top bottom left right]
  BR = [50 50 50 50];

  % SPY1VARS holds the variables for the image
  % [x1 y1, currentwidth, currentheight, zoomfactor, originalwidth, originalheight]
  %  [H W D] = size(SPY1PINP);
  

  % Get size ratios
  if ( W > H ) 
    WR = [256 512 1024];
    HR = (W/H) .* WR;
  else
    WR = [256 512 1024];
    HR = (W/H) .* WR;
  end    
  use = 2;
  S1 = sprintf('%4.fx%4.f',WR(1), HR(1));
  S2 = sprintf('%4.fx%4.f',WR(2), HR(2));
  S3 = sprintf('%4.fx%4.f',WR(3), HR(3));
  S = [S1; S2; S3];

  SPY1VARS = [0 0 W H 2 W H WR(use) HR(use) WR HR BR];
  
  % Use system color scheme for figure:
  set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));
  
  % Generate a structure of handles to pass to callbacks, and store it. 
  handles = guihandles(fig);
  set (handles.axes1, 'Color', get(fig, 'Color'));
  set (handles.listbox2, 'BackgroundColor', get(fig, 'Color'));
  set (handles.zoomaxes, 'Color', [1 1 1]);
  set (handles.listbox2, 'String', S);
  set (handles.listbox2, 'Value', use);
  
  guidata(fig, handles);
  if nargout > 0
    varargout{1} = fig;
  end

  % Load the parameter to image
  axes(handles.axes1);
    SPY1LAST = dumy(SPY1PINP, SPY1VARS(1), SPY1VARS(2), ...
	SPY1VARS(3), SPY1VARS(4), ...
	SPY1VARS(8), SPY1VARS(9));
  i = image(SPY1LAST);            % display
  j = get(get(i, 'Parent'), 'Parent');
  set(i, 'Parent', handles.axes1);
  delete(j);
  sx = (WR(use)-BR(3)-BR(4))/64;
  sy = (HR(use)-BR(1)-BR(2))/64;
  SPY1ZOOM = SPY1LAST(BR(1):sy:HR(use)-BR(2), BR(3):sx:WR(use)-BR(4), 1:3);

  
elseif nargin == 0 
  
  disp( 'Function needs one parameter');

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK%
	
  try
    if (nargout)
      [varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
    else
      feval(varargin{:}); % FEVAL switchyard
    end
  catch
    disp(lasterr);
  end
  
end




% --------------------------------------------------------------------
function varargout = File_Callback(h, eventdata, handles, varargin)
return;



% --------------------------------------------------------------------
function varargout = Save_Callback(h, eventdata, handles, varargin)
return;



% --------------------------------------------------------------------
function varargout = export_Callback(h, eventdata, handles, varargin)
global SPY1LAST;
[fname, pname] = uiputfile( {...
      '*.tif;*.tiff', 'Tagged Image File Format (TIFF)'; ...
      '*.jpg;*.jpeg', 'Joint Photographic Experts Group (JPEG)'; ...
      '*.bmp' , 'Windows Bitmap (BMP)'; ...
      '*.png' , 'Portable Network Graphics (PNG)' ; ...
      '*.hdf' , 'Hierarchical Data Format (HDF)' ; ...
      '*.pcx' , 'Windows Paintbrush (PCX)' ; ...
      '*.xwd' , 'X Window Dump (XWD)'}, ...
    'Export to ...');

if isequal(fname,0)|isequal(pname,0)
else
  full = [pname, fname];
  imwrite(SPY1LAST,full);
end
 
return;




% --------------------------------------------------------------------
function varargout = close_Callback(h, eventdata, handles, varargin)
delete(handles.figure1);
return;



% --------------------------------------------------------------------
function varargout = print_Callback(h, eventdata, handles, varargin)
printdlg;
return;



% --------------------------------------------------------------------
function varargout = zoom_Callback(h, eventdata, handles, varargin)
return;




% --------------------------------------------------------------------
function varargout = labeaxes_Callback(h, eventdata, handles, varargin)
return;




% --------------------------------------------------------------------
function varargout = rotate_Callback(h, eventdata, handles, varargin)
return;




% --------------------------------------------------------------------
function varargout = saveas_Callback(h, eventdata, handles, varargin)
return;




% --------------------------------------------------------------------
function varargout = togglebutton1_Callback(h, eventdata, handles, varargin)
% ZOOM IN
global SPY1PINP;
global SPY1LAST;
global SPY1VARS;
if (get(handles.togglebutton1, 'Value') == 1) 
  BR = SPY1VARS(16:19);
  set(handles.togglebutton2, 'Value', 0);
  [x, y] = ginput(1);
  x = x - BR(3); y = y - BR(1);
  W = SPY1VARS(8) - BR(3) - BR(4);
  H = SPY1VARS(9) - BR(1) - BR(2);
  x = (x / W) * SPY1VARS(3) + SPY1VARS(1);
  y = (y / H) * SPY1VARS(4) + SPY1VARS(2);
  W = SPY1VARS(3) / SPY1VARS(5);
  H = SPY1VARS(4) / SPY1VARS(5);
  w = W / 2;  h = H / 2;
  x = x - w;  y = y - h;
  if (x < 0) 
    x = 0;
  end
  if (x + W > SPY1VARS(6))
    x = SPY1VARS(6) - W;
  end
  if (y < 0) 
    y = 0;
  end
  if (y + H > SPY1VARS(7))
    y = SPY1VARS(7) - H;
  end
  SPY1VARS(1) = x;
  SPY1VARS(2) = y;
  SPY1VARS(3) = W;
  SPY1VARS(4) = H;

  set(handles.togglebutton1, 'Value', 0);
    SPY1LAST = dumy(SPY1PINP, SPY1VARS(1), SPY1VARS(2), ...
	SPY1VARS(3), SPY1VARS(4), ...
	SPY1VARS(8), SPY1VARS(9));
    displaynow(SPY1LAST, handles, SPY1VARS);
end
return;







% --------------------------------------------------------------------
function varargout = togglebutton2_Callback(h, eventdata, handles, varargin)
global SPY1PINP;
global SPY1LAST;
global SPY1VARS;
if (get(handles.togglebutton2, 'Value') == 1) 
  set(handles.togglebutton1, 'Value', 0);
  % USER CLICK FOR ZOOM OUT
  %  [x, y] = ginput(1);
  %  x = (x / SPY1VARS(8)) * SPY1VARS(3) + SPY1VARS(1);
  %  y = (y / SPY1VARS(9)) * SPY1VARS(4) + SPY1VARS(2);
  W = SPY1VARS(3) * SPY1VARS(5);
  H = SPY1VARS(4) * SPY1VARS(5);
  x = SPY1VARS(1);
  y = SPY1VARS(2);
  x = x + W/4;
  y = y + H/4;
  if (W > SPY1VARS(6)) 
    W = SPY1VARS(6);
  end
  if (H > SPY1VARS(7)) 
    H = SPY1VARS(7);
  end
  w = W / 2;  h = H / 2;
  x = x - w;  y = y - h;
  
  if (x < 0) 
    x = 0;
  end
  if (x + W > SPY1VARS(6))
    x = SPY1VARS(6) - W;
  end
  if (y < 0) 
    y = 0;
  end
  if (y + H > SPY1VARS(7))
    y = SPY1VARS(7) - H;
  end
  SPY1VARS(1) = x;
  SPY1VARS(2) = y;
  SPY1VARS(3) = W;
  SPY1VARS(4) = H;

  set(handles.togglebutton2, 'Value', 0);
    SPY1LAST = dumy(SPY1PINP, SPY1VARS(1), SPY1VARS(2), ...
	SPY1VARS(3), SPY1VARS(4), ...
	SPY1VARS(8), SPY1VARS(9));
  
    displaynow(SPY1LAST, handles, SPY1VARS);
 end
return;


% --------------------------------------------------------------------
function varargout = about_Callback(h, eventdata, handles, varargin)
aboutspy1surf1;
return;



% --------------------------------------------------------------------
function varargout = listbox2_Callback(h, eventdata, handles, varargin)
global SPY1PINP;
global SPY1LAST;
global SPY1VARS;
  a = get(handles.listbox2, 'Value');
  WR = SPY1VARS(10:12);
  HR = SPY1VARS(13:15);
  SPY1VARS(8) = WR(a);
  SPY1VARS(9) = HR(a);
  
    SPY1LAST = dumy(SPY1PINP, SPY1VARS(1), SPY1VARS(2), ...
	SPY1VARS(3), SPY1VARS(4), ...
	SPY1VARS(8), SPY1VARS(9));
    displaynow(SPY1LAST, handles, SPY1VARS);

return;




% --------------------------------------------------------------------
function varargout = resetbutton_Callback(h, eventdata, handles, varargin)

global SPY1PINP;
global SPY1LAST;
global SPY1VARS;
SPY1VARS(1) = 0;
SPY1VARS(2) = 0;
SPY1VARS(3) = SPY1VARS(6);
SPY1VARS(4) = SPY1VARS(7);
SPY1LAST = dumy(SPY1PINP, SPY1VARS(1), SPY1VARS(2), ...
    SPY1VARS(3), SPY1VARS(4), ...
    SPY1VARS(8), SPY1VARS(9));
displaynow(SPY1LAST, handles, SPY1VARS);

return;


% ------------------------------
% Not call-back <-- display function
% ------------------------------

function varargout = displaynow(SPY1LAST, handles, SPY1VARS)
global SPY1ZOOM
x = SPY1VARS(1);
y = SPY1VARS(2);
w = SPY1VARS(3);
h = SPY1VARS(4);
W = SPY1VARS(6);
H = SPY1VARS(7);

axes(handles.zoomaxes);
i = image(SPY1ZOOM);

set(i, 'ButtonDownFcn', ...
    'ppspy(''zoomaxes_click_Callback'',gcbo,[],guidata(gcbo))');

i = rectangle('Position', [(x/W)*63+1 (y/H)*63+1 (w/W)*64 (h/H)*64]);
set (i, 'EdgeColor', [1 0 0]);
set(i, 'ButtonDownFcn', ...
    'ppspy(''zoomaxes_click_Callback'',gcbo,[],guidata(gcbo))');

set(handles.zoomaxes, 'Visible', 'off');


axes(handles.axes1);
image(SPY1LAST);
set(handles.axes1, 'Visible', 'off');
return;



% ----------------------------------------------------------------
% Callback function for the little navigation panel on the left
% ----------------------------------------------------------------

function varargout = zoomaxes_click_Callback(h, eventdata, ...
    handles, varargin)

global SPY1VARS;
global SPY1PINP;
global SPY1LAST;

GW = SPY1VARS(6);
GH = SPY1VARS(7);
lW = SPY1VARS(3)/2;
lH = SPY1VARS(4)/2;
j = get(handles.zoomaxes, 'Parent');

set(handles.zoomaxes, 'Units', get(j, 'Units'));

P = get(j, 'CurrentPoint');
x = P(1); y = P(2);

P = get(handles.zoomaxes, 'Position');
MX = P(1); MY = P(2); MW = P(3); MH = P(4);

x = ((x-MX)/MW)*GW - lW;
y = ((MH-(y-MY+1))/MH)*GH - lH;

if (x < 0) 
  x = 0;
end
if (x + 2*lW > GW)
  x = GW - 2*lW;
end
if (y < 0) 
  y = 0;
end
if (y + 2*lH > GH)
  y = GH - 2*lH;
end
SPY1VARS(1) = x;
SPY1VARS(2) = y;

SPY1LAST = dumy(SPY1PINP, SPY1VARS(1), SPY1VARS(2), ...
    SPY1VARS(3), SPY1VARS(4), ...
    SPY1VARS(8), SPY1VARS(9));

displaynow(SPY1LAST, handles, SPY1VARS);


%x = (x / MW)*W
%x = (y / MH)*H



return;

function D = dumy(A, x, y, w, h, MW, MH)

  sc = x;
  sr = y;
  recw = w;
  rech = h;
[ecode,estr,data] = ppclient('ppspy',A,MH,MW,sr,sc,rech,recw);
if ecode ~= 0
 error(estr);
end
% get data back as a vector -- need to reshape into a MWxMW matrix.
%data = reshape(data, MW, MW);
D(:,:,1) = reshape(data(1:3:MW*MH*3), MH, MW);
D(:,:,2) = reshape(data(2:3:MW*MH*3), MH, MW);
D(:,:,3) = reshape(data(3:3:MW*MH*3), MH, MW);

%D(:,:,1) = data;
%D(:,:,2) = data;
%D(:,:,3) = dummy_color_data;
%D(:,:,2) = data(y_coords, x_coords);
%save D; % debugging measure.


%D = A(y_coords, x_coords, 1:3);
return;
