#ifndef _TD_RENDER_H_
#define _TD_RENDER_H_

#include "render.h"

class SurfRender;

class TDRender : public Render {
  friend SurfRender;
 public:
  TDRender(int w, int h, int rank, double *data, int nrows, 
	   int ncols, DistLayout *data_layout, double angleX, 
	   double angleZ, double camera_zoom);

 private:
  
  void axes3D(int x1, int y1, int z1,
	      int x2, int y2, int z2,
	      int x3, int y3, int z3,
	      bool ticks, bool numbers, int last_tick, int first_tick = 0);

  void ticks3D(int x1, int y1, int z1,
	       int x2, int y2, int z2,
	       int x3, int y3, int z3,
	       bool ticks, bool numbers, int last_tick, int first_tick);

  void coordinates();
  void coordinatesGL();
  void dataGL();
  void perspective();

  virtual bool draw_help(int offset) = 0;
  virtual void draw_surface(int rOffset, int cOffset) = 0;

  double rotZ, rotX, zoom;
};

#endif

