#include "spyrender.h"
#include "mpi.h"
#include <math.h>

const int AXES_INDENT = 50;

SpyRender::SpyRender(int w, int h, int rank, double *data, int start_row,
		     int start_column, int nrows, int ncols, 
		     DistLayout *data_layout) : 
  Render(w, h, rank, data, start_row, start_column, nrows, ncols, 
	 data_layout, true) {
}

bool SpyRender::draw_help(int offset) {
 
  offset = offset * 6;

  lx = blocks_data[offset + 0];
  ly = blocks_data[offset + 1];
  data_nr = blocks_data[offset + 2] - lx + 1;
  data_nc = blocks_data[offset + 3] - ly + 1;

  int rOffset = blocks_data[offset + 4];
  int cOffset = blocks_data[offset + 5];

  if (data_nr <= 1 &&
      data_nc <= 1)
    return true;
    
  glBegin(GL_POINTS);
  for(int j=0; j<data_nc; j++)
    {
      for(int i = 0; i<data_nr; i++) 
	{
	  if(data_buffer[(j+cOffset)*lRows+(i+rOffset)]) {
	    nonzero++;
	    glVertex2f((j+ly+1), (i+lx+1));
	  }
	}
    }
  glEnd();

  return false;

}

void quad(int x1, int y1, int x2, int y2,
	  int x3, int y3, int x4, int y4) {

  glBegin(GL_QUADS);
  glVertex2i(x1, y1);
  glVertex2i(x2, y2);
  glVertex2i(x3, y3);
  glVertex2i(x4, y4);
  glEnd();

}

void SpyRender::done_drawing() {
  MPI_Allreduce(&nonzero, &num_nonzeros, 1, MPI_INT, MPI_SUM, MPI_COMM_WORLD);
  coordinatesGL();
  glColor3f(1, 0, 0);
  num(num_nonzeros, width/2, height - AXES_INDENT/2, 0);
}

void SpyRender::coordinates() {

  glColor3ub(GRAY, 0, 0);
  quad(0, 0, 0, AXES_INDENT, width, AXES_INDENT, width, 0);
  quad(0, 0, 0, height, AXES_INDENT, height, AXES_INDENT, 0);
  quad(0, height - AXES_INDENT, 0, height, width, height, width, 
       height - AXES_INDENT);
  quad(width - AXES_INDENT, 0, width - AXES_INDENT, height, width, height,
       width, 0);

  glColor3ub(BLACK, 0, 0);

  axes(AXES_INDENT, AXES_INDENT, 0, width - AXES_INDENT, AXES_INDENT, 0);
  axes(AXES_INDENT, AXES_INDENT, 0, AXES_INDENT, height - AXES_INDENT, 0);
  axes(AXES_INDENT, height - AXES_INDENT, 0, width - AXES_INDENT,
       height - AXES_INDENT, 0);
  axes(width - AXES_INDENT, AXES_INDENT, 0, width - AXES_INDENT,
       height - AXES_INDENT, 0);

}

void SpyRender::coordinatesGL() {
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glViewport(0, 0, width, height);
  glOrtho(0, width, height, 0, -1, 1);
  glMatrixMode(GL_MODELVIEW);

  glLineWidth(AXES_WIDTH);
  glColor3ub(BLACK, 0, 0);

}

void SpyRender::dataGL() {

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glViewport(AXES_INDENT, AXES_INDENT, width - 2 * AXES_INDENT, 
	     height - 2 * AXES_INDENT);
  glOrtho(sc, nc + 1, nr + 1, sr, -1, 1);
  glMatrixMode(GL_MODELVIEW);

  double point_size = min (width / nc, height / nr); 
  glPointSize(point_size);
  
  glColor3ub(FIRST_COLOR + (r % NUM_COLORS) * (NUM_COLORS - 1)/ 
	     (num_procs % NUM_COLORS), 0, 0);

}

