function varargout = ppsurf(varargin)
% PPSURF Application M-file for ppsurf.fig
%    FIG = PPSURF launch ppsurf GUI.
%    PPSURF('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 04-May-2002 22:44:23

if nargin == 1  % LAUNCH GUI
  [ecode,estr,H, W] = ppclient('ppsize',varargin{1});
  if ecode ~= 0
    error(estr);
  end

  if (H*W < 1024^2)
    surf(pp2matlab(varargin{1}));
    sprintf('Your Matrix is smaller than 1024x1024 elements.\nWe will for efficency reasons use the regular surf\n')
    return;
  end

  fig = openfig(mfilename,'reuse');
  global SURF1PINP;
  global SURF1LAST;
  global SURF1VARS;
  SURF1PINP = varargin{1};
  %  PHI THETA ZOOM
  SURF1VARS = [0 0 0 512 512];

  % Use system color scheme for figure:
  set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

  % Generate a structure of handles to pass to callbacks, and store it. 
  handles = guihandles(fig);

  set (handles.subaxes, 'Color', [1 1 1]);
  set (handles.mainaxes, 'Color', [1 1 1]);

  guidata(fig, handles);
  if nargout > 0
    varargout{1} = fig;
  end

%  axes(handles.mainaxes);
  %  SURF1LAST = SURF1PINP;
%  [ecode,estr,data] = ppclient('ppsurf',SURF1PINP,SURF1VARS(4), SURF1VARS(5),SURF1VARS(2),SURF1VARS(1),SURF1VARS(3));
%  if ecode ~= 0
%    error(estr);
%  end;

%  D(:,:,1) = reshape(data(1:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
%  D(:,:,2) = reshape(data(2:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
%  D(:,:,3) = reshape(data(3:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
%  SURF1LAST = D;

%  i = image(SURF1LAST);            % display
%  j = get(get(i, 'Parent'), 'Parent');
%  set(i, 'Parent', handles.mainaxes);
%  delete(j);
%  axes(handles.subaxes);

  
  
elseif nargin == 0 
  
  disp( 'Function needs one parameter');
  
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

  try
    if (nargout)
      [varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
    else
      feval(varargin{:}); % FEVAL switchyard
    end
  catch
    disp(lasterr);
  end
  
end


% --------------------------------------------------------------------
function varargout = zoomin_Callback(h, eventdata, handles, varargin)
global SURF1LAST;
global SURF1VARS;
global SURF1PINP;

SURF1VARS(3) = SURF1VARS(3)+1;

%SURF1LAST = SURF1PINP;
  [ecode,estr,data] = ppclient('ppsurf',SURF1PINP,SURF1VARS(4), SURF1VARS(5),SURF1VARS(2),SURF1VARS(1),SURF1VARS(3));
  if ecode ~= 0
    error(estr);
  end;

  D(:,:,1) = reshape(data(1:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,2) = reshape(data(2:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,3) = reshape(data(3:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  SURF1LAST = D;


displaynow(SURF1LAST, handles, SURF1VARS);
return;



% --------------------------------------------------------------------
function varargout = zoomout_Callback(h, eventdata, handles, varargin)

global SURF1VARS;
global SURF1PINP;
global SURF1LAST;

SURF1VARS(3) = SURF1VARS(3)-1;

%SURF1LAST = SURF1PINP;
  [ecode,estr,data] = ppclient('ppsurf',SURF1PINP,SURF1VARS(4), SURF1VARS(5),SURF1VARS(2),SURF1VARS(1),SURF1VARS(3));
  if ecode ~= 0
    error(estr);
  end;

  D(:,:,1) = reshape(data(1:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,2) = reshape(data(2:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,3) = reshape(data(3:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  SURF1LAST = D;

displaynow(SURF1LAST, handles, SURF1VARS);
return;




% --------------------------------------------------------------------
function varargout = reset_Callback(h, eventdata, handles, varargin)

global SURF1VARS;
global SURF1PINP;
global SURF1LAST;

SURF1VARS(1) = 0;
SURF1VARS(2) = 0;
SURF1VARS(3) = 0;

%SURF1LAST = SURF1PINP;
  [ecode,estr,data] = ppclient('ppsurf',SURF1PINP,SURF1VARS(4), SURF1VARS(5),SURF1VARS(2),SURF1VARS(1),SURF1VARS(3));
  if ecode ~= 0
    error(estr);
  end;

  D(:,:,1) = reshape(data(1:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,2) = reshape(data(2:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,3) = reshape(data(3:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  SURF1LAST = D;

displaynow(SURF1LAST, handles, SURF1VARS);
return;



% --------------------------------------------------------------------
function varargout = phibox_Callback(h, eventdata, handles, varargin)
global SURF1VARS;
global SURF1PINP;
global SURF1LAST;
user_entry = str2double(get(h,'string'));
if isnan(user_entry)
    errordlg('You must enter a numeric value','Bad Input','modal')
  else
    if user_entry > 180 
      user_entry = mod(user_entry+180, 360)-180;
    end
    if user_entry < -180 
      user_entry = mod(user_entry+180, 360)-180;
    end
    SURF1VARS(1) = user_entry;
%    SURF1LAST = SURF1PINP;
  [ecode,estr,data] = ppclient('ppsurf',SURF1PINP,SURF1VARS(4), SURF1VARS(5),SURF1VARS(2),SURF1VARS(1),SURF1VARS(3));
  if ecode ~= 0
    error(estr);
  end;

  D(:,:,1) = reshape(data(1:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,2) = reshape(data(2:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,3) = reshape(data(3:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  SURF1LAST = D;
    displaynow(SURF1LAST, handles, SURF1VARS);
end
% proceed with callback...

return;


% --------------------------------------------------------------------
function varargout = thetabox_Callback(h, eventdata, handles, varargin)
global SURF1VARS;
global SURF1PINP;
global SURF1LAST;
user_entry = str2double(get(h,'string'));
if isnan(user_entry)
    errordlg('You must enter a numeric value','Bad Input','modal')
  else
    if user_entry > 180 
      user_entry = mod(user_entry+180, 360)-180;
    end
    if user_entry < -180 
      user_entry = mod(user_entry+180, 360)-180;
    end
    SURF1VARS(2) = user_entry;
%    SURF1LAST = SURF1PINP;
  [ecode,estr,data] = ppclient('ppsurf',SURF1PINP,SURF1VARS(4), SURF1VARS(5),SURF1VARS(2),SURF1VARS(1),SURF1VARS(3));
  if ecode ~= 0
    error(estr);
  end;

  D(:,:,1) = reshape(data(1:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,2) = reshape(data(2:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,3) = reshape(data(3:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  SURF1LAST = D;
    displaynow(SURF1LAST, handles, SURF1VARS);
end
return;



% --------------------------------------------------------------------
function varargout = file_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = export_Callback(h, eventdata, handles, varargin)
global SURF1LAST;
[fname, pname] = uiputfile( {...
      '*.tif;*.tiff', 'Tagged Image File Format (TIFF)'; ...
      '*.jpg;*.jpeg', 'Joint Photographic Experts Group (JPEG)'; ...
      '*.bmp' , 'Windows Bitmap (BMP)'; ...
      '*.png' , 'Portable Network Graphics (PNG)' ; ...
      '*.hdf' , 'Hierarchical Data Format (HDF)' ; ...
      '*.pcx' , 'Windows Paintbrush (PCX)' ; ...
      '*.xwd' , 'X Window Dump (XWD)'}, ...
    'Export to ...');

if isequal(fname,0)|isequal(pname,0)
else
  full = [pname, fname];
  imwrite(SURF1LAST,full);
end
 
return;




% --------------------------------------------------------------------
function varargout = print_Callback(h, eventdata, handles, varargin)
printdlg;
return;




% --------------------------------------------------------------------
function varargout = close_Callback(h, eventdata, handles, varargin)
delete(handles.figure1);
return;




% --------------------------------------------------------------------
function varargout = about_Callback(h, eventdata, handles, varargin)
aboutspy1surf1;
return;




function varargout = displaynow(SURF1LAST, handles, SURF1VARS)
  phi = SURF1VARS(1);
  theta = SURF1VARS(2);
  set(handles.phibox, 'String', phi);
  set(handles.thetabox, 'String', theta);
  set (handles.zoomtext, 'String', SURF1VARS(3));
  axes(handles.subaxes);

  k = ones(361, 361, 3);
  i = image(k);
  set(i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');
  i = rectangle('Position', [0,180,361,0.001]);
  set (i, 'EdgeColor', [0 0 0]);
  set (i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');
  i = rectangle('Position', [180,0,0.0001,361]);
  set (i, 'EdgeColor', [0 0 0]);
  set (i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');
  i = rectangle('Curvature',[1, 1], 'Position', [180+phi-10, 180-theta-10, 20, 20]); %, 0,0,5,5]);
  set (i, 'EdgeColor', [1 0 0]);
  set (i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');
  
  
  
  i = text(180,0, '+180');
  set (i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');
  i = text(0,180, '-180');
  set (i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');
  i = text(180,+360, '-180');
  set (i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');
  i = text(+360,180, '+180');
  set (i, 'ButtonDownFcn', 'ppsurf(''subaxes_click_Callback'',gcbo,[],guidata(gcbo))');


  set(handles.subaxes, 'Visible', 'off');

  axes(handles.mainaxes);
  i = image(SURF1LAST);            % display
  set(handles.mainaxes, 'Visible', 'off');
return;




function varargout = subaxes_click_Callback(h, eventdata, ...
    handles, varargin)

global SURF1VARS;
global SURF1PINP;
global SURF1LAST;
j = get(handles.subaxes, 'Parent');

set(handles.subaxes, 'Units', get(j, 'Units'));

P = get(j, 'CurrentPoint');
phi = P(1);
theta = P(2);

P = get(handles.subaxes, 'Position');
MPHI = P(1); MTHETA = P(2); MW = P(3); MH = P(4);

phi = ((phi-MPHI)/MW)*360-180;
theta = ((theta-MTHETA)/MH)*360-170;

SURF1VARS(1) = phi;
SURF1VARS(2) = theta;


%SURF1LAST = SURF1PINP;
  [ecode,estr,data] = ppclient('ppsurf',SURF1PINP,SURF1VARS(4), SURF1VARS(5),SURF1VARS(2),SURF1VARS(1),SURF1VARS(3));
  if ecode ~= 0
    error(estr);
  end;

  D(:,:,1) = reshape(data(1:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,2) = reshape(data(2:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  D(:,:,3) = reshape(data(3:3:SURF1VARS(4)*SURF1VARS(5)*3), SURF1VARS(4), SURF1VARS(5));
  SURF1LAST = D;

displaynow(SURF1LAST, handles, SURF1VARS);


return;

